/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws;

import com.agorapulse.micronaut.aws.BasicAwsRegionProvider;
import com.agorapulse.micronaut.aws.EnvironmentAwsRegionProvider;
import com.agorapulse.micronaut.aws.SafeAwsRegionProviderChain;
import com.agorapulse.micronaut.aws.util.EnvironmentAWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.regions.AwsEnvVarOverrideRegionProvider;
import com.amazonaws.regions.AwsProfileRegionProvider;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.regions.AwsSystemPropertyRegionProvider;
import com.amazonaws.regions.InstanceMetadataRegionProvider;
import com.amazonaws.regions.Regions;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.env.Environment;
import jakarta.inject.Singleton;

@Factory
public class AwsConfiguration {
    private static final Regions DEFAULT_REGION = Regions.EU_WEST_1;

    @Bean
    @Singleton
    AWSCredentialsProvider defaultAwsCredentialsProvider(Environment environment) {
        return new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new EnvironmentAWSCredentialsProvider(environment), new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), new ProfileCredentialsProvider(), new EC2ContainerCredentialsProviderWrapper()});
    }

    @Bean
    @Singleton
    AwsRegionProvider defaultAwsRegionProvider(Environment environment) {
        return new SafeAwsRegionProviderChain(new AwsRegionProvider[]{new EnvironmentAwsRegionProvider(environment), new AwsEnvVarOverrideRegionProvider(), new AwsSystemPropertyRegionProvider(), new AwsProfileRegionProvider(), new InstanceMetadataRegionProvider(), new BasicAwsRegionProvider(DEFAULT_REGION.getName())});
    }
}

