/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.AwsRegionProvider;
import java.util.Optional;

public interface RegionAndEndpointConfiguration {
    public String getRegion();

    public String getEndpoint();

    default public <C, B extends AwsClientBuilder<B, C>> B configure(B builder, AwsRegionProvider awsRegionProvider) {
        String region = Optional.ofNullable(this.getRegion()).orElseGet(() -> ((AwsRegionProvider)awsRegionProvider).getRegion());
        if (this.getEndpoint() != null) {
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getEndpoint(), region));
        } else {
            builder.setRegion(region);
        }
        return builder;
    }
}

