/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws;

import com.amazonaws.regions.AwsRegionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SafeAwsRegionProviderChain
extends AwsRegionProvider {
    private static final Log LOG = LogFactory.getLog(SafeAwsRegionProviderChain.class);
    private final List<AwsRegionProvider> providers;

    public SafeAwsRegionProviderChain(AwsRegionProvider ... providers) {
        this.providers = new ArrayList<AwsRegionProvider>(providers.length);
        Collections.addAll(this.providers, providers);
    }

    public String getRegion() {
        for (AwsRegionProvider provider : this.providers) {
            try {
                String region = provider.getRegion();
                if (region == null) continue;
                return region;
            }
            catch (Exception e) {
                LOG.info((Object)("Unable to load region from " + provider.toString() + ": " + e.getMessage()));
            }
        }
        return null;
    }
}

