/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.util;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.util.StringUtils;
import io.micronaut.context.env.Environment;

public class EnvironmentAWSCredentialsProvider
implements AWSCredentialsProvider {
    public static final String ACCESS_KEY_ENV_VAR = "aws.access-key-id";
    public static final String ALTERNATE_ACCESS_KEY_ENV_VAR = "aws.access-key";
    public static final String SECRET_KEY_ENV_VAR = "aws.secret-key";
    public static final String ALTERNATE_SECRET_KEY_ENV_VAR = "aws.secret-access-key";
    public static final String AWS_SESSION_TOKEN_ENV_VAR = "aws.session-token";
    private final Environment environment;

    public EnvironmentAWSCredentialsProvider(Environment environment) {
        this.environment = environment;
    }

    public AWSCredentials getCredentials() {
        String accessKey = (String)this.environment.getProperty(ACCESS_KEY_ENV_VAR, String.class, (Object)((String)this.environment.getProperty(ALTERNATE_ACCESS_KEY_ENV_VAR, String.class, (Object)null)));
        String secretKey = (String)this.environment.getProperty(SECRET_KEY_ENV_VAR, String.class, (Object)((String)this.environment.getProperty(ALTERNATE_SECRET_KEY_ENV_VAR, String.class, (Object)null)));
        accessKey = StringUtils.trim((String)accessKey);
        secretKey = StringUtils.trim((String)secretKey);
        String sessionToken = StringUtils.trim((String)((String)this.environment.getProperty(AWS_SESSION_TOKEN_ENV_VAR, String.class, (Object)null)));
        if (StringUtils.isNullOrEmpty((String)accessKey) || StringUtils.isNullOrEmpty((String)secretKey)) {
            throw new SdkClientException("Unable to load AWS credentials from environment (aws.access-key-id (or aws.access-key) and aws.secret-key (or aws.secret-access-key))");
        }
        return sessionToken == null ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
    }

    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

