/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb;

import com.agorapulse.micronaut.aws.dynamodb.DynamoDBMetadata;
import com.agorapulse.micronaut.aws.dynamodb.DynamoDBService;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverterFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.IDynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedQueryList;
import com.amazonaws.services.dynamodbv2.datamodeling.QueryResultPage;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import io.micronaut.core.naming.NameUtils;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultDynamoDBService<TItemClass>
implements DynamoDBService<TItemClass>,
GroovyObject {
    private static final ConversionSchema GROOVY_AWARE_CONVERSION_SCHEMA;
    public static final String INDEX_NAME_SUFFIX = "Index";
    public static final String SERIALIZED_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String SERIALIZED_DATE_TIMEZONE = "GMT";
    public static final int DEFAULT_READ_CAPACTIY = 2;
    public static final int DEFAULT_WRITE_CAPACITY = 2;
    public static final String BATCH_ENABLED_KEY = "batchEnabled";
    public static final int ONE_SECOND = 1000;
    public static final String MAX_AFTER_DATE_KEY = "maxAfterDate";
    public static final String AFTER_KEY = "after";
    public static final String BEFORE_KEY = "before";
    protected final AmazonDynamoDB client;
    protected final IDynamoDBMapper mapper;
    protected DynamoDBMetadata<TItemClass> metadata;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    protected DefaultDynamoDBService(AmazonDynamoDB client, IDynamoDBMapper mapper, Class<TItemClass> itemClass) {
        IDynamoDBMapper iDynamoDBMapper;
        AmazonDynamoDB amazonDynamoDB;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.client = amazonDynamoDB = client;
        this.mapper = iDynamoDBMapper = mapper;
        CallSite callSite = IndyInterface.bootstrap("invoke", "create", 0, DynamoDBMetadata.class, itemClass);
        this.metadata = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public static String serializeDate(Date date) {
        CallSite dateFormatter = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, SimpleDateFormat.class, SERIALIZED_DATE_FORMAT, IndyInterface.bootstrap("getProperty", "ENGLISH", 0, Locale.class)));
        CallSite callSite = IndyInterface.bootstrap("invoke", "getTimeZone", 0, TimeZone.class, SERIALIZED_DATE_TIMEZONE);
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)dateFormatter, (String)"timeZone");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "format", 0, dateFormatter, date));
    }

    public static String serializeDate(Instant instant) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "format", 0, IndyInterface.bootstrap("invoke", "withZone", 0, IndyInterface.bootstrap("invoke", "ofPattern", 0, DateTimeFormatter.class, SERIALIZED_DATE_FORMAT), IndyInterface.bootstrap("invoke", "toZoneId", 0, IndyInterface.bootstrap("invoke", "getTimeZone", 0, TimeZone.class, SERIALIZED_DATE_TIMEZONE))), instant));
    }

    public static void nullifyHashSets(Object object) {
        Reference object2 = new Reference(object);
        public final class _nullifyHashSets_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference object;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _nullifyHashSets_closure1(Object _outerInstance, Object _thisObject, Reference object) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.object = reference = object;
            }

            public Object doCall(String prop, Object val) {
                block7: {
                    if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "hasProperty", 0, this.object.get(), prop)) && IndyInterface.bootstrap("invoke", "getAt", 0, this.object.get(), prop) instanceof HashSet && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("invoke", "getAt", 0, this.object.get(), prop)), (Object)0)) {
                        CallSite getter = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getMethod", 0, IndyInterface.bootstrap("invoke", "getClass", 0, this.object.get()), IndyInterface.bootstrap("invoke", "getterNameFor", 0, NameUtils.class, prop)));
                        if (!(ScriptBytecodeAdapter.compareNotEqual((Object)getter, null) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAnnotation", 0, getter, DynamoDBIgnore.class), null))) break block7;
                        Object var4_4 = null;
                        IndyInterface.bootstrap("invoke", "putAt", 0, this.object.get(), prop, var4_4);
                        Object var5_5 = var4_4;
                        try {
                            return var5_5;
                        }
                        catch (Exception e) {
                            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{prop, this.object.get()}, new String[]{"failed to nullify collection ", " of ", " before sending to DynamoDB"}), e) : null;
                            return callSite;
                        }
                    }
                }
                return null;
            }

            @Generated
            public Object call(String prop, Object val) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, prop, val);
            }

            @Generated
            public Object getObject() {
                return this.object.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _nullifyHashSets_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "properties", 0, object2.get()), new _nullifyHashSets_closure1(DefaultDynamoDBService.class, DefaultDynamoDBService.class, object2));
    }

    @Override
    public int count(Object hashKey, String rangeKeyName, Object rangeKeyValue, ComparisonOperator operator, Map settings) {
        Map conditions = IndyInterface.bootstrap("cast", "()", 0, rangeKeyValue) != false ? ScriptBytecodeAdapter.createMap((Object[])new Object[]{rangeKeyName, IndyInterface.bootstrap("invoke", "buildCondition", 0, DefaultDynamoDBService.class, rangeKeyValue, operator)}) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "countByConditions", 2, this, hashKey, conditions, settings));
    }

    @Override
    public int countByDates(Object hashKey, String rangeKeyName, Map rangeKeyDates, Map settings) {
        CallSite conditions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildDateConditions", 0, DefaultDynamoDBService.class, rangeKeyName, rangeKeyDates, ScriptBytecodeAdapter.createPojoWrapper((Object)((Date)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, settings, MAX_AFTER_DATE_KEY), Date.class))), Date.class)));
        return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "countByConditions", 2, this, hashKey, conditions, settings));
    }

    @Override
    public int countByConditions(Object hashKey, Map<String, Condition> rangeKeyConditions, Map querySettings) {
        CallSite settings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, LinkedHashMap.class, querySettings));
        IndyInterface.bootstrap("invoke", "putAll", 0, settings, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"batchGetDisabled", true}));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "limit", 0, settings)) == false) {
            IndyInterface.bootstrap("invoke", "putAll", 0, settings, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"limit", IndyInterface.bootstrap("getProperty", "DEFAULT_COUNT_LIMIT", 12, this)}));
        }
        CallSite resultPage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "queryByConditions", 2, this, hashKey, rangeKeyConditions, settings));
        CallSite callSite = IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("getProperty", "results", 1, resultPage));
        return DefaultTypeTransformation.intUnbox((Object)(IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0)));
    }

    @Override
    public CreateTableResult createTable(Long readCapacityUnits, Long writeCapacityUnits) {
        CallSite table = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAnnotation", 0, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata), DynamoDBTable.class));
        IndyInterface.bootstrap("invoke", "describeTable", 0, this.client, IndyInterface.bootstrap("invoke", "tableName", 0, table));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, null);
        try {
            return callSite;
        }
        catch (ResourceNotFoundException ignored) {
            CallSite createTableRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "generateCreateTableRequest", 0, this.mapper, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata)));
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "withWriteCapacityUnits", 0, IndyInterface.bootstrap("invoke", "withReadCapacityUnits", 0, IndyInterface.bootstrap("init", "<init>", 0, ProvisionedThroughput.class), readCapacityUnits), writeCapacityUnits);
            ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)createTableRequest, (String)"provisionedThroughput");
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "globalSecondaryIndexes", 0, createTableRequest)) != false) {
                public final class _createTable_closure2
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _createTable_closure2(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(GlobalSecondaryIndex globalSecondaryIndex) {
                        CallSite callSite = IndyInterface.bootstrap("invoke", "withWriteCapacityUnits", 0, IndyInterface.bootstrap("invoke", "withReadCapacityUnits", 0, IndyInterface.bootstrap("init", "<init>", 0, ProvisionedThroughput.class), IndyInterface.bootstrap("getProperty", "DEFAULT_READ_CAPACTIY", 12, this)), IndyInterface.bootstrap("getProperty", "DEFAULT_WRITE_CAPACITY", 12, this));
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)globalSecondaryIndex, (String)"provisionedThroughput");
                        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{globalSecondaryIndex}, new String[]{"Creating DynamoDB GSI: ", ""})) : null;
                    }

                    @Generated
                    public Object call(GlobalSecondaryIndex globalSecondaryIndex) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, globalSecondaryIndex);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _createTable_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "globalSecondaryIndexes", 0, createTableRequest), new _createTable_closure2(this, this));
            }
            CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{createTableRequest}, new String[]{"Creating DynamoDB table: ", ""})) : null;
            CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createTable", 0, this.client, createTableRequest));
            return callSite4;
        }
    }

    @Override
    public void delete(Object hashKey, Object rangeKey, Map settings) {
        if (IndyInterface.bootstrap("cast", "()", 0, rangeKey) != false) {
            IndyInterface.bootstrap("invoke", "delete", 2, this, IndyInterface.bootstrap("invoke", "newInstance", 0, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata), ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "hashKeyName", 12, this), hashKey, IndyInterface.bootstrap("getProperty", "rangeKeyName", 12, this), rangeKey})), settings);
            return;
        }
        IndyInterface.bootstrap("invoke", "delete", 2, this, IndyInterface.bootstrap("invoke", "newInstance", 0, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata), ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "hashKeyName", 12, this), hashKey})), settings);
    }

    @Override
    public void deleteAll(List<TItemClass> itemsToDelete, Map querySettings) {
        CallSite settings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, LinkedHashMap.class, querySettings));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, settings, BATCH_ENABLED_KEY)) == false) {
            IndyInterface.bootstrap("invoke", "putAll", 0, settings, ScriptBytecodeAdapter.createMap((Object[])new Object[]{BATCH_ENABLED_KEY, true}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", BATCH_ENABLED_KEY, 0, settings)) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, itemsToDelete), (Object)1)) {
            public final class _deleteAll_closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _deleteAll_closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(List batchItems) {
                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{batchItems}, new String[]{"Deleting items from DynamoDB ", ""})) : null;
                    return IndyInterface.bootstrap("invoke", "batchDelete", 0, IndyInterface.bootstrap("getProperty", "mapper", 12, this), batchItems);
                }

                @Generated
                public Object call(List batchItems) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, batchItems);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _deleteAll_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "collate", 0, itemsToDelete, IndyInterface.bootstrap("getProperty", "WRITE_BATCH_SIZE", 12, this)), new _deleteAll_closure3(this, this));
        } else {
            public final class _deleteAll_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _deleteAll_closure4(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{it}, new String[]{"Deleting item from DynamoDB ", ""})) : null;
                    return IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("getProperty", "mapper", 12, this), it);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _deleteAll_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, itemsToDelete, new _deleteAll_closure4(this, this));
        }
    }

    @Override
    public int deleteAll(Object hashKey, String rangeKeyName, Object rangeKeyValue, ComparisonOperator operator, Map settings) {
        Map conditions = ScriptBytecodeAdapter.createMap((Object[])new Object[]{rangeKeyName, IndyInterface.bootstrap("invoke", "buildCondition", 0, DefaultDynamoDBService.class, rangeKeyValue, operator)});
        return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "deleteAllByConditions", 2, this, hashKey, conditions, settings));
    }

    @Override
    public int deleteAllByConditions(Object hashKey, Map<String, Condition> rangeKeyConditions, Map querySettings, String indexName) {
        CallSite settings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, LinkedHashMap.class, querySettings));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, settings, BATCH_ENABLED_KEY)) == false) {
            IndyInterface.bootstrap("invoke", "putAll", 0, settings, ScriptBytecodeAdapter.createMap((Object[])new Object[]{BATCH_ENABLED_KEY, true}));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "limit", 0, settings)) == false) {
            IndyInterface.bootstrap("invoke", "putAll", 0, settings, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"limit", IndyInterface.bootstrap("getProperty", "BATCH_DELETE_LIMIT", 12, this)}));
        }
        CallSite query = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildQueryExpression", 0, DefaultDynamoDBService.class, IndyInterface.bootstrap("getProperty", "hashKeyName", 12, this), hashKey, settings));
        CallSite callSite = IndyInterface.bootstrap("invoke", "newInstance", 0, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata), ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "hashKeyName", 12, this), hashKey}));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)query, (String)"hashKeyValues");
        if (IndyInterface.bootstrap("cast", "()", 0, rangeKeyConditions) != false) {
            Map<String, Condition> map = rangeKeyConditions;
            ScriptBytecodeAdapter.setProperty(map, null, (Object)query, (String)"rangeKeyConditions");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, indexName) != false) {
            String string = indexName;
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)query, (String)"indexName");
        }
        return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "deleteAllByConditions", 2, this, query, settings));
    }

    @Override
    public int deleteAllByConditions(DynamoDBQueryExpression query, Map settings) {
        CallSite itemsPage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "queryPage", 0, this.mapper, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata), query));
        int deletedItemsCount = -1;
        CallSite lastEvaluatedKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "lastEvaluatedKey", 0, itemsPage));
        while (DefaultTypeTransformation.booleanUnbox((Object)lastEvaluatedKey) || deletedItemsCount == -1) {
            if (deletedItemsCount == -1) {
                deletedItemsCount = 0;
            } else {
                CallSite callSite = lastEvaluatedKey;
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)query, (String)"exclusiveStartKey");
            }
            itemsPage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "queryPage", 0, this.mapper, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata), query));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "results", 0, itemsPage)) != false) {
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "results", 0, itemsPage)), IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata)}, new String[]{"Deleting ", " items, class: ", ""})) : null;
                deletedItemsCount = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "plus", 0, deletedItemsCount, IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "results", 0, itemsPage))));
                IndyInterface.bootstrap("invoke", "deleteAll", 2, this, IndyInterface.bootstrap("getProperty", "results", 0, itemsPage), settings);
            }
            lastEvaluatedKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "lastEvaluatedKey", 0, itemsPage));
        }
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{deletedItemsCount}, new String[]{"Successfully deleted ", " items"})) : null;
        return deletedItemsCount;
    }

    @Override
    public TItemClass get(Object hashKey, Object rangeKey) {
        return (TItemClass)IndyInterface.bootstrap("invoke", "load", 0, this.mapper, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata), hashKey, rangeKey);
    }

    @Override
    public List<TItemClass> getAll(Object hashKey, List rangeKeys, Map settings) {
        Reference hashKey2 = new Reference(hashKey);
        Reference result = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public final class _getAll_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference hashKey;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAll_closure5(Object _outerInstance, Object _thisObject, Reference hashKey) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.hashKey = reference = hashKey;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "newInstance", 0, IndyInterface.bootstrap("getProperty", "itemClass", 4, IndyInterface.bootstrap("getProperty", "metadata", 12, this)), ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "hashKeyName", 12, this), this.hashKey.get(), IndyInterface.bootstrap("getProperty", "rangeKeyName", 12, this), it}));
            }

            @Generated
            public Object getHashKey() {
                return this.hashKey.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAll_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite objects = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "unique", 0, rangeKeys, false), new _getAll_closure5(this, this, hashKey2)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "throttle", 0, settings)) != false) {
            Reference resultCursor = new Reference((Object)0);
            Reference readCapacityUnit = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "readCapacityUnit", 0, settings)));
            if (IndyInterface.bootstrap("cast", "()", 0, (Long)readCapacityUnit.get()) == false) {
                CallSite tableResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "describeTable", 0, this.client, IndyInterface.bootstrap("invoke", "tableName", 0, IndyInterface.bootstrap("getProperty", "mainTable", 4, this.metadata))));
                CallSite callSite = IndyInterface.bootstrap("getProperty", "readCapacityUnits", 1, IndyInterface.bootstrap("getProperty", "provisionedThroughput", 1, IndyInterface.bootstrap("getProperty", "table", 1, tableResult)));
                readCapacityUnit.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(10)));
            }
            public final class _getAll_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference result;
                private /* synthetic */ Reference resultCursor;
                private /* synthetic */ Reference readCapacityUnit;
                private static /* synthetic */ BigDecimal $const$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAll_closure6(Object _outerInstance, Object _thisObject, Reference result, Reference resultCursor, Reference readCapacityUnit) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.result = reference3 = result;
                    this.resultCursor = reference2 = resultCursor;
                    this.readCapacityUnit = reference = readCapacityUnit;
                }

                public Object doCall(List batchObjects) {
                    this.result.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("cast", "()", 0, this.result.get()), IndyInterface.bootstrap("invoke", "batchLoad", 0, IndyInterface.bootstrap("getProperty", "mapper", 12, this), batchObjects))));
                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, this.resultCursor.get());
                    this.resultCursor.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "next", 0, callSite)));
                    if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("cast", "()", 0, this.readCapacityUnit.get())) && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.resultCursor.get()), (Object)IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("cast", "()", 0, this.readCapacityUnit.get()), $const$0))) {
                        int n = 0;
                        this.resultCursor.set((Object)n);
                        return IndyInterface.bootstrap("invoke", "sleep", 2, this, IndyInterface.bootstrap("getProperty", "ONE_SECOND", 12, this));
                    }
                    return null;
                }

                @Generated
                public Object call(List batchObjects) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, batchObjects);
                }

                @Generated
                public Map getResult() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.result.get());
                }

                @Generated
                public Integer getResultCursor() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.resultCursor.get());
                }

                @Generated
                public Long getReadCapacityUnit() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.readCapacityUnit.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAll_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }

                public static /* synthetic */ void __$swapInit() {
                    BigDecimal bigDecimal;
                    $const$0 = bigDecimal = new BigDecimal("0.8");
                }

                static {
                    _getAll_closure6.__$swapInit();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "collate", 0, objects, 20), new _getAll_closure6(this, this, result, resultCursor, readCapacityUnit));
        } else {
            result.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "batchLoad", 0, this.mapper, objects)));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, (Map)result.get(), IndyInterface.bootstrap("invoke", "tableName", 0, IndyInterface.bootstrap("getProperty", "mainTable", 4, this.metadata)))) != false) {
            Reference unorderedItems = new Reference((Object)((List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, (Map)result.get(), IndyInterface.bootstrap("invoke", "tableName", 0, IndyInterface.bootstrap("getProperty", "mainTable", 4, this.metadata))), List.class))));
            Reference items = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            public final class _getAll_closure7
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference unorderedItems;
                private /* synthetic */ Reference items;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAll_closure7(Object _outerInstance, Object _thisObject, Reference unorderedItems, Reference items) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.unorderedItems = reference2 = unorderedItems;
                    this.items = reference = items;
                }

                public Object doCall(Object rangeKey) {
                    Reference rangeKey2 = new Reference(rangeKey);
                    public final class _closure14
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference rangeKey;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure14(Object _outerInstance, Object _thisObject, Reference rangeKey) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.rangeKey = reference = rangeKey;
                        }

                        public Object doCall(Object item) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, item, IndyInterface.bootstrap("getProperty", "rangeKeyName", 12, this)), (Object)this.rangeKey.get());
                        }

                        @Generated
                        public Object getRangeKey() {
                            return this.rangeKey.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure14.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite matchingItem = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.unorderedItems.get()), new _closure14((Object)this, this.getThisObject(), rangeKey2));
                    if (IndyInterface.bootstrap("cast", "()", 0, matchingItem) != false) {
                        IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.items.get()), matchingItem);
                    }
                    return IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("cast", "()", 0, this.unorderedItems.get()), matchingItem);
                }

                @Generated
                public List getUnorderedItems() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.unorderedItems.get());
                }

                @Generated
                public List getItems() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.items.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAll_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, rangeKeys, new _getAll_closure7(this, this, unorderedItems, items));
            return (List)items.get();
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    @Override
    public Integer increment(Object hashKey, Object rangeKey, String attributeName, int attributeIncrement) {
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "updateItemAttribute", 2, this, hashKey, rangeKey, attributeName, attributeIncrement, IndyInterface.bootstrap("getProperty", "ADD", 0, AttributeAction.class)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toInteger", 1, IndyInterface.bootstrap("getProperty", "n", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attributes", 1, result), attributeName))));
    }

    @Override
    public TItemClass getNewInstance() {
        return (TItemClass)IndyInterface.bootstrap("invoke", "newInstance", 0, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata));
    }

    @Override
    public PaginatedQueryList<TItemClass> query(DynamoDBQueryExpression queryExpression) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "query", 0, this.mapper, IndyInterface.bootstrap("getProperty", "itemClass", 0, this.metadata), queryExpression));
    }

    @Override
    public QueryResultPage<TItemClass> query(Object hashKey, String rangeKeyName, Object rangeKeyValue, ComparisonOperator operator, Map settings) {
        if (ScriptBytecodeAdapter.compareEqual((Object)rangeKeyValue, (Object)"ANY") || IndyInterface.bootstrap("cast", "()", 0, operator) == false) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "endsWith", 0, rangeKeyName, INDEX_NAME_SUFFIX)) == false) {
                rangeKeyName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, rangeKeyName, INDEX_NAME_SUFFIX));
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "queryByConditions", 2, this, hashKey, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), settings, rangeKeyName));
        }
        Map conditions = ScriptBytecodeAdapter.createMap((Object[])new Object[]{rangeKeyName, IndyInterface.bootstrap("invoke", "buildCondition", 0, DefaultDynamoDBService.class, rangeKeyValue, operator)});
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "queryByConditions", 2, this, hashKey, conditions, settings));
    }

    @Override
    public QueryResultPage<TItemClass> queryByConditions(Object hashKey, Map<String, Condition> rangeKeyConditions, Map settings, String indexName) {
        CallSite query = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildQuery", 2, this, hashKey, settings, rangeKeyConditions, indexName));
        long readCapacityUnit = 0;
        int resultCursor = 0;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "returnAll", 0, settings)) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchResults", 2, this, IndyInterface.bootstrap("invoke", "queryPage", 0, this.mapper, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata), query), rangeKeyConditions, indexName, settings, hashKey, readCapacityUnit));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "throttle", 0, settings)) != false) {
            CallSite tableResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "describeTable", 0, this.client, IndyInterface.bootstrap("invoke", "tableName", 0, IndyInterface.bootstrap("getProperty", "mainTable", 4, this.metadata))));
            CallSite callSite = IndyInterface.bootstrap("getProperty", "readCapacityUnits", 1, IndyInterface.bootstrap("getProperty", "provisionedThroughput", 1, IndyInterface.bootstrap("getProperty", "table", 1, tableResult)));
            readCapacityUnit = DefaultTypeTransformation.longUnbox((Object)(IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0)));
        }
        Object lastEvaluatedKey = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"items", "none"});
        CallSite resultPage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, QueryResultPage.class));
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)resultPage, (String)"results");
        while (IndyInterface.bootstrap("cast", "()", 0, lastEvaluatedKey) != false) {
            CallSite currentPage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "queryPage", 0, this.mapper, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata), query));
            IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("getProperty", "results", 0, resultPage), IndyInterface.bootstrap("getProperty", "results", 0, currentPage));
            lastEvaluatedKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "lastEvaluatedKey", 0, currentPage));
            CallSite callSite = IndyInterface.bootstrap("getProperty", "lastEvaluatedKey", 0, currentPage);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)query, (String)"exclusiveStartKey");
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "throttle", 0, settings)) == false) continue;
            int n = resultCursor;
            resultCursor = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
            if (!(DefaultTypeTransformation.booleanUnbox((Object)readCapacityUnit) && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)resultCursor, (Object)IndyInterface.bootstrap("invoke", "multiply", 0, readCapacityUnit, $const$0)))) continue;
            resultCursor = 0;
            IndyInterface.bootstrap("invoke", "sleep", 2, this, ONE_SECOND);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchResults", 2, this, resultPage, rangeKeyConditions, indexName, settings, hashKey, readCapacityUnit));
    }

    @Override
    public QueryResultPage<TItemClass> queryByDates(Object hashKey, String rangeKeyName, Map rangeKeyDates, Map settings) {
        CallSite conditions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildDateConditions", 0, DefaultDynamoDBService.class, rangeKeyName, rangeKeyDates, ScriptBytecodeAdapter.createPojoWrapper((Object)((Date)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, settings, MAX_AFTER_DATE_KEY), Date.class))), Date.class)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "queryByConditions", 2, this, hashKey, conditions, settings));
    }

    @Override
    public List<TItemClass> saveAll(List<TItemClass> itemsToSave, Map querySettings) {
        Reference settings = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, LinkedHashMap.class, querySettings)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, (Map)settings.get(), BATCH_ENABLED_KEY)) == false) {
            IndyInterface.bootstrap("invoke", "putAll", 0, (Map)settings.get(), ScriptBytecodeAdapter.createMap((Object[])new Object[]{BATCH_ENABLED_KEY, true}));
        }
        public final class _saveAll_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _saveAll_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object object) {
                return IndyInterface.bootstrap("invoke", "nullifyHashSets", 2, this, object);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _saveAll_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, itemsToSave, new _saveAll_closure8(this, this));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{itemsToSave}, new String[]{"Saving items in DynamoDB ", ""})) : null;
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", BATCH_ENABLED_KEY, 0, (Map)settings.get())) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, itemsToSave), (Object)1)) {
            public final class _saveAll_closure9
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference settings;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _saveAll_closure9(Object _outerInstance, Object _thisObject, Reference settings) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.settings = reference = settings;
                }

                public Object doCall(List<TItemClass> batchItems) {
                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{batchItems}, new String[]{"Saving batched items in DynamoDB ", ""})) : null;
                    CallSite failedBatchResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "config", 0, IndyInterface.bootstrap("cast", "()", 0, this.settings.get()))) != false ? IndyInterface.bootstrap("invoke", "batchSave", 0, IndyInterface.bootstrap("getProperty", "mapper", 12, this), batchItems, IndyInterface.bootstrap("getProperty", "config", 0, IndyInterface.bootstrap("cast", "()", 0, this.settings.get()))) : IndyInterface.bootstrap("invoke", "batchSave", 0, IndyInterface.bootstrap("getProperty", "mapper", 12, this), batchItems));
                    if (IndyInterface.bootstrap("cast", "()", 0, failedBatchResult) != false) {
                        public final class _closure15
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure15(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(DynamoDBMapper.FailedBatch failedBatch) {
                                Reference failedBatch2 = new Reference((Object)failedBatch);
                                Reference unprocessedItemsCount = new Reference((Object)0);
                                public final class _closure16
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference unprocessedItemsCount;
                                    private /* synthetic */ Reference failedBatch;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure16(Object _outerInstance, Object _thisObject, Reference unprocessedItemsCount, Reference failedBatch) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        this.unprocessedItemsCount = reference2 = unprocessedItemsCount;
                                        this.failedBatch = reference = failedBatch;
                                    }

                                    public Object doCall(String key) {
                                        CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("cast", "()", 0, this.unprocessedItemsCount.get()), IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "unprocessedItems", 0, IndyInterface.bootstrap("cast", "()", 0, this.failedBatch.get())), key)));
                                        this.unprocessedItemsCount.set((Object)IndyInterface.bootstrap("cast", "()", 0, callSite));
                                        return callSite;
                                    }

                                    @Generated
                                    public Object call(String key) {
                                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, key);
                                    }

                                    @Generated
                                    public Integer getUnprocessedItemsCount() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.unprocessedItemsCount.get());
                                    }

                                    @Generated
                                    public DynamoDBMapper.FailedBatch getFailedBatch() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.failedBatch.get());
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure16.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "keySet", 0, IndyInterface.bootstrap("getProperty", "unprocessedItems", 0, (DynamoDBMapper.FailedBatch)failedBatch2.get())), new _closure16((Object)this, this.getThisObject(), unprocessedItemsCount, failedBatch2));
                                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{(Integer)unprocessedItemsCount.get()}, new String[]{"Failed batch with ", " unprocessed items"})) : null;
                                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "exception", 0, (DynamoDBMapper.FailedBatch)failedBatch2.get())}, new String[]{"Exception: ", ""})) : null;
                                throw (Throwable)((Object)IndyInterface.bootstrap("getProperty", "exception", 0, (DynamoDBMapper.FailedBatch)failedBatch2.get()));
                            }

                            @Generated
                            public Object call(DynamoDBMapper.FailedBatch failedBatch) {
                                Reference failedBatch2 = new Reference((Object)failedBatch);
                                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (DynamoDBMapper.FailedBatch)failedBatch2.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure15.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "each", 0, failedBatchResult, new _closure15((Object)this, this.getThisObject()));
                    }
                    return null;
                }

                @Generated
                public Object call(List<TItemClass> batchItems) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, batchItems);
                }

                @Generated
                public Map getSettings() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.settings.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _saveAll_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "collate", 0, itemsToSave, IndyInterface.bootstrap("getProperty", "WRITE_BATCH_SIZE", 12, this)), new _saveAll_closure9(this, this, settings));
            return itemsToSave;
        }
        Reference config = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "config", 0, (Map)settings.get())) != false ? (DynamoDBMapperConfig)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "config", 0, (Map)settings.get()), DynamoDBMapperConfig.class) : IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "withConversionSchema", 0, IndyInterface.bootstrap("invoke", "withTypeConverterFactory", 0, IndyInterface.bootstrap("invoke", "withBatchLoadRetryStrategy", 0, IndyInterface.bootstrap("invoke", "withBatchWriteRetryStrategy", 0, IndyInterface.bootstrap("invoke", "withTableNameResolver", 0, IndyInterface.bootstrap("invoke", "withPaginationLoadingStrategy", 0, IndyInterface.bootstrap("invoke", "withConsistentReads", 0, IndyInterface.bootstrap("invoke", "withSaveBehavior", 0, IndyInterface.bootstrap("invoke", "builder", 0, DynamoDBMapperConfig.class), IndyInterface.bootstrap("getProperty", "UPDATE", 0, DynamoDBMapperConfig.SaveBehavior.class)), IndyInterface.bootstrap("getProperty", "EVENTUAL", 0, DynamoDBMapperConfig.ConsistentReads.class)), IndyInterface.bootstrap("getProperty", "LAZY_LOADING", 0, DynamoDBMapperConfig.PaginationLoadingStrategy.class)), IndyInterface.bootstrap("getProperty", "INSTANCE", 0, DynamoDBMapperConfig.DefaultTableNameResolver.class)), IndyInterface.bootstrap("getProperty", "INSTANCE", 0, DynamoDBMapperConfig.DefaultBatchWriteRetryStrategy.class)), IndyInterface.bootstrap("getProperty", "INSTANCE", 0, DynamoDBMapperConfig.DefaultBatchLoadRetryStrategy.class)), IndyInterface.bootstrap("invoke", "standard", 0, DynamoDBTypeConverterFactory.class)), GROOVY_AWARE_CONVERSION_SCHEMA))));
        public final class _saveAll_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference config;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _saveAll_closure10(Object _outerInstance, Object _thisObject, Reference config) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.config = reference = config;
            }

            public Object doCall(Object it) {
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{it}, new String[]{"Saving item in DynamoDB ", ""})) : null;
                return IndyInterface.bootstrap("invoke", "save", 0, IndyInterface.bootstrap("getProperty", "mapper", 12, this), it, IndyInterface.bootstrap("cast", "()", 0, this.config.get()));
            }

            @Generated
            public DynamoDBMapperConfig getConfig() {
                return IndyInterface.bootstrap("cast", "()", 0, this.config.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _saveAll_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "each", 0, itemsToSave, new _saveAll_closure10(this, this, config)));
    }

    @Override
    public UpdateItemResult deleteItemAttribute(Object hashKey, Object rangeKey, String attributeName) {
        Map key = ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "hashKeyName", 12, this), IndyInterface.bootstrap("invoke", "buildAttributeValue", 0, DefaultDynamoDBService.class, hashKey)});
        if (IndyInterface.bootstrap("cast", "()", 0, rangeKey) != false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "buildAttributeValue", 0, DefaultDynamoDBService.class, rangeKey);
            IndyInterface.bootstrap("invoke", "putAt", 0, key, IndyInterface.bootstrap("getProperty", "rangeKeyName", 12, this), callSite);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "addAttributeUpdatesEntry", 0, IndyInterface.bootstrap("init", "<init>", 0, UpdateItemRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableName", IndyInterface.bootstrap("invoke", "tableName", 0, IndyInterface.bootstrap("getProperty", "mainTable", 4, this.metadata)), "key", key, "returnValues", IndyInterface.bootstrap("getProperty", "UPDATED_NEW", 0, ReturnValue.class)})), attributeName, IndyInterface.bootstrap("init", "<init>", 0, AttributeValueUpdate.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", IndyInterface.bootstrap("getProperty", "DELETE", 0, AttributeAction.class)}))));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "updateItem", 0, this.client, request));
    }

    @Override
    public UpdateItemResult updateItemAttribute(Object hashKey, Object rangeKey, String attributeName, Object attributeValue, AttributeAction action) {
        Map key = ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "hashKeyName", 12, this), IndyInterface.bootstrap("invoke", "buildAttributeValue", 0, DefaultDynamoDBService.class, hashKey)});
        if (IndyInterface.bootstrap("cast", "()", 0, rangeKey) != false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "buildAttributeValue", 0, DefaultDynamoDBService.class, rangeKey);
            IndyInterface.bootstrap("invoke", "putAt", 0, key, IndyInterface.bootstrap("getProperty", "rangeKeyName", 12, this), callSite);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "addAttributeUpdatesEntry", 0, IndyInterface.bootstrap("init", "<init>", 0, UpdateItemRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableName", IndyInterface.bootstrap("invoke", "tableName", 0, IndyInterface.bootstrap("getProperty", "mainTable", 4, this.metadata)), "key", key, "returnValues", IndyInterface.bootstrap("getProperty", "UPDATED_NEW", 0, ReturnValue.class)})), attributeName, IndyInterface.bootstrap("init", "<init>", 0, AttributeValueUpdate.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"action", action, "value", IndyInterface.bootstrap("invoke", "buildAttributeValue", 0, DefaultDynamoDBService.class, attributeValue)}))));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "updateItem", 0, this.client, request));
    }

    @Override
    public boolean isIndexRangeKey(String rangeName) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "secondaryIndexes", 4, this.metadata), rangeName));
    }

    @Override
    public String getHashKeyName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "hashKeyName", 4, this.metadata));
    }

    @Override
    public Class getHashKeyClass() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "hashKeyClass", 4, this.metadata));
    }

    @Override
    public String getRangeKeyName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "rangeKeyName", 4, this.metadata));
    }

    @Override
    public Class getRangeKeyClass() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "rangeKeyClass", 4, this.metadata));
    }

    protected static Map addMaxAfterDateCondition(Map params, Date maxAfterDate) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, params, AFTER_KEY)) == false) {
            Date date = maxAfterDate;
            IndyInterface.bootstrap("invoke", "putAt", 0, params, AFTER_KEY, date);
        } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", BEFORE_KEY, 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, params, AFTER_KEY)), maxAfterDate)) != false) {
            Date date = maxAfterDate;
            IndyInterface.bootstrap("invoke", "putAt", 0, params, AFTER_KEY, date);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, params, BEFORE_KEY)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", BEFORE_KEY, 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, params, BEFORE_KEY)), ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, params, AFTER_KEY)), Date.class)))) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, params, AFTER_KEY);
            IndyInterface.bootstrap("invoke", "putAt", 0, params, BEFORE_KEY, callSite);
        }
        return params;
    }

    protected static AttributeValue buildAttributeValue(Object key) {
        if (key instanceof Number) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withN", 0, IndyInterface.bootstrap("init", "<init>", 0, AttributeValue.class), IndyInterface.bootstrap("invoke", "toString", 0, key)));
        }
        if (key instanceof Boolean) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withN", 0, IndyInterface.bootstrap("init", "<init>", 0, AttributeValue.class), IndyInterface.bootstrap("cast", "()", 0, key) != false ? "1" : "0"));
        }
        if (key instanceof Date) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withS", 0, IndyInterface.bootstrap("init", "<init>", 0, AttributeValue.class), IndyInterface.bootstrap("invoke", "serializeDate", 0, DefaultDynamoDBService.class, key)));
        }
        if (key instanceof Instant) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withS", 0, IndyInterface.bootstrap("init", "<init>", 0, AttributeValue.class), IndyInterface.bootstrap("invoke", "serializeDate", 0, DefaultDynamoDBService.class, key)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withS", 0, IndyInterface.bootstrap("init", "<init>", 0, AttributeValue.class), IndyInterface.bootstrap("invoke", "toString", 0, key)));
    }

    protected static Condition buildCondition(Object rangeKeyValue, ComparisonOperator operator) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withAttributeValueList", 0, IndyInterface.bootstrap("invoke", "withComparisonOperator", 0, IndyInterface.bootstrap("init", "<init>", 0, Condition.class), operator), IndyInterface.bootstrap("invoke", "buildAttributeValue", 0, DefaultDynamoDBService.class, rangeKeyValue)));
    }

    protected static Map buildDateConditions(String rangeKeyName, Map<String, Date> rangeKeyDates, Date maxAfterDate) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Map<String, Date> map = rangeKeyDates;
            valueRecorder.record(map, 8);
            CallSite callSite = IndyInterface.bootstrap("invoke", "keySet", 0, map);
            valueRecorder.record((Object)callSite, 22);
            public final class _buildDateConditions_closure11
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildDateConditions_closure11(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.isCase((Object)it, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "AFTER_KEY", 12, this), IndyInterface.bootstrap("getProperty", "BEFORE_KEY", 12, this)}));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildDateConditions_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "any", 0, callSite, new _buildDateConditions_closure11(DefaultDynamoDBService.class, DefaultDynamoDBService.class));
            valueRecorder.record((Object)callSite2, 31);
            if (IndyInterface.bootstrap("cast", "()", 0, callSite2) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert rangeKeyDates.keySet().any { it in [AFTER_KEY, BEFORE_KEY] }", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        CallSite operator = null;
        List attributeValueList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, maxAfterDate) != false) {
            IndyInterface.bootstrap("invoke", "addMaxAfterDateCondition", 0, DefaultDynamoDBService.class, rangeKeyDates, maxAfterDate);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, rangeKeyDates, AFTER_KEY)) != false) {
            operator = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "GE", 0, ComparisonOperator.class));
            IndyInterface.bootstrap("invoke", "leftShift", 0, attributeValueList, IndyInterface.bootstrap("invoke", "withS", 0, IndyInterface.bootstrap("init", "<init>", 0, AttributeValue.class), IndyInterface.bootstrap("invoke", "serializeDate", 0, DefaultDynamoDBService.class, IndyInterface.bootstrap("invoke", "getAt", 0, rangeKeyDates, AFTER_KEY))));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, rangeKeyDates, BEFORE_KEY)) != false) {
            operator = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "LE", 0, ComparisonOperator.class));
            IndyInterface.bootstrap("invoke", "leftShift", 0, attributeValueList, IndyInterface.bootstrap("invoke", "withS", 0, IndyInterface.bootstrap("init", "<init>", 0, AttributeValue.class), IndyInterface.bootstrap("invoke", "serializeDate", 0, DefaultDynamoDBService.class, IndyInterface.bootstrap("invoke", "getAt", 0, rangeKeyDates, BEFORE_KEY))));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, rangeKeyDates, AFTER_KEY)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, rangeKeyDates, BEFORE_KEY))) {
            operator = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "BETWEEN", 0, ComparisonOperator.class));
        }
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{rangeKeyName, IndyInterface.bootstrap("invoke", "withAttributeValueList", 0, IndyInterface.bootstrap("invoke", "withComparisonOperator", 0, IndyInterface.bootstrap("init", "<init>", 0, Condition.class), operator), attributeValueList)});
    }

    protected static DynamoDBQueryExpression buildQueryExpression(Object hashKeyName, Object hashKey, Map settings) {
        CallSite query = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DynamoDBQueryExpression.class));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, settings, "consistentRead")) != false) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "consistentRead", 0, settings);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)query, (String)"consistentRead");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "exclusiveStartKey", 0, settings)) != false) {
            ValueRecorder valueRecorder = new ValueRecorder();
            try {
                Map map = settings;
                valueRecorder.record((Object)map, 8);
                CallSite callSite = IndyInterface.bootstrap("getProperty", "exclusiveStartKey", 0, map);
                valueRecorder.record((Object)callSite, 17);
                boolean bl = callSite instanceof Map;
                valueRecorder.record((Object)bl, 35);
                if (!bl) {
                    throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert settings.exclusiveStartKey instanceof Map", (ValueRecorder)valueRecorder), null);
                }
                valueRecorder.clear();
            }
            catch (Throwable throwable) {
                valueRecorder.clear();
                throw throwable;
            }
            CallSite callSite = IndyInterface.bootstrap("invoke", "buildStartKey", 0, DefaultDynamoDBService.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "exclusiveStartKey", 0, settings), ScriptBytecodeAdapter.createMap((Object[])new Object[]{hashKeyName, hashKey})));
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)query, (String)"exclusiveStartKey");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "limit", 0, settings)) != false) {
            ValueRecorder valueRecorder = new ValueRecorder();
            try {
                Map map = settings;
                valueRecorder.record((Object)map, 8);
                CallSite callSite = IndyInterface.bootstrap("getProperty", "limit", 0, map);
                valueRecorder.record((Object)callSite, 17);
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "toString", 0, callSite);
                valueRecorder.record((Object)callSite2, 23);
                CallSite callSite3 = IndyInterface.bootstrap("getProperty", "number", 0, callSite2);
                valueRecorder.record((Object)callSite3, 34);
                if (IndyInterface.bootstrap("cast", "()", 0, callSite3) == false) {
                    throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert settings.limit.toString().number", (ValueRecorder)valueRecorder), null);
                }
                valueRecorder.clear();
            }
            catch (Throwable throwable) {
                valueRecorder.clear();
                throw throwable;
            }
            CallSite callSite = IndyInterface.bootstrap("getProperty", "limit", 0, settings);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)query, (String)"limit");
        } else {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "DEFAULT_QUERY_LIMIT", 8, DefaultDynamoDBService.class);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)query, (String)"limit");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, settings, "scanIndexForward")) != false) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "scanIndexForward", 0, settings);
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)query, (String)"scanIndexForward");
        } else {
            boolean bl = false;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)query, (String)"scanIndexForward");
        }
        return query;
    }

    protected static Map buildStartKey(Map map) {
        public final class _buildStartKey_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildStartKey_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object startKey, Object it) {
                if (IndyInterface.bootstrap("getProperty", "value", 0, it) instanceof AttributeValue) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "value", 0, it);
                    IndyInterface.bootstrap("invoke", "putAt", 0, startKey, IndyInterface.bootstrap("getProperty", "key", 0, it), callSite);
                } else {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "buildAttributeValue", 2, this, IndyInterface.bootstrap("getProperty", "value", 0, it));
                    IndyInterface.bootstrap("invoke", "putAt", 0, startKey, IndyInterface.bootstrap("getProperty", "key", 0, it), callSite);
                }
                return startKey;
            }

            @Generated
            public Object call(Object startKey, Object it) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, startKey, it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildStartKey_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return (Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "inject", 0, map, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _buildStartKey_closure12(DefaultDynamoDBService.class, DefaultDynamoDBService.class)), Map.class));
    }

    private DynamoDBQueryExpression buildQuery(Object hashKey, Map settings, Map<String, Condition> rangeKeyConditions, String indexName) {
        CallSite query = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildQueryExpression", 0, DefaultDynamoDBService.class, IndyInterface.bootstrap("getProperty", "hashKeyName", 12, this), hashKey, settings));
        CallSite callSite = IndyInterface.bootstrap("invoke", "newInstance", 0, IndyInterface.bootstrap("getProperty", "itemClass", 4, this.metadata), ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "hashKeyName", 12, this), hashKey}));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)query, (String)"hashKeyValues");
        if (IndyInterface.bootstrap("cast", "()", 0, rangeKeyConditions) != false) {
            Map<String, Condition> map = rangeKeyConditions;
            ScriptBytecodeAdapter.setProperty(map, null, (Object)query, (String)"rangeKeyConditions");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, indexName) != false) {
            String string = indexName;
            ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)query, (String)"indexName");
        }
        return query;
    }

    private QueryResultPage fetchResults(QueryResultPage resultPage, Map<String, Condition> rangeKeyConditions, String indexName, Map settings, Object hashKey, long readCapacityUnit) {
        if (DefaultTypeTransformation.booleanUnbox((Object)resultPage) && (DefaultTypeTransformation.booleanUnbox(rangeKeyConditions) || DefaultTypeTransformation.booleanUnbox((Object)indexName)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "batchGetDisabled", 0, settings)) == false) {
            public final class _fetchResults_closure13
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _fetchResults_closure13(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "getAt", 0, it, IndyInterface.bootstrap("getProperty", "rangeKeyName", 12, this));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _fetchResults_closure13.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite rangeKeys = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "results", 0, resultPage), new _fetchResults_closure13(this, this)));
            if (IndyInterface.bootstrap("cast", "()", 0, rangeKeys) != false) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getAll", 2, this, hashKey, rangeKeys, IndyInterface.bootstrap("invoke", "plus", 0, settings, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"readCapacityUnit", readCapacityUnit})));
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)resultPage, (String)"results");
            }
        }
        return resultPage;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultDynamoDBService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DefaultDynamoDBService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DefaultDynamoDBService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DefaultDynamoDBService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DefaultDynamoDBService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DefaultDynamoDBService.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    protected static Condition buildCondition(Object rangeKeyValue) {
        return DefaultDynamoDBService.buildCondition(rangeKeyValue, (ComparisonOperator)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "EQ", 0, ComparisonOperator.class)));
    }

    @Generated
    protected static Map buildDateConditions(String rangeKeyName, Map<String, Date> rangeKeyDates) {
        return DefaultDynamoDBService.buildDateConditions(rangeKeyName, rangeKeyDates, null);
    }

    @Generated
    protected static DynamoDBQueryExpression buildQueryExpression(Object hashKeyName, Object hashKey) {
        return DefaultDynamoDBService.buildQueryExpression(hashKeyName, hashKey, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        $const$0 = bigDecimal = new BigDecimal("0.5");
    }

    static {
        DefaultDynamoDBService.__$swapInit();
        CallSite callSite = IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "addFirstType", 0, IndyInterface.bootstrap("invoke", "addFirstType", 0, IndyInterface.bootstrap("invoke", "v2CompatibleBuilder", 0, ConversionSchemas.class, "v2CompatibileConversationSchemaWithGroovyAwareness"), MetaClass.class, new 1(), new 2()), Enum.class, new 3(), new 4()));
        GROOVY_AWARE_CONVERSION_SCHEMA = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.agorapulse.micronaut.aws.dynamodb.DefaultDynamoDBService");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite2);
    }

    public class 1
    implements ArgumentMarshaller,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 1() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public AttributeValue marshall(Object obj) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withNULL", 0, IndyInterface.bootstrap("init", "<init>", 0, AttributeValue.class), true));
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(1.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(1.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(1.class, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(1.class, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }

    public class 2
    implements ArgumentUnmarshaller,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 2() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void typeCheck(AttributeValue value, Method setter) {
        }

        public Object unmarshall(AttributeValue value) throws ParseException {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, ParseException.class, "Cannot unmarshall MetaClass", false));
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(2.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(2.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(2.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(2.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(2.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(2.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 2.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 2.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(2.class, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(2.class, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 2.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }

    public class 3
    implements ArgumentMarshaller,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 3() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public AttributeValue marshall(Object obj) {
            return IndyInterface.bootstrap("cast", "()", 0, obj == null ? null : IndyInterface.bootstrap("invoke", "withS", 0, IndyInterface.bootstrap("init", "<init>", 0, AttributeValue.class), IndyInterface.bootstrap("invoke", "toString", 0, obj)));
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(3.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(3.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(3.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(3.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(3.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(3.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 3.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 3.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(3.class, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(3.class, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 3.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 3.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }

    public class 4
    implements ArgumentUnmarshaller,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 4() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void typeCheck(AttributeValue value, Method setter) {
        }

        public Object unmarshall(AttributeValue value) throws ParseException {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "Cannot unmarshall Enum, add @DynamoDBConvertedEnum annotation to the field"));
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(4.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(4.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(4.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(4.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(4.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(4.class, DefaultDynamoDBService.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 4.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 4.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(4.class, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(4.class, DefaultDynamoDBService.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 4.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 4.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

