/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb;

import com.agorapulse.micronaut.aws.dynamodb.DynamoDBConfiguration;
import com.agorapulse.micronaut.aws.util.AWSClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.IDynamoDBMapper;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;

@Factory
@Requires(classes={DynamoDB.class})
public class DynamoDBFactory {
    @Bean
    @Singleton
    @Requires(missingProperty="aws.dax.endpoint")
    AmazonDynamoDB amazonDynamoDB(AWSClientConfiguration clientConfiguration, AWSCredentialsProvider credentialsProvider, AwsRegionProvider awsRegionProvider, DynamoDBConfiguration configuration) {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)configuration.configure((AwsClientBuilder)AmazonDynamoDBClientBuilder.standard(), awsRegionProvider)).withCredentials(credentialsProvider)).withClientConfiguration(clientConfiguration.getClientConfiguration())).build();
    }

    @Bean
    @Singleton
    IDynamoDBMapper dynamoDBMapper(AmazonDynamoDB client) {
        return new DynamoDBMapper(client);
    }
}

