/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.PaginatedQueryList;
import com.amazonaws.services.dynamodbv2.datamodeling.QueryResultPage;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface DynamoDBService<T> {
    public static final int DEFAULT_QUERY_LIMIT = 20;
    public static final int DEFAULT_COUNT_LIMIT = 100;
    public static final int BATCH_DELETE_LIMIT = 100;
    public static final int WRITE_BATCH_SIZE = 100;

    public int count(Object var1, String var2, Object var3, ComparisonOperator var4, Map var5);

    default public int count(Object hashKey, String rangeKeyName, Object rangeKeyValue, ComparisonOperator operator) {
        return this.count(hashKey, rangeKeyName, rangeKeyValue, operator, Collections.emptyMap());
    }

    default public int count(Object hashKey, String rangeKeyName, Object rangeKeyValue) {
        return this.count(hashKey, rangeKeyName, rangeKeyValue, ComparisonOperator.EQ);
    }

    default public int count(Object hashKey, Object rangeKeyValue) {
        return this.count(hashKey, this.getRangeKeyName(), rangeKeyValue);
    }

    default public int count(Object hashKey) {
        return this.count(hashKey, null);
    }

    @Deprecated
    default public int countByDates(Object hashKey, String rangeKeyName, Date after, Date before, Date maxAfterDate) {
        HashMap<String, Date> rangeKeyDates = new HashMap<String, Date>(2);
        rangeKeyDates.put("after", after);
        rangeKeyDates.put("before", before);
        return this.countByDates(hashKey, rangeKeyName, rangeKeyDates, Collections.singletonMap("maxAfterDate", maxAfterDate));
    }

    @Deprecated
    default public int countByDates(Object hashKey, String rangeKeyName, Date after, Date before) {
        return this.countByDates(hashKey, rangeKeyName, after, before, null);
    }

    default public int countByDates(Object hashKey, String rangeKeyName, Instant after, Instant before, Instant maxAfterDate) {
        HashMap<String, Instant> rangeKeyDates = new HashMap<String, Instant>(2);
        rangeKeyDates.put("after", after);
        rangeKeyDates.put("before", before);
        return this.countByDates(hashKey, rangeKeyName, rangeKeyDates, Collections.singletonMap("maxAfterDate", maxAfterDate));
    }

    default public int countByDates(Object hashKey, String rangeKeyName, Instant after, Instant before) {
        return this.countByDates(hashKey, rangeKeyName, after, before, null);
    }

    public int countByDates(Object var1, String var2, Map var3, Map var4);

    default public int countByDates(Object hashKey, String rangeKeyName, Map rangeKeyDates) {
        return this.countByDates(hashKey, rangeKeyName, rangeKeyDates, Collections.emptyMap());
    }

    public int countByConditions(Object var1, Map<String, Condition> var2, Map var3);

    default public int countByConditions(Object hashKey, Map<String, Condition> rangeKeyConditions) {
        return this.countByConditions(hashKey, rangeKeyConditions, Collections.emptyMap());
    }

    public CreateTableResult createTable(Long var1, Long var2);

    default public CreateTableResult createTable(Long readCapacityUnits) {
        return this.createTable(readCapacityUnits, 5L);
    }

    default public CreateTableResult createTable() {
        return this.createTable(10L);
    }

    default public Integer decrement(Object hashKey, Object rangeKey, String attributeName, int attributeIncrement) {
        return this.increment(hashKey, rangeKey, attributeName, -attributeIncrement);
    }

    default public Integer decrement(Object hashKey, Object rangeKey, String attributeName) {
        return this.decrement(hashKey, rangeKey, attributeName, 1);
    }

    default public Integer decrement(Object hashKey, String attributeName) {
        return this.decrement(hashKey, null, attributeName, 1);
    }

    public void delete(Object var1, Object var2, Map var3);

    default public void delete(Object hashKey, Object rangeKey) {
        this.delete(hashKey, rangeKey, Collections.emptyMap());
    }

    default public void delete(T item, Map settings) {
        this.deleteAll(Collections.singletonList(item), settings);
    }

    default public void delete(T item) {
        this.delete(item, Collections.emptyMap());
    }

    default public void deleteByHash(Object id) {
        this.delete(id, null, Collections.emptyMap());
    }

    public void deleteAll(List<T> var1, Map var2);

    default public void deleteAll(List<T> itemsToDelete) {
        this.deleteAll(itemsToDelete, Collections.emptyMap());
    }

    default public int deleteAll(Object hashKey, Map settings) {
        return this.deleteAllByConditions(hashKey, Collections.emptyMap(), settings);
    }

    default public int deleteAll(Object hashKey) {
        return this.deleteAll(hashKey, Collections.emptyMap());
    }

    public int deleteAll(Object var1, String var2, Object var3, ComparisonOperator var4, Map var5);

    default public int deleteAll(Object hashKey, String rangeKeyName, Object rangeKeyValue, ComparisonOperator operator) {
        return this.deleteAll(hashKey, rangeKeyName, rangeKeyValue, operator, Collections.emptyMap());
    }

    default public int deleteAll(Object hashKey, String rangeKeyName, Object rangeKeyValue) {
        return this.deleteAll(hashKey, rangeKeyName, rangeKeyValue, ComparisonOperator.BEGINS_WITH);
    }

    public int deleteAllByConditions(Object var1, Map<String, Condition> var2, Map var3, String var4);

    public int deleteAllByConditions(DynamoDBQueryExpression var1, Map var2);

    default public int deleteAllByConditions(Object hashKey, Map<String, Condition> rangeKeyConditions, Map settings) {
        return this.deleteAllByConditions(hashKey, rangeKeyConditions, settings, null);
    }

    default public int deleteAllByConditions(Object hashKey, Map<String, Condition> rangeKeyConditions) {
        return this.deleteAllByConditions(hashKey, rangeKeyConditions, Collections.emptyMap());
    }

    public T get(Object var1, Object var2);

    default public T get(Object hashKey) {
        return this.get(hashKey, null);
    }

    public List<T> getAll(Object var1, List var2, Map var3);

    default public List<T> getAll(Object hashKey, List rangeKeys) {
        return this.getAll(hashKey, rangeKeys, Collections.emptyMap());
    }

    public Integer increment(Object var1, Object var2, String var3, int var4);

    default public Integer increment(Object hashKey, Object rangeKey, String attributeName) {
        return this.increment(hashKey, rangeKey, attributeName, 1);
    }

    default public Integer increment(Object hashKey, String attributeName) {
        return this.increment(hashKey, null, attributeName, 1);
    }

    public T getNewInstance();

    public PaginatedQueryList<T> query(DynamoDBQueryExpression var1);

    default public QueryResultPage<T> query(Object hashKey, Map settings) {
        return this.queryByConditions(hashKey, Collections.emptyMap(), settings);
    }

    default public QueryResultPage<T> query(Object hashKey) {
        return this.query(hashKey, Collections.emptyMap());
    }

    public QueryResultPage<T> query(Object var1, String var2, Object var3, ComparisonOperator var4, Map var5);

    default public QueryResultPage<T> query(Object hashKey, String rangeKeyName, Object rangeKeyValue, ComparisonOperator operator) {
        return this.query(hashKey, rangeKeyName, rangeKeyValue, operator, Collections.emptyMap());
    }

    default public QueryResultPage<T> query(Object hashKey, Object rangeKeyValue) {
        return this.query(hashKey, this.getRangeKeyName(), rangeKeyValue);
    }

    default public QueryResultPage<T> query(Object hashKey, String rangeKeyName, Object rangeKeyValue) {
        return this.query(hashKey, rangeKeyName, rangeKeyValue, ComparisonOperator.EQ);
    }

    public QueryResultPage<T> queryByConditions(Object var1, Map<String, Condition> var2, Map var3, String var4);

    default public QueryResultPage<T> queryByConditions(Object hashKey, Map<String, Condition> rangeKeyConditions, Map settings) {
        return this.queryByConditions(hashKey, rangeKeyConditions, settings, null);
    }

    default public QueryResultPage<T> queryByConditions(Object hashKey, Map<String, Condition> rangeKeyConditions) {
        return this.queryByConditions(hashKey, rangeKeyConditions, Collections.emptyMap());
    }

    public QueryResultPage<T> queryByDates(Object var1, String var2, Map var3, Map var4);

    default public QueryResultPage<T> queryByDates(Object hashKey, String rangeKeyName, Map rangeKeyDates) {
        return this.queryByDates(hashKey, rangeKeyName, rangeKeyDates, Collections.emptyMap());
    }

    @Deprecated
    default public QueryResultPage<T> queryByDates(Object hashKey, String rangeKeyName, Date after, Date before) {
        return this.queryByDates(hashKey, rangeKeyName, after, before, null);
    }

    @Deprecated
    default public QueryResultPage<T> queryByDates(Object hashKey, String rangeKeyName, Date after, Date before, Date maxAfterDate) {
        HashMap<String, Date> rangeKeyDates = new HashMap<String, Date>(2);
        rangeKeyDates.put("after", after);
        rangeKeyDates.put("before", before);
        return this.queryByDates(hashKey, rangeKeyName, rangeKeyDates, Collections.singletonMap("maxAfterDate", maxAfterDate));
    }

    default public QueryResultPage<T> queryByDates(Object hashKey, String rangeKeyName, Instant after, Instant before) {
        return this.queryByDates(hashKey, rangeKeyName, after, before, null);
    }

    default public QueryResultPage<T> queryByDates(Object hashKey, String rangeKeyName, Instant after, Instant before, Instant maxAfterDate) {
        HashMap<String, Instant> rangeKeyDates = new HashMap<String, Instant>(2);
        rangeKeyDates.put("after", after);
        rangeKeyDates.put("before", before);
        return this.queryByDates(hashKey, rangeKeyName, rangeKeyDates, Collections.singletonMap("maxAfterDate", maxAfterDate));
    }

    default public T save(T item, Map settings) {
        return this.saveAll(Collections.singletonList(item), settings).iterator().next();
    }

    default public T save(T item) {
        return this.save(item, Collections.emptyMap());
    }

    public List<T> saveAll(List<T> var1, Map var2);

    default public List<T> saveAll(List<T> itemsToSave) {
        return this.saveAll(itemsToSave, Collections.emptyMap());
    }

    default public List<T> saveAll(T ... itemsToSave) {
        return this.saveAll(Arrays.asList(itemsToSave));
    }

    public UpdateItemResult deleteItemAttribute(Object var1, Object var2, String var3);

    default public UpdateItemResult deleteItemAttribute(Object hashKey, String attributeName) {
        return this.deleteItemAttribute(hashKey, null, attributeName);
    }

    public UpdateItemResult updateItemAttribute(Object var1, Object var2, String var3, Object var4, AttributeAction var5);

    default public UpdateItemResult updateItemAttribute(Object hashKey, Object rangeKey, String attributeName, Object attributeValue) {
        return this.updateItemAttribute(hashKey, rangeKey, attributeName, attributeValue, AttributeAction.PUT);
    }

    public boolean isIndexRangeKey(String var1);

    public String getHashKeyName();

    public Class<?> getHashKeyClass();

    public String getRangeKeyName();

    public Class<?> getRangeKeyClass();
}

