/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb;

import com.agorapulse.micronaut.aws.dynamodb.DefaultDynamoDBService;
import com.agorapulse.micronaut.aws.dynamodb.DynamoDBService;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.IDynamoDBMapper;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
@Requires(classes={IDynamoDBMapper.class})
public class DynamoDBServiceProvider {
    private final ConcurrentHashMap<Class, DynamoDBService> serviceCache = new ConcurrentHashMap();
    private final AmazonDynamoDB client;
    private final IDynamoDBMapper mapper;

    public DynamoDBServiceProvider(AmazonDynamoDB client, IDynamoDBMapper mapper) {
        this.client = client;
        this.mapper = mapper;
    }

    public <T> DynamoDBService<T> findOrCreate(Class<T> type) {
        return this.serviceCache.computeIfAbsent(type, t -> new DefaultDynamoDBService(this.client, this.mapper, type));
    }
}

