/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb.builder;

import com.agorapulse.micronaut.aws.dynamodb.builder.Builders;
import com.agorapulse.micronaut.aws.dynamodb.builder.DetachedQuery;
import com.agorapulse.micronaut.aws.dynamodb.builder.PathCollector;
import com.agorapulse.micronaut.aws.dynamodb.builder.RangeConditionCollector;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FromString;
import java.util.Arrays;
import java.util.function.Consumer;
import space.jasan.support.groovy.closure.ConsumerWithDelegate;

public interface QueryBuilder<T>
extends DetachedQuery<T> {
    public QueryBuilder<T> sort(Builders.Sort var1);

    public QueryBuilder<T> consistent(Builders.Read var1);

    public QueryBuilder<T> inconsistent(Builders.Read var1);

    public QueryBuilder<T> index(String var1);

    public QueryBuilder<T> hash(Object var1);

    public QueryBuilder<T> range(Consumer<RangeConditionCollector<T>> var1);

    default public QueryBuilder<T> range(@DelegatesTo(type="com.agorapulse.micronaut.aws.dynamodb.builder.RangeConditionCollector<T>", strategy=1) @ClosureParams(value=FromString.class, options={"com.agorapulse.micronaut.aws.dynamodb.builder.RangeConditionCollector<T>"}) Closure<RangeConditionCollector<T>> conditions) {
        return this.range(ConsumerWithDelegate.create(conditions));
    }

    public QueryBuilder<T> filter(Consumer<RangeConditionCollector<T>> var1);

    default public QueryBuilder<T> or(Consumer<RangeConditionCollector<T>> conditions) {
        this.filter(ConditionalOperator.OR);
        return this.filter(conditions);
    }

    default public QueryBuilder<T> and(Consumer<RangeConditionCollector<T>> conditions) {
        this.filter(ConditionalOperator.AND);
        return this.filter(conditions);
    }

    default public QueryBuilder<T> filter(@DelegatesTo(type="com.agorapulse.micronaut.aws.dynamodb.builder.RangeConditionCollector<T>", strategy=1) @ClosureParams(value=FromString.class, options={"com.agorapulse.micronaut.aws.dynamodb.builder.RangeConditionCollector<T>"}) Closure<RangeConditionCollector<T>> conditions) {
        return this.filter(ConsumerWithDelegate.create(conditions));
    }

    default public QueryBuilder<T> or(@DelegatesTo(type="com.agorapulse.micronaut.aws.dynamodb.builder.RangeConditionCollector<T>", strategy=1) @ClosureParams(value=FromString.class, options={"com.agorapulse.micronaut.aws.dynamodb.builder.RangeConditionCollector<T>"}) Closure<RangeConditionCollector<T>> conditions) {
        return this.or(ConsumerWithDelegate.create(conditions));
    }

    default public QueryBuilder<T> and(@DelegatesTo(type="com.agorapulse.micronaut.aws.dynamodb.builder.RangeConditionCollector<T>", strategy=1) @ClosureParams(value=FromString.class, options={"com.agorapulse.micronaut.aws.dynamodb.builder.RangeConditionCollector<T>"}) Closure<RangeConditionCollector<T>> conditions) {
        return this.and(ConsumerWithDelegate.create(conditions));
    }

    public QueryBuilder<T> filter(ConditionalOperator var1);

    public QueryBuilder<T> page(int var1);

    public QueryBuilder<T> limit(int var1);

    public QueryBuilder<T> offset(Object var1, Object var2);

    default public QueryBuilder<T> offset(Object exclusiveStartKeyValue) {
        return this.offset(exclusiveStartKeyValue, null);
    }

    public QueryBuilder<T> configure(Consumer<DynamoDBQueryExpression<T>> var1);

    default public QueryBuilder<T> configure(@DelegatesTo(type="com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression<T>", strategy=1) @ClosureParams(value=FromString.class, options={"com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression<T>"}) Closure<Object> configurer) {
        return this.configure(ConsumerWithDelegate.create(configurer));
    }

    public QueryBuilder<T> only(Iterable<String> var1);

    default public QueryBuilder<T> only(String ... propertyPaths) {
        return this.only(Arrays.asList(propertyPaths));
    }

    default public QueryBuilder<T> only(@DelegatesTo(type="T", strategy=3) @ClosureParams(value=FromString.class, options={"T"}) Closure<Object> collector) {
        return this.only(PathCollector.collectPaths(collector).getPropertyPaths());
    }
}

