/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb.convert;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public class CompressedStringConverter
implements DynamoDBTypeConverter<ByteBuffer, String>,
GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public CompressedStringConverter() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public ByteBuffer convert(String input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        try {
            gos.write(input.getBytes(StandardCharsets.UTF_8));
            gos.close();
            byte[] compressedBytes = baos.toByteArray();
            ByteBuffer buffer = ByteBuffer.allocate(compressedBytes.length);
            buffer.put(compressedBytes, 0, compressedBytes.length);
            buffer.position(0);
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            baos.close();
        }
    }

    public String unconvert(ByteBuffer input) {
        byte[] bytes = input.array();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPInputStream is = new GZIPInputStream(bais);
        try {
            int chunkSize = 1024;
            byte[] buffer = new byte[chunkSize];
            int length = 0;
            while ((length = is.read(buffer, 0, chunkSize)) != -1) {
                baos.write(buffer, 0, length);
            }
            String string = new String(baos.toByteArray(), "UTF-8");
            return string;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            is.close();
            baos.close();
            bais.close();
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CompressedStringConverter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

