/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb;

import com.agorapulse.micronaut.aws.dynamodb.DynamoDBService;
import com.agorapulse.micronaut.aws.dynamodb.DynamoDBServiceProvider;
import com.agorapulse.micronaut.aws.dynamodb.StrictMap;
import com.agorapulse.micronaut.aws.dynamodb.annotation.HashKey;
import com.agorapulse.micronaut.aws.dynamodb.annotation.Query;
import com.agorapulse.micronaut.aws.dynamodb.annotation.RangeKey;
import com.agorapulse.micronaut.aws.dynamodb.annotation.Scan;
import com.agorapulse.micronaut.aws.dynamodb.annotation.Service;
import com.agorapulse.micronaut.aws.dynamodb.annotation.Update;
import com.agorapulse.micronaut.aws.dynamodb.builder.Builders;
import com.agorapulse.micronaut.aws.dynamodb.builder.DetachedQuery;
import com.agorapulse.micronaut.aws.dynamodb.builder.DetachedScan;
import com.agorapulse.micronaut.aws.dynamodb.builder.DetachedUpdate;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.IDynamoDBMapper;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import groovy.lang.Closure;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Singleton
@Requires(classes={IDynamoDBMapper.class})
public class ServiceIntroduction
implements MethodInterceptor<Object, Object> {
    private static final String HASH = "hash";
    private static final String RANGE = "range";
    private final IDynamoDBMapper mapper;
    private final AmazonDynamoDB amazonDynamoDB;
    private final DynamoDBServiceProvider dynamoDBServiceProvider;

    public ServiceIntroduction(IDynamoDBMapper mapper, AmazonDynamoDB amazonDynamoDB, DynamoDBServiceProvider dynamoDBServiceProvider) {
        this.mapper = mapper;
        this.amazonDynamoDB = amazonDynamoDB;
        this.dynamoDBServiceProvider = dynamoDBServiceProvider;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        AnnotationValue serviceAnnotationValue = context.getAnnotation(Service.class);
        if (serviceAnnotationValue == null) {
            throw new IllegalStateException("Invocation context is missing required annotation Service");
        }
        Class type = (Class)serviceAnnotationValue.getValue(Class.class).orElseThrow(() -> new IllegalArgumentException("Annotation is missing the type value!"));
        DynamoDBService service = this.dynamoDBServiceProvider.findOrCreate(type);
        try {
            return this.doIntercept(context, type, service);
        }
        catch (ResourceNotFoundException ignored) {
            service.createTable();
            return this.doIntercept(context, type, service);
        }
    }

    private Object doIntercept(MethodInvocationContext<Object, Object> context, Class type, DynamoDBService service) {
        String methodName = context.getMethodName();
        if (methodName.startsWith("save")) {
            return this.handleSave(service, context);
        }
        if (methodName.startsWith("get") || methodName.startsWith("load")) {
            return this.handleGet(service, context);
        }
        if (context.getTargetMethod().isAnnotationPresent(Query.class)) {
            DetachedQuery criteria = (DetachedQuery)this.evaluateAnnotationType(context.getTargetMethod().getAnnotation(Query.class).value(), context);
            if (methodName.startsWith("count")) {
                return criteria.count(this.mapper);
            }
            if (methodName.startsWith("delete")) {
                return service.deleteAllByConditions(criteria.resolveExpression(this.mapper), Collections.emptyMap());
            }
            return this.publisherOrIterable(criteria.query(this.mapper), context.getReturnType().getType());
        }
        if (context.getTargetMethod().isAnnotationPresent(Update.class)) {
            DetachedUpdate criteria = (DetachedUpdate)this.evaluateAnnotationType(context.getTargetMethod().getAnnotation(Update.class).value(), context);
            return criteria.update(this.mapper, this.amazonDynamoDB);
        }
        if (context.getTargetMethod().isAnnotationPresent(Scan.class)) {
            DetachedScan criteria = (DetachedScan)this.evaluateAnnotationType(context.getTargetMethod().getAnnotation(Scan.class).value(), context);
            if (methodName.startsWith("count")) {
                return criteria.count(this.mapper);
            }
            return this.publisherOrIterable(criteria.scan(this.mapper), context.getReturnType().getType());
        }
        if (methodName.startsWith("count")) {
            return this.simpleHashAndRangeQuery(type, context).count(this.mapper);
        }
        if (methodName.startsWith("delete")) {
            return this.handleDelete(type, service, context);
        }
        if (methodName.startsWith("query") || methodName.startsWith("findAll") || methodName.startsWith("list")) {
            return this.publisherOrIterable(this.simpleHashAndRangeQuery(type, context).query(this.mapper), context.getReturnType().getType());
        }
        throw new UnsupportedOperationException("Cannot implement method " + context.getExecutableMethod());
    }

    private Object publisherOrIterable(Publisher result, Class type) {
        if (Publishers.isConvertibleToPublisher((Class)type)) {
            return Publishers.convertPublisher((Object)result, (Class)type);
        }
        return Flux.from((Publisher)result).collectList().block();
    }

    private <T> T evaluateAnnotationType(Class<? extends Function<Map<String, Object>, T>> updateDefinitionType, MethodInvocationContext<Object, Object> context) {
        StrictMap parameterValueMap = new StrictMap(context.getParameterValueMap());
        if (Closure.class.isAssignableFrom(updateDefinitionType)) {
            try {
                Closure closure = (Closure)updateDefinitionType.getConstructor(Object.class, Object.class).newInstance(parameterValueMap, parameterValueMap);
                closure.setDelegate(parameterValueMap);
                closure.setResolveStrategy(1);
                return (T)closure.call(parameterValueMap);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Cannot instantiate closure! Type: " + updateDefinitionType, e);
            }
        }
        try {
            return updateDefinitionType.newInstance().apply(parameterValueMap);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate function! Type: " + updateDefinitionType, e);
        }
    }

    private Object handleSave(DynamoDBService service, MethodInvocationContext<Object, Object> context) {
        Map params = context.getParameters();
        Argument[] args = context.getArguments();
        if (args.length > 1) {
            throw new UnsupportedOperationException("Method expects at most 1 parameters - item, iterable of items or array of items");
        }
        Argument itemArgument = args[0];
        Object item = ((MutableArgumentValue)params.get(itemArgument.getName())).getValue();
        if (itemArgument.getType().isArray()) {
            return service.saveAll(Arrays.asList((Object[])item));
        }
        if (Iterable.class.isAssignableFrom(itemArgument.getType())) {
            return service.saveAll(ServiceIntroduction.toList((Iterable)item));
        }
        return service.save(item);
    }

    private Object handleDelete(Class type, DynamoDBService service, MethodInvocationContext<Object, Object> context) {
        Map params = context.getParameters();
        Argument[] args = context.getArguments();
        if (args.length == 1) {
            Argument itemArgument = args[0];
            Object item = ((MutableArgumentValue)params.get(itemArgument.getName())).getValue();
            if (itemArgument.getType().isArray() && type.isAssignableFrom(itemArgument.getType().getComponentType())) {
                service.deleteAll(Arrays.asList((Object[])item));
                return null;
            }
            if (Iterable.class.isAssignableFrom(itemArgument.getType()) && type.isAssignableFrom(itemArgument.getTypeParameters()[0].getType())) {
                service.deleteAll(ServiceIntroduction.toList((Iterable)item));
                return null;
            }
            if (type.isAssignableFrom(itemArgument.getType())) {
                service.delete(item);
                return null;
            }
        }
        if (args.length > 2) {
            throw new UnsupportedOperationException("Method expects at most 2 parameters - hash key and range key, an item, iterable of items or an array of items");
        }
        HashAndRange hashAndRange = this.findHashAndRange(args);
        Object hashKey = ((MutableArgumentValue)params.get(hashAndRange.hashKey.getName())).getValue();
        if (hashAndRange.rangeKey == null) {
            service.deleteByHash(hashKey);
            return null;
        }
        Object rangeKey = ((MutableArgumentValue)params.get(hashAndRange.rangeKey.getName())).getValue();
        service.delete(hashKey, rangeKey);
        return null;
    }

    private Object handleGet(DynamoDBService service, MethodInvocationContext<Object, Object> context) {
        Map params = context.getParameters();
        Argument[] args = context.getArguments();
        if (args.length > 2) {
            throw new UnsupportedOperationException("Method expects at most 2 parameters - hash key and range key");
        }
        HashAndRange hashAndRange = this.findHashAndRange(args);
        Object hashKey = ((MutableArgumentValue)params.get(hashAndRange.hashKey.getName())).getValue();
        if (hashAndRange.rangeKey == null) {
            return service.get(hashKey);
        }
        Object rangeKey = ((MutableArgumentValue)params.get(hashAndRange.rangeKey.getName())).getValue();
        if (hashAndRange.rangeKey.getType().isArray()) {
            return service.getAll(hashKey, Arrays.asList((Object[])rangeKey));
        }
        if (Iterable.class.isAssignableFrom(hashAndRange.rangeKey.getType())) {
            return service.getAll(hashKey, ServiceIntroduction.toList((Iterable)rangeKey));
        }
        return service.get(hashKey, rangeKey);
    }

    private DetachedQuery simpleHashAndRangeQuery(Class type, MethodInvocationContext<Object, Object> context) {
        Map params = context.getParameters();
        Argument[] args = context.getArguments();
        if (args.length > 2) {
            throw new UnsupportedOperationException("Method expects at most 2 parameters - hash key and optional range key");
        }
        HashAndRange hashAndRange = this.findHashAndRange(args);
        Object hashKey = ((MutableArgumentValue)params.get(hashAndRange.hashKey.getName())).getValue();
        if (hashAndRange.rangeKey == null) {
            return Builders.query(type, q -> q.hash(hashKey));
        }
        Object rangeKey = ((MutableArgumentValue)params.get(hashAndRange.rangeKey.getName())).getValue();
        return Builders.query(type, q -> q.hash(hashKey).range(r -> r.eq(rangeKey)));
    }

    private HashAndRange findHashAndRange(Argument[] arguments) {
        HashAndRange names = new HashAndRange();
        for (Argument argument : arguments) {
            if (argument.isAnnotationPresent(RangeKey.class) || argument.getName().toLowerCase().contains(RANGE)) {
                names.rangeKey = argument;
                continue;
            }
            if (!argument.isAnnotationPresent(HashKey.class) && !argument.getName().toLowerCase().contains(HASH)) continue;
            names.hashKey = argument;
        }
        if (!names.isValid()) {
            throw new UnsupportedOperationException("Method needs to have at least one argument annotated with @HashKey or with called 'hash'");
        }
        return names;
    }

    private static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList ret = new ArrayList();
        iterable.forEach(ret::add);
        return ret;
    }

    private static class HashAndRange {
        Argument<?> hashKey;
        Argument<?> rangeKey;

        private HashAndRange() {
        }

        boolean isValid() {
            return this.hashKey != null;
        }
    }
}

