/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb.builder;

import com.agorapulse.micronaut.aws.dynamodb.builder.DefaultQueryBuilder;
import com.agorapulse.micronaut.aws.dynamodb.builder.DefaultScanBuilder;
import com.agorapulse.micronaut.aws.dynamodb.builder.DefaultUpdateBuilder;
import com.agorapulse.micronaut.aws.dynamodb.builder.QueryBuilder;
import com.agorapulse.micronaut.aws.dynamodb.builder.ScanBuilder;
import com.agorapulse.micronaut.aws.dynamodb.builder.UpdateBuilder;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.util.function.Consumer;
import space.jasan.support.groovy.closure.ConsumerWithDelegate;

public final class Builders {
    public static final Sort asc = Sort.ASC;
    public static final Sort desc = Sort.DESC;
    public static final Read read = Read.READ;
    public static final ReturnValue none = ReturnValue.NONE;
    public static final ReturnValue allOld = ReturnValue.ALL_OLD;
    public static final ReturnValue updatedOld = ReturnValue.UPDATED_OLD;
    public static final ReturnValue allNew = ReturnValue.ALL_NEW;
    public static final ReturnValue updatedNew = ReturnValue.UPDATED_NEW;

    private Builders() {
    }

    public static <T> QueryBuilder<T> query(Class<T> type) {
        return new DefaultQueryBuilder<T>(type, new DynamoDBQueryExpression().withLimit(Integer.valueOf(20)));
    }

    public static <T> QueryBuilder<T> query(Class<T> type, Consumer<QueryBuilder<T>> definition) {
        QueryBuilder<T> builder = Builders.query(type);
        definition.accept(builder);
        return builder;
    }

    public static <T> QueryBuilder<T> query(Class<T> type, @DelegatesTo(type="com.agorapulse.micronaut.aws.dynamodb.builder.QueryBuilder<T>", strategy=1) @ClosureParams(value=SimpleType.class, options={"com.agorapulse.micronaut.aws.dynamodb.builder.QueryBuilder<T>"}) Closure<QueryBuilder<T>> definition) {
        return Builders.query(type, ConsumerWithDelegate.create(definition));
    }

    public static <T> ScanBuilder<T> scan(Class<T> type) {
        return new DefaultScanBuilder<T>(type, new DynamoDBScanExpression().withLimit(Integer.valueOf(20)));
    }

    public static <T> ScanBuilder<T> scan(Class<T> type, Consumer<ScanBuilder<T>> definition) {
        ScanBuilder<T> builder = Builders.scan(type);
        definition.accept(builder);
        return builder;
    }

    public static <T> ScanBuilder<T> scan(Class<T> type, @DelegatesTo(type="com.agorapulse.micronaut.aws.dynamodb.builder.ScanBuilder<T>", strategy=1) @ClosureParams(value=SimpleType.class, options={"com.agorapulse.micronaut.aws.dynamodb.builder.ScanBuilder<T>"}) Closure<ScanBuilder<T>> definition) {
        return Builders.scan(type, ConsumerWithDelegate.create(definition));
    }

    public static <T> UpdateBuilder<T> update(Class<T> type) {
        return new DefaultUpdateBuilder<T>(type);
    }

    public static <T> UpdateBuilder<T> update(Class<T> type, Consumer<UpdateBuilder<T>> definition) {
        UpdateBuilder<T> builder = Builders.update(type);
        definition.accept(builder);
        return builder;
    }

    public static <T> UpdateBuilder<T> update(Class<T> type, @DelegatesTo(type="com.agorapulse.micronaut.aws.dynamodb.builder.UpdateBuilder<T>", strategy=1) @ClosureParams(value=SimpleType.class, options={"com.agorapulse.micronaut.aws.dynamodb.builder.UpdateBuilder<T>"}) Closure<UpdateBuilder<T>> definition) {
        return Builders.update(type, ConsumerWithDelegate.create(definition));
    }

    static enum Sort {
        ASC,
        DESC;

    }

    static enum Read {
        READ;

    }
}

