/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb.builder;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.IDynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.QueryResultPage;
import com.amazonaws.services.dynamodbv2.datamodeling.ScanResultPage;
import java.util.Collections;
import reactor.core.publisher.Flux;

class FluxQueryResultHelper {
    FluxQueryResultHelper() {
    }

    public static <T> Flux<T> generate(Class<T> type, IDynamoDBMapper mapper, DynamoDBQueryExpression<T> queryExpression) {
        return Flux.generate(() -> mapper.queryPage(type, queryExpression), (result, emitter) -> {
            emitter.next((Object)result.getResults());
            if (result.getLastEvaluatedKey() == null) {
                emitter.complete();
                QueryResultPage empty = new QueryResultPage();
                empty.setResults(Collections.emptyList());
                return empty;
            }
            return mapper.queryPage(type, queryExpression.withExclusiveStartKey(result.getLastEvaluatedKey()));
        }).flatMap(Flux::fromIterable);
    }

    public static <T> Flux<T> generate(Class<T> type, IDynamoDBMapper mapper, DynamoDBScanExpression queryExpression) {
        return Flux.generate(() -> mapper.scanPage(type, queryExpression), (result, emitter) -> {
            emitter.next((Object)result.getResults());
            if (result.getLastEvaluatedKey() == null) {
                emitter.complete();
                ScanResultPage empty = new ScanResultPage();
                empty.setResults(Collections.emptyList());
                return empty;
            }
            return mapper.scanPage(type, queryExpression.withExclusiveStartKey(result.getLastEvaluatedKey()));
        }).flatMap(Flux::fromIterable);
    }
}

