/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb.builder;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.model.Condition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RangeConditionCollector<T> {
    private final DynamoDBMapperTableModel<T> model;
    private Map<String, Condition> conditions = new LinkedHashMap<String, Condition>();

    public RangeConditionCollector(DynamoDBMapperTableModel<T> model) {
        this.model = model;
    }

    public RangeConditionCollector<T> eq(Object value) {
        return this.eq(this.model.rangeKey().name(), value);
    }

    public RangeConditionCollector<T> eq(String attributeOrIndex, Object value) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).eq(value));
        return this;
    }

    public RangeConditionCollector<T> ne(Object value) {
        return this.ne(this.model.rangeKey().name(), value);
    }

    public RangeConditionCollector<T> ne(String attributeOrIndex, Object value) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).ne(value));
        return this;
    }

    public RangeConditionCollector<T> inListOf(Object ... values) {
        return this.inList(this.model.rangeKey().name(), values);
    }

    public RangeConditionCollector<T> inList(String attributeOrIndex, Object ... values) {
        return this.inList(attributeOrIndex, Arrays.asList(values));
    }

    public RangeConditionCollector<T> inList(Collection<Object> values) {
        return this.inList(this.model.rangeKey().name(), values);
    }

    public RangeConditionCollector<T> inList(String attributeOrIndex, Collection<Object> values) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).in(values));
        return this;
    }

    public RangeConditionCollector<T> le(Object value) {
        return this.le(this.model.rangeKey().name(), value);
    }

    public RangeConditionCollector<T> le(String attributeOrIndex, Object value) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).le(value));
        return this;
    }

    public RangeConditionCollector<T> lt(Object value) {
        return this.lt(this.model.rangeKey().name(), value);
    }

    public RangeConditionCollector<T> lt(String attributeOrIndex, Object value) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).lt(value));
        return this;
    }

    public RangeConditionCollector<T> ge(Object value) {
        return this.ge(this.model.rangeKey().name(), value);
    }

    public RangeConditionCollector<T> ge(String attributeOrIndex, Object value) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).ge(value));
        return this;
    }

    public RangeConditionCollector<T> gt(Object value) {
        return this.gt(this.model.rangeKey().name(), value);
    }

    public RangeConditionCollector<T> gt(String attributeOrIndex, Object value) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).gt(value));
        return this;
    }

    public RangeConditionCollector<T> between(Object lo, Object hi) {
        return this.between(this.model.rangeKey().name(), lo, hi);
    }

    public RangeConditionCollector<T> between(String attributeOrIndex, Object lo, Object hi) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).between(lo, hi));
        return this;
    }

    public RangeConditionCollector<T> isNotNull() {
        return this.isNotNull(this.model.rangeKey().name());
    }

    public RangeConditionCollector<T> isNotNull(String attributeOrIndex) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).notNull());
        return this;
    }

    public RangeConditionCollector<T> isNull() {
        return this.isNull(this.model.rangeKey().name());
    }

    public RangeConditionCollector<T> isNull(String attributeOrIndex) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).isNull());
        return this;
    }

    public RangeConditionCollector<T> contains(Object value) {
        return this.contains(this.model.rangeKey().name(), value);
    }

    public RangeConditionCollector<T> contains(String attributeOrIndex, Object value) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).contains(value));
        return this;
    }

    public RangeConditionCollector<T> notContains(Object value) {
        return this.notContains(this.model.rangeKey().name(), value);
    }

    public RangeConditionCollector<T> notContains(String attributeOrIndex, Object value) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).notContains(value));
        return this;
    }

    public RangeConditionCollector<T> beginsWith(Object value) {
        return this.beginsWith(this.model.rangeKey().name(), value);
    }

    public RangeConditionCollector<T> beginsWith(String attributeOrIndex, Object value) {
        this.conditions.put(attributeOrIndex, this.model.field(attributeOrIndex).beginsWith(value));
        return this;
    }

    public Map<String, Condition> getConditions() {
        return Collections.unmodifiableMap(this.conditions);
    }
}

