/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb.builder;

import com.agorapulse.micronaut.aws.dynamodb.DynamoDBMetadata;
import com.agorapulse.micronaut.aws.dynamodb.builder.Builders;
import com.agorapulse.micronaut.aws.dynamodb.builder.FluxQueryResultHelper;
import com.agorapulse.micronaut.aws.dynamodb.builder.QueryBuilder;
import com.agorapulse.micronaut.aws.dynamodb.builder.RangeConditionCollector;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBQueryExpression;
import com.amazonaws.services.dynamodbv2.datamodeling.IDynamoDBMapper;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class DefaultQueryBuilder<T>
implements QueryBuilder<T>,
GroovyObject {
    private final DynamoDBMetadata<T> metadata;
    private final DynamoDBQueryExpression<T> expression;
    private final List<Consumer<RangeConditionCollector<T>>> filterCollectorsConsumers;
    private final List<Consumer<RangeConditionCollector<T>>> rangeCollectorsConsumers;
    private Object hashKey;
    private Object exclusiveHashStartKey;
    private Object exclusiveRangeStartKey;
    private int max;
    private Consumer<DynamoDBQueryExpression<T>> configurer;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DefaultQueryBuilder(Class<T> type, DynamoDBQueryExpression<T> expression) {
        MetaClass metaClass;
        Consumer consumer;
        int n;
        List list;
        List list2;
        this.filterCollectorsConsumers = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.rangeCollectorsConsumers = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.max = n = Integer.MAX_VALUE;
        this.configurer = consumer = (Consumer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, new _closure1(this, this), Consumer.class));
        this.metaClass = metaClass = this.$getStaticMetaClass();
        DynamoDBMetadata<T> dynamoDBMetadata = DynamoDBMetadata.create(type);
        this.metadata = dynamoDBMetadata;
        DynamoDBQueryExpression<T> dynamoDBQueryExpression = expression;
        this.expression = dynamoDBQueryExpression;
    }

    @Override
    public DefaultQueryBuilder<T> sort(Builders.Sort sort) {
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)sort), (Object)((Object)Builders.Sort.ASC))) {
            this.expression.withScanIndexForward(true);
        } else if (ScriptBytecodeAdapter.compareEqual((Object)((Object)sort), (Object)((Object)Builders.Sort.DESC))) {
            this.expression.withScanIndexForward(false);
        }
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> inconsistent(Builders.Read read) {
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)read), (Object)((Object)Builders.Read.READ))) {
            this.expression.withConsistentRead(false);
        }
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> consistent(Builders.Read read) {
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)read), (Object)((Object)Builders.Read.READ))) {
            this.expression.withConsistentRead(true);
        }
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> index(String name) {
        this.expression.withIndexName(name);
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> hash(Object hash) {
        Object object;
        this.hashKey = object = hash;
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> range(Consumer<RangeConditionCollector<T>> conditions) {
        this.rangeCollectorsConsumers.add(conditions);
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> filter(Consumer<RangeConditionCollector<T>> conditions) {
        this.filterCollectorsConsumers.add(conditions);
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> filter(ConditionalOperator or) {
        this.expression.withConditionalOperator(or);
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> page(int page) {
        this.expression.withLimit(Integer.valueOf(page));
        return this;
    }

    @Override
    public QueryBuilder<T> limit(int max) {
        int n;
        this.max = n = max;
        return this;
    }

    @Override
    public DefaultQueryBuilder<T> offset(Object exclusiveStartHashKeyValue, Object exclusiveRangeStartKey) {
        Object object;
        Object object2;
        this.exclusiveHashStartKey = object2 = exclusiveStartHashKeyValue;
        this.exclusiveRangeStartKey = object = exclusiveRangeStartKey;
        return this;
    }

    @Override
    public int count(IDynamoDBMapper mapper) {
        return mapper.count(this.metadata.getItemClass(), this.resolveExpression(mapper));
    }

    @Override
    public Publisher<T> query(IDynamoDBMapper mapper) {
        Flux<T> results = FluxQueryResultHelper.generate(this.metadata.getItemClass(), mapper, this.resolveExpression(mapper));
        if (this.max < Integer.MAX_VALUE) {
            return results.take((long)this.max);
        }
        return results;
    }

    @Override
    public DynamoDBQueryExpression<T> resolveExpression(IDynamoDBMapper mapper) {
        DynamoDBMapperTableModel model = mapper.getTableModel(this.metadata.getItemClass());
        if (this.hashKey != null) {
            if (this.metadata.getItemClass().isInstance(this.hashKey)) {
                this.expression.withHashKeyValues(this.metadata.getItemClass().cast(this.hashKey));
            } else {
                this.expression.withHashKeyValues(model.createKey(this.hashKey, null));
            }
        }
        this.applyConditions(model, this.rangeCollectorsConsumers, (BiConsumer<String, Condition>)((Object)IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getMethodPointer(this.expression, (String)"withRangeKeyCondition"))));
        this.applyConditions(model, this.filterCollectorsConsumers, (BiConsumer<String, Condition>)((Object)IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getMethodPointer(this.expression, (String)"withQueryFilterEntry"))));
        if (this.exclusiveHashStartKey != null || this.exclusiveRangeStartKey != null) {
            Object exclusiveKey = model.createKey(this.exclusiveHashStartKey, this.exclusiveRangeStartKey);
            this.expression.withExclusiveStartKey(model.convertKey(exclusiveKey));
        }
        this.configurer.accept(this.expression);
        return this.expression;
    }

    @Override
    public QueryBuilder<T> only(Iterable<String> propertyPaths) {
        String string = DefaultGroovyMethods.join(propertyPaths, (String)",");
        this.expression.setProjectionExpression(string);
        return this;
    }

    @Override
    public QueryBuilder<T> configure(Consumer<DynamoDBQueryExpression<T>> configurer) {
        Consumer<DynamoDBQueryExpression<DynamoDBQueryExpression<T>>> consumer = configurer;
        this.configurer = consumer;
        return this;
    }

    public Object getProperty(String name) {
        throw (Throwable)new MissingPropertyException("No properties here!");
    }

    private void applyConditions(DynamoDBMapperTableModel<T> model, List<Consumer<RangeConditionCollector<T>>> filterCollectorsConsumers, BiConsumer<String, Condition> addFilterConsumer) {
        if (!filterCollectorsConsumers.isEmpty()) {
            RangeConditionCollector<T> filterCollector = new RangeConditionCollector<T>(model);
            List<Consumer<RangeConditionCollector<T>>> list = filterCollectorsConsumers;
            Iterator<Consumer<RangeConditionCollector<T>>> iterator = list != null ? list.iterator() : null;
            CallSite consumer = null;
            Iterator<Consumer<RangeConditionCollector<T>>> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    consumer = IndyInterface.bootstrap("cast", "()", 0, iterator2.next());
                    consumer.accept(filterCollector);
                }
            }
            filterCollector.getConditions().forEach(addFilterConsumer);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultQueryBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Void doCall(Object it) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Void doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

