/*
 * Decompiled with CFR 0.152.
 */
package com.agorapulse.micronaut.aws.dynamodb.builder;

import com.agorapulse.micronaut.aws.dynamodb.DynamoDBMetadata;
import com.agorapulse.micronaut.aws.dynamodb.builder.UpdateBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.IDynamoDBMapper;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

class DefaultUpdateBuilder<T>
implements UpdateBuilder<T> {
    private final Class<T> itemType;
    private final List<Update> updates = new ArrayList<Update>();
    private Object hash;
    private Object range;
    private ReturnValue returnValue = ReturnValue.NONE;
    private Function<T, ?> returnValueMapper = Function.identity();
    private Consumer<UpdateItemRequest> configurer = u -> {};

    DefaultUpdateBuilder(Class<T> itemType) {
        this.itemType = itemType;
    }

    @Override
    public UpdateBuilder<T> hash(Object key) {
        this.hash = key;
        return this;
    }

    @Override
    public UpdateBuilder<T> range(Object range) {
        this.range = range;
        return this;
    }

    @Override
    public UpdateBuilder<T> add(String attributeName, Object delta) {
        this.updates.add(new Update(attributeName, AttributeAction.ADD, delta));
        return this;
    }

    @Override
    public UpdateBuilder<T> put(String attributeName, Object value) {
        this.updates.add(new Update(attributeName, AttributeAction.PUT, value));
        return this;
    }

    @Override
    public UpdateBuilder<T> delete(String attributeName) {
        this.updates.add(new Update(attributeName, AttributeAction.DELETE, null));
        return this;
    }

    @Override
    public Object update(IDynamoDBMapper mapper, AmazonDynamoDB client) {
        UpdateItemRequest request = this.resolveExpression(mapper);
        UpdateItemResult result = client.updateItem(request);
        Map attributes = result.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return null;
        }
        return this.returnValueMapper.apply(mapper.getTableModel(this.itemType).unconvert(attributes));
    }

    @Override
    public UpdateItemRequest resolveExpression(IDynamoDBMapper mapper) {
        DynamoDBMapperTableModel tableModel = mapper.getTableModel(this.itemType);
        DynamoDBMetadata<T> metadata = DynamoDBMetadata.create(this.itemType);
        UpdateItemRequest request = new UpdateItemRequest().withTableName(metadata.getMainTable().tableName()).withKey(tableModel.convertKey(this.hash, this.range)).withReturnValues(this.returnValue);
        for (Update u : this.updates) {
            request.addAttributeUpdatesEntry(u.name, new AttributeValueUpdate().withAction(u.action).withValue(tableModel.field(u.name).convert(u.value)));
        }
        this.configurer.accept(request);
        return request;
    }

    @Override
    public UpdateBuilder<T> configure(Consumer<UpdateItemRequest> configurer) {
        this.configurer = configurer;
        return this;
    }

    @Override
    public UpdateBuilder<T> returns(ReturnValue returnValue, Function<T, ?> mapper) {
        this.returnValue = returnValue;
        this.returnValueMapper = mapper;
        return this;
    }

    private static class Update {
        final String name;
        final AttributeAction action;
        final Object value;

        private Update(String name, AttributeAction action, Object value) {
            this.name = name;
            this.action = action;
            this.value = value;
        }
    }
}

