/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2018-2024 Agorapulse.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.agorapulse.micronaut.aws.lambda;

import com.agorapulse.micronaut.aws.util.ConfigurationUtil;
import com.amazonaws.services.lambda.AWSLambda;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;

/**
 * Named configuration for simple queue service created for each key in the configuration.
 */
@Requires(classes = AWSLambda.class, property = "aws.lambda.functions")
@EachProperty(value = "aws.lambda.functions", primary = ConfigurationUtil.DEFAULT_CONFIGURATION_NAME)
public class NamedLambdaConfiguration extends LambdaConfiguration {
    private final String name;

    public NamedLambdaConfiguration(@Parameter String name) {
        this.name = name;
    }

    public final String getName() {
        return name;
    }

}
