/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2021-2022 Vladimir Orany.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.agorapulse.pierrot.api;

import java.util.Optional;
import java.util.stream.Stream;

public interface GitHubService {
    Stream<Content> searchContent(String query, boolean global);

    Optional<Repository> getRepository(String repositoryFullName);

    Stream<? extends PullRequest> searchPullRequests(String query, boolean openOnly, boolean global);

    Optional<Project>  findProject(String org, String project);

    Optional<Project>  findOrCreateProject(String org, String project, String column);
}
