/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import com.airbnb.epoxy.AttributeInfo;
import com.airbnb.epoxy.ControllerClassInfo;
import com.airbnb.epoxy.PackageConfigSettings;
import com.airbnb.epoxy.PackageEpoxyConfig;
import com.airbnb.epoxy.PackageModelViewConfig;
import com.airbnb.epoxy.PackageModelViewSettings;
import com.airbnb.epoxy.Utils;
import com.airbnb.epoxy.ViewAttributeInfo;
import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class ConfigManager {
    static final String PROCESSOR_OPTION_VALIDATE_MODEL_USAGE = "validateEpoxyModelUsage";
    static final String PROCESSOR_OPTION_REQUIRE_HASHCODE = "requireHashCodeInEpoxyModels";
    static final String PROCESSOR_OPTION_REQUIRE_ABSTRACT_MODELS = "requireAbstractEpoxyModels";
    static final String PROCESSOR_OPTION_IMPLICITLY_ADD_AUTO_MODELS = "implicitlyAddAutoModels";
    static final String PROCESSOR_OPTION_DISABLE_KOTLIN_EXTENSION_GENERATION = "disableEpoxyKotlinExtensionGeneration";
    private static final PackageConfigSettings DEFAULT_PACKAGE_CONFIG_SETTINGS = PackageConfigSettings.Companion.forDefaults();
    private final Map<String, PackageConfigSettings> configurationMap = new HashMap<String, PackageConfigSettings>();
    private final Map<String, PackageModelViewSettings> modelViewNamingMap = new HashMap<String, PackageModelViewSettings>();
    private final Elements elementUtils;
    private final boolean validateModelUsage;
    private final boolean globalRequireHashCode;
    private final boolean globalRequireAbstractModels;
    private final boolean globalImplicitlyAddAutoModels;
    private final boolean disableKotlinExtensionGeneration;
    private final Types typeUtils;

    ConfigManager(Map<String, String> options, Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.validateModelUsage = ConfigManager.getBooleanOption(options, PROCESSOR_OPTION_VALIDATE_MODEL_USAGE, true);
        this.globalRequireHashCode = ConfigManager.getBooleanOption(options, PROCESSOR_OPTION_REQUIRE_HASHCODE, false);
        this.globalRequireAbstractModels = ConfigManager.getBooleanOption(options, PROCESSOR_OPTION_REQUIRE_ABSTRACT_MODELS, false);
        this.globalImplicitlyAddAutoModels = ConfigManager.getBooleanOption(options, PROCESSOR_OPTION_IMPLICITLY_ADD_AUTO_MODELS, false);
        this.disableKotlinExtensionGeneration = ConfigManager.getBooleanOption(options, PROCESSOR_OPTION_DISABLE_KOTLIN_EXTENSION_GENERATION, false);
        this.typeUtils = typeUtils;
    }

    private static boolean getBooleanOption(Map<String, String> options, String option, boolean defaultValue) {
        String value = options.get(option);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    List<Exception> processConfigurations(RoundEnvironment roundEnv) {
        String packageName;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (Element element : roundEnv.getElementsAnnotatedWith(PackageEpoxyConfig.class)) {
            packageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
            if (this.configurationMap.containsKey(packageName)) {
                errors.add(Utils.buildEpoxyException("Only one Epoxy configuration annotation is allowed per package (%s)", packageName));
                continue;
            }
            PackageEpoxyConfig annotation = element.getAnnotation(PackageEpoxyConfig.class);
            this.configurationMap.put(packageName, PackageConfigSettings.Companion.create(annotation));
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(PackageModelViewConfig.class)) {
            packageName = this.elementUtils.getPackageOf(element).getQualifiedName().toString();
            if (this.modelViewNamingMap.containsKey(packageName)) {
                errors.add(Utils.buildEpoxyException("Only one %s annotation is allowed per package (%s)", PackageModelViewConfig.class.getSimpleName(), packageName));
                continue;
            }
            ClassName rClassName = Utils.getClassParamFromAnnotation(element, PackageModelViewConfig.class, "rClass", this.typeUtils);
            if (rClassName == null) {
                errors.add(Utils.buildEpoxyException("Unable to get R class details from annotation %s (package: %s)", PackageModelViewConfig.class.getSimpleName(), packageName));
                continue;
            }
            String rLayoutClassString = rClassName.reflectionName();
            if (!rLayoutClassString.endsWith(".R") && !rLayoutClassString.endsWith(".R2")) {
                errors.add(Utils.buildEpoxyException("Invalid R class in %s. Was '%s' (package: %s)", PackageModelViewConfig.class.getSimpleName(), rLayoutClassString, packageName));
                continue;
            }
            PackageModelViewConfig annotation = element.getAnnotation(PackageModelViewConfig.class);
            this.modelViewNamingMap.put(packageName, new PackageModelViewSettings(rClassName, annotation));
        }
        return errors;
    }

    boolean requiresHashCode(AttributeInfo attributeInfo) {
        if (attributeInfo instanceof ViewAttributeInfo) {
            return true;
        }
        return this.globalRequireHashCode || this.getConfigurationForPackage(attributeInfo.getPackageName()).getRequireHashCode();
    }

    boolean requiresAbstractModels(TypeElement classElement) {
        return this.globalRequireAbstractModels || this.getConfigurationForElement(classElement).getRequireAbstractModels();
    }

    boolean implicitlyAddAutoModels(ControllerClassInfo controller) {
        return this.globalImplicitlyAddAutoModels || this.getConfigurationForElement(controller.getControllerClassElement()).getImplicitlyAddAutoModels();
    }

    boolean disableKotlinExtensionGeneration() {
        return this.disableKotlinExtensionGeneration;
    }

    boolean shouldValidateModelUsage() {
        return this.validateModelUsage;
    }

    PackageModelViewSettings getModelViewConfig(Element viewElement) {
        String packageName = this.elementUtils.getPackageOf(viewElement).getQualifiedName().toString();
        return ConfigManager.getObjectFromPackageMap(this.modelViewNamingMap, packageName, null);
    }

    @Nullable
    TypeMirror getDefaultBaseModel(TypeElement viewElement) {
        PackageModelViewSettings modelViewConfig = this.getModelViewConfig(viewElement);
        if (modelViewConfig == null) {
            return null;
        }
        return modelViewConfig.getDefaultBaseModel();
    }

    boolean includeAlternateLayoutsForViews(TypeElement viewElement) {
        PackageModelViewSettings modelViewConfig = this.getModelViewConfig(viewElement);
        if (modelViewConfig == null) {
            return false;
        }
        return modelViewConfig.getIncludeAlternateLayouts();
    }

    String generatedModelSuffix(TypeElement viewElement) {
        PackageModelViewSettings modelViewConfig = this.getModelViewConfig(viewElement);
        if (modelViewConfig == null) {
            return "Model_";
        }
        return modelViewConfig.getGeneratedModelSuffix();
    }

    private PackageConfigSettings getConfigurationForElement(Element element) {
        return this.getConfigurationForPackage(this.elementUtils.getPackageOf(element));
    }

    private PackageConfigSettings getConfigurationForPackage(PackageElement packageElement) {
        String packageName = packageElement.getQualifiedName().toString();
        return this.getConfigurationForPackage(packageName);
    }

    private PackageConfigSettings getConfigurationForPackage(String packageName) {
        return ConfigManager.getObjectFromPackageMap(this.configurationMap, packageName, DEFAULT_PACKAGE_CONFIG_SETTINGS);
    }

    private static <T> T getObjectFromPackageMap(Map<String, T> map, String packageName, T ifNotFound) {
        if (map.containsKey(packageName)) {
            return map.get(packageName);
        }
        Map.Entry<String, T> bestMatch = null;
        for (Map.Entry<String, T> configEntry : map.entrySet()) {
            String entryPackage = configEntry.getKey();
            if (!packageName.startsWith(entryPackage + ".") || bestMatch != null && ((String)bestMatch.getKey()).length() >= entryPackage.length()) continue;
            bestMatch = configEntry;
        }
        return (T)(bestMatch != null ? bestMatch.getValue() : ifNotFound);
    }
}

