/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.AutoModel;
import com.airbnb.epoxy.ClassNames;
import com.airbnb.epoxy.ConfigManager;
import com.airbnb.epoxy.ControllerClassInfo;
import com.airbnb.epoxy.ControllerModelField;
import com.airbnb.epoxy.ErrorLogger;
import com.airbnb.epoxy.GeneratedModelInfo;
import com.airbnb.epoxy.Utils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class ControllerProcessor {
    private Filer filer;
    private Elements elementUtils;
    private Types typeUtils;
    private ErrorLogger errorLogger;
    private final ConfigManager configManager;
    private final Map<TypeElement, ControllerClassInfo> controllerClassMap = new LinkedHashMap<TypeElement, ControllerClassInfo>();

    ControllerProcessor(Filer filer, Elements elementUtils, Types typeUtils, ErrorLogger errorLogger, ConfigManager configManager) {
        this.filer = filer;
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.errorLogger = errorLogger;
        this.configManager = configManager;
    }

    void process(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(AutoModel.class)) {
            try {
                this.addFieldToControllerClass(element, this.controllerClassMap);
            }
            catch (Exception e) {
                this.errorLogger.logError(e);
            }
        }
        try {
            this.updateClassesForInheritance(this.controllerClassMap);
        }
        catch (Exception e) {
            this.errorLogger.logError(e);
        }
    }

    boolean hasControllersToGenerate() {
        return !this.controllerClassMap.isEmpty();
    }

    void resolveGeneratedModelsAndWriteJava(List<GeneratedModelInfo> generatedModels) {
        this.resolveGeneratedModelNames(this.controllerClassMap, generatedModels);
        this.generateJava(this.controllerClassMap);
        this.controllerClassMap.clear();
    }

    private void resolveGeneratedModelNames(Map<TypeElement, ControllerClassInfo> controllerClassMap, List<GeneratedModelInfo> generatedModels) {
        for (ControllerClassInfo controllerClassInfo : controllerClassMap.values()) {
            for (ControllerModelField model : controllerClassInfo.getModels()) {
                if (this.hasFullyQualifiedName(model)) continue;
                model.setTypeName(this.getFullyQualifiedModelTypeName(model, generatedModels));
            }
        }
    }

    private boolean hasFullyQualifiedName(ControllerModelField model) {
        return model.getTypeName().toString().contains(".");
    }

    private TypeName getFullyQualifiedModelTypeName(ControllerModelField model, List<GeneratedModelInfo> generatedModels) {
        String modelName = model.getTypeName().toString();
        for (GeneratedModelInfo generatedModel : generatedModels) {
            String generatedName = generatedModel.getGeneratedName().toString();
            if (!generatedName.endsWith("." + modelName)) continue;
            return generatedModel.getGeneratedName();
        }
        return model.getTypeName();
    }

    private void addFieldToControllerClass(Element modelField, Map<TypeElement, ControllerClassInfo> controllerClassMap) {
        TypeElement controllerClassElement = (TypeElement)modelField.getEnclosingElement();
        ControllerClassInfo controllerClass = this.getOrCreateTargetClass(controllerClassMap, controllerClassElement);
        controllerClass.addModel(this.buildFieldInfo(modelField));
    }

    private void updateClassesForInheritance(Map<TypeElement, ControllerClassInfo> controllerClassMap) {
        for (Map.Entry<TypeElement, ControllerClassInfo> entry : controllerClassMap.entrySet()) {
            TypeElement thisClass = entry.getKey();
            LinkedHashMap<TypeElement, ControllerClassInfo> otherClasses = new LinkedHashMap<TypeElement, ControllerClassInfo>(controllerClassMap);
            otherClasses.remove(thisClass);
            for (Map.Entry otherEntry : otherClasses.entrySet()) {
                TypeElement otherClass = (TypeElement)otherEntry.getKey();
                if (!Utils.isSubtype(thisClass, otherClass, this.typeUtils)) continue;
                Set<ControllerModelField> otherControllerModelFields = ((ControllerClassInfo)otherEntry.getValue()).getModels();
                if (Utils.belongToTheSamePackage(thisClass, otherClass, this.elementUtils)) {
                    entry.getValue().addModels(otherControllerModelFields);
                    continue;
                }
                for (ControllerModelField controllerModelField : otherControllerModelFields) {
                    if (controllerModelField.getPackagePrivate()) continue;
                    entry.getValue().addModel(controllerModelField);
                }
            }
        }
    }

    private ControllerClassInfo getOrCreateTargetClass(Map<TypeElement, ControllerClassInfo> controllerClassMap, TypeElement controllerClassElement) {
        ControllerClassInfo controllerClassInfo;
        if (!Utils.isController(controllerClassElement)) {
            this.errorLogger.logError("Class with %s annotations must extend %s (%s)", AutoModel.class.getSimpleName(), "com.airbnb.epoxy.EpoxyController", controllerClassElement.getSimpleName());
        }
        if ((controllerClassInfo = controllerClassMap.get(controllerClassElement)) == null) {
            controllerClassInfo = new ControllerClassInfo(this.elementUtils, controllerClassElement);
            controllerClassMap.put(controllerClassElement, controllerClassInfo);
        }
        return controllerClassInfo;
    }

    private ControllerModelField buildFieldInfo(Element modelFieldElement) {
        Utils.validateFieldAccessibleViaGeneratedCode(modelFieldElement, AutoModel.class, this.errorLogger);
        TypeMirror fieldType = modelFieldElement.asType();
        if (fieldType.getKind() != TypeKind.ERROR && !Utils.isEpoxyModel(fieldType)) {
            this.errorLogger.logError("Fields with %s annotations must be of type %s (%s#%s)", AutoModel.class.getSimpleName(), "com.airbnb.epoxy.EpoxyModel<?>", modelFieldElement.getEnclosingElement().getSimpleName(), modelFieldElement.getSimpleName());
        }
        return new ControllerModelField(modelFieldElement);
    }

    private void generateJava(Map<TypeElement, ControllerClassInfo> controllerClassMap) {
        for (Map.Entry<TypeElement, ControllerClassInfo> controllerInfo : controllerClassMap.entrySet()) {
            try {
                this.generateHelperClassForController(controllerInfo.getValue());
            }
            catch (Exception e) {
                this.errorLogger.logError(e);
            }
        }
    }

    private void generateHelperClassForController(ControllerClassInfo controllerInfo) throws IOException {
        ParameterizedTypeName parameterizeSuperClass = ParameterizedTypeName.get((ClassName)ClassNames.EPOXY_CONTROLLER_HELPER, (TypeName[])new TypeName[]{controllerInfo.getControllerClassType()});
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)controllerInfo.getGeneratedClassName()).addJavadoc("Generated file. Do not modify!", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)parameterizeSuperClass).addField(controllerInfo.getControllerClassType(), "controller", new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).addMethod(this.buildConstructor(controllerInfo)).addMethod(this.buildResetModelsMethod(controllerInfo));
        if (this.configManager.shouldValidateModelUsage()) {
            builder.addFields(this.buildFieldsToSaveModelsForValidation(controllerInfo)).addMethod(this.buildValidateModelsHaveNotChangedMethod(controllerInfo)).addMethod(this.buildValidateSameValueMethod()).addMethod(this.buildSaveModelsForNextValidationMethod(controllerInfo));
        }
        JavaFile.builder((String)controllerInfo.getGeneratedClassName().packageName(), (TypeSpec)builder.build()).build().writeTo(this.filer);
    }

    private MethodSpec buildConstructor(ControllerClassInfo controllerInfo) {
        ParameterSpec controllerParam = ParameterSpec.builder((TypeName)controllerInfo.getControllerClassType(), (String)"controller", (Modifier[])new Modifier[0]).build();
        return MethodSpec.constructorBuilder().addParameter(controllerParam).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.controller = controller", new Object[0]).build();
    }

    private Iterable<FieldSpec> buildFieldsToSaveModelsForValidation(ControllerClassInfo controllerInfo) {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        for (ControllerModelField model : controllerInfo.getModels()) {
            fields.add(FieldSpec.builder((TypeName)Utils.getClassName("com.airbnb.epoxy.EpoxyModel"), (String)model.getFieldName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        }
        return fields;
    }

    private MethodSpec buildValidateModelsHaveNotChangedMethod(ControllerClassInfo controllerInfo) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"validateModelsHaveNotChanged").addModifiers(new Modifier[]{Modifier.PRIVATE});
        long id = -1L;
        for (ControllerModelField model : controllerInfo.getModels()) {
            builder.addStatement("validateSameModel($L, controller.$L, $S, $L)", new Object[]{model.getFieldName(), model.getFieldName(), model.getFieldName(), id--});
        }
        return builder.addStatement("validateModelHashCodesHaveNotChanged(controller)", new Object[0]).build();
    }

    private MethodSpec buildValidateSameValueMethod() {
        return MethodSpec.methodBuilder((String)"validateSameModel").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)Utils.getClassName("com.airbnb.epoxy.EpoxyModel"), "expectedObject", new Modifier[0]).addParameter((TypeName)Utils.getClassName("com.airbnb.epoxy.EpoxyModel"), "actualObject", new Modifier[0]).addParameter(String.class, "fieldName", new Modifier[0]).addParameter(TypeName.INT, "id", new Modifier[0]).beginControlFlow("if (expectedObject != actualObject)", new Object[0]).addStatement("throw new $T(\"Fields annotated with $L cannot be directly assigned. The controller manages these fields for you. (\" + controller.getClass().getSimpleName() + \"#\" + fieldName + \")\")", new Object[]{IllegalStateException.class, AutoModel.class.getSimpleName()}).endControlFlow().beginControlFlow("if (actualObject != null && actualObject.id() != id)", new Object[0]).addStatement("throw new $T(\"Fields annotated with $L cannot have their id changed manually. The controller manages the ids of these models for you. (\" + controller.getClass().getSimpleName() + \"#\" + fieldName + \")\")", new Object[]{IllegalStateException.class, AutoModel.class.getSimpleName()}).endControlFlow().build();
    }

    private MethodSpec buildSaveModelsForNextValidationMethod(ControllerClassInfo controllerInfo) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"saveModelsForNextValidation").addModifiers(new Modifier[]{Modifier.PRIVATE});
        for (ControllerModelField model : controllerInfo.getModels()) {
            builder.addStatement("$L = controller.$L", new Object[]{model.getFieldName(), model.getFieldName()});
        }
        return builder.build();
    }

    private MethodSpec buildResetModelsMethod(ControllerClassInfo controllerInfo) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"resetAutoModels").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.configManager.shouldValidateModelUsage()) {
            builder.addStatement("validateModelsHaveNotChanged()", new Object[0]);
        }
        boolean implicitlyAddAutoModels = this.configManager.implicitlyAddAutoModels(controllerInfo);
        long id = -1L;
        for (ControllerModelField model : controllerInfo.getModels()) {
            builder.addStatement("controller.$L = new $T()", new Object[]{model.getFieldName(), model.getTypeName()}).addStatement("controller.$L.id($L)", new Object[]{model.getFieldName(), id--});
            if (!implicitlyAddAutoModels) continue;
            builder.addStatement("setControllerToStageTo(controller.$L, controller)", new Object[]{model.getFieldName()});
        }
        if (this.configManager.shouldValidateModelUsage()) {
            builder.addStatement("saveModelsForNextValidation()", new Object[0]);
        }
        return builder.build();
    }
}

