/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.ErrorLogger;
import com.airbnb.epoxy.ResourceProcessor;
import com.airbnb.epoxy.Utils;
import com.squareup.javapoet.ClassName;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class DataBindingModuleLookup {
    private final Elements elements;
    private final Types types;
    private final ErrorLogger errorLogger;
    private final ResourceProcessor resourceProcessor;

    DataBindingModuleLookup(Elements elements, Types types, ErrorLogger errorLogger, ResourceProcessor resourceProcessor) {
        this.elements = elements;
        this.types = types;
        this.errorLogger = errorLogger;
        this.resourceProcessor = resourceProcessor;
    }

    String getModuleName(Element element) {
        PackageElement packageOf = this.elements.getPackageOf(element);
        String packageName = packageOf.getQualifiedName().toString();
        String moduleName = this.getModuleNameViaResources(packageName);
        if (moduleName == null) {
            moduleName = this.getModuleNameViaGuessing(packageName);
        }
        if (moduleName == null) {
            this.errorLogger.logError("Could not find module name for DataBinding BR class.", new Object[0]);
            moduleName = packageName;
        }
        return moduleName;
    }

    private String getModuleNameViaResources(String packageName) {
        List<ClassName> rClasses = this.resourceProcessor.getRClassNames();
        if (rClasses.isEmpty()) {
            return packageName;
        }
        if (rClasses.size() == 1) {
            return rClasses.get(0).packageName();
        }
        String[] packageNames = packageName.split("\\.");
        ClassName bestMatch = null;
        int bestNumMatches = -1;
        for (ClassName rClass : rClasses) {
            String[] rModuleNames = rClass.packageName().split("\\.");
            int numNameMatches = 0;
            for (int i = 0; i < Math.min(packageNames.length, rModuleNames.length) && packageNames[i].equals(rModuleNames[i]); ++i) {
                ++numNameMatches;
            }
            if (numNameMatches <= bestNumMatches) continue;
            bestMatch = rClass;
        }
        return bestMatch.packageName();
    }

    private String getModuleNameViaGuessing(String packageName) {
        String[] packageNameParts = packageName.split("\\.");
        String moduleName = "";
        for (int i = 0; i < packageNameParts.length; ++i) {
            Element rClass = Utils.getElementByName((moduleName = moduleName + packageNameParts[i]) + ".R", this.elements, this.types);
            if (rClass != null) {
                return moduleName;
            }
            moduleName = moduleName + ".";
        }
        return null;
    }
}

