/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.ConfigManager;
import com.airbnb.epoxy.DataBindingModelInfo;
import com.airbnb.epoxy.DataBindingModuleLookup;
import com.airbnb.epoxy.EpoxyDataBindingLayouts;
import com.airbnb.epoxy.EpoxyDataBindingPattern;
import com.airbnb.epoxy.ErrorLogger;
import com.airbnb.epoxy.GeneratedModelWriter;
import com.airbnb.epoxy.ResourceProcessor;
import com.airbnb.epoxy.ResourceValue;
import com.airbnb.epoxy.Utils;
import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/airbnb/epoxy/DataBindingProcessor;", "", "elements", "Ljavax/lang/model/util/Elements;", "types", "Ljavax/lang/model/util/Types;", "errorLogger", "Lcom/airbnb/epoxy/ErrorLogger;", "configManager", "Lcom/airbnb/epoxy/ConfigManager;", "resourceProcessor", "Lcom/airbnb/epoxy/ResourceProcessor;", "dataBindingModuleLookup", "Lcom/airbnb/epoxy/DataBindingModuleLookup;", "modelWriter", "Lcom/airbnb/epoxy/GeneratedModelWriter;", "(Ljavax/lang/model/util/Elements;Ljavax/lang/model/util/Types;Lcom/airbnb/epoxy/ErrorLogger;Lcom/airbnb/epoxy/ConfigManager;Lcom/airbnb/epoxy/ResourceProcessor;Lcom/airbnb/epoxy/DataBindingModuleLookup;Lcom/airbnb/epoxy/GeneratedModelWriter;)V", "modelsToWrite", "Ljava/util/ArrayList;", "Lcom/airbnb/epoxy/DataBindingModelInfo;", "hasModelsToWrite", "", "process", "", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "resolveDataBindingClassesAndWriteJava", "epoxy-processor"})
public final class DataBindingProcessor {
    private final ArrayList<DataBindingModelInfo> modelsToWrite;
    private final Elements elements;
    private final Types types;
    private final ErrorLogger errorLogger;
    private final ConfigManager configManager;
    private final ResourceProcessor resourceProcessor;
    private final DataBindingModuleLookup dataBindingModuleLookup;
    private final GeneratedModelWriter modelWriter;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DataBindingModelInfo> process(@NotNull RoundEnvironment roundEnv) {
        Iterator iterator;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)roundEnv, (String)"roundEnv");
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(EpoxyDataBindingLayouts.class);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"roundEnv.getElementsAnno\u2026ndingLayouts::class.java)");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            Element it = (Element)element$iv;
            List<ResourceValue> layoutResources = this.resourceProcessor.getLayoutsInAnnotation(it, EpoxyDataBindingLayouts.class);
            String moduleName = this.dataBindingModuleLookup.getModuleName(it);
            Element element = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
            Object $receiver$iv2 = element;
            EpoxyDataBindingLayouts epoxyDataBindingLayouts = $receiver$iv2.getAnnotation(EpoxyDataBindingLayouts.class);
            boolean enableDoNotHash = epoxyDataBindingLayouts != null && epoxyDataBindingLayouts.enableDoNotHash();
            List<ResourceValue> list = layoutResources;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"layoutResources");
            $receiver$iv2 = list;
            Collection destination$iv = this.modelsToWrite;
            Iterator iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                void it2;
                Object item$iv = iterator2.next();
                ResourceValue resourceValue = (ResourceValue)item$iv;
                object = destination$iv;
                void v4 = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                String string = moduleName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleName");
                iterator = new DataBindingModelInfo(this.types, this.elements, (ResourceValue)v4, string, null, enableDoNotHash, 16, null);
                object.add(iterator);
            }
        }
        Set<? extends Element> set2 = roundEnv.getElementsAnnotatedWith(EpoxyDataBindingPattern.class);
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"roundEnv.getElementsAnno\u2026ndingPattern::class.java)");
        $receiver$iv = set2;
        for (Object element$iv : $receiver$iv) {
            Object object2;
            String it;
            Collection collection;
            Object item$iv$iv;
            Object element$iv$iv;
            Object $receiver$iv$iv;
            ClassName rClassName;
            Element element = (Element)element$iv;
            EpoxyDataBindingPattern patternAnnotation = element.getAnnotation(EpoxyDataBindingPattern.class);
            String layoutPrefix = patternAnnotation.layoutPrefix();
            if (Utils.getClassParamFromAnnotation(element, EpoxyDataBindingPattern.class, "rClass", this.types) == null) {
                continue;
            }
            String moduleName = rClassName.packageName();
            ClassName layoutClassName = ClassName.get((String)moduleName, (String)"R", (String[])new String[]{"layout"});
            Element element2 = element;
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
            Object $receiver$iv3 = element2;
            EpoxyDataBindingLayouts epoxyDataBindingLayouts = $receiver$iv3.getAnnotation(EpoxyDataBindingLayouts.class);
            boolean enableDoNotHash = epoxyDataBindingLayouts != null && epoxyDataBindingLayouts.enableDoNotHash();
            TypeElement typeElement = Utils.getElementByName(layoutClassName, this.elements, this.types);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"Utils.getElementByName(l\u2026assName, elements, types)");
            List<? extends Element> list = typeElement.getEnclosedElements();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Utils.getElementByName(l\u2026        .enclosedElements");
            $receiver$iv3 = list;
            Object $i$f$annotation = $receiver$iv3;
            Collection destination$iv$iv = new ArrayList();
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                if (!(element$iv$iv instanceof VariableElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv3 = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                VariableElement $i$f$filterIsInstanceTo = (VariableElement)item$iv$iv;
                collection = destination$iv$iv;
                object2 = it.getSimpleName().toString();
                collection.add(object2);
            }
            $receiver$iv3 = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv3;
            destination$iv$iv = new ArrayList();
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                it = (String)element$iv$iv;
                if (!StringsKt.startsWith$default((String)it, (String)layoutPrefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv3 = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                ClassName className = layoutClassName;
                Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"layoutClassName");
                object2 = new ResourceValue(className, it, 0);
                collection.add(object2);
            }
            $receiver$iv3 = (List)destination$iv$iv;
            Collection destination$iv = this.modelsToWrite;
            object = $receiver$iv3.iterator();
            while (object.hasNext()) {
                void it3;
                Object item$iv = object.next();
                item$iv$iv = (ResourceValue)item$iv;
                collection = destination$iv;
                String string = moduleName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleName");
                object2 = new DataBindingModelInfo(this.types, this.elements, (ResourceValue)it3, string, layoutPrefix, enableDoNotHash);
                collection.add(object2);
            }
        }
        List<DataBindingModelInfo> modelsWritten = this.resolveDataBindingClassesAndWriteJava();
        Collection collection = modelsWritten;
        if (!collection.isEmpty()) {
            this.modelsToWrite.clear();
        }
        return modelsWritten;
    }

    public final boolean hasModelsToWrite() {
        Collection collection = this.modelsToWrite;
        return !collection.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final List<DataBindingModelInfo> resolveDataBindingClassesAndWriteJava() {
        DataBindingModelInfo it;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.modelsToWrite;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (DataBindingModelInfo)element$iv$iv;
            if (!it.parseDataBindingClass()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable $receiver$iv2 = iterable = $receiver$iv;
        for (Object element$iv : $receiver$iv2) {
            it = (DataBindingModelInfo)element$iv;
            try {
                GeneratedModelWriter.generateClassForModel$default(this.modelWriter, it, null, 2, null);
            }
            catch (Exception e) {
                this.errorLogger.logError(e, "Error generating model classes");
            }
            this.modelsToWrite.remove(it);
        }
        return (List)iterable;
    }

    public DataBindingProcessor(@NotNull Elements elements, @NotNull Types types, @NotNull ErrorLogger errorLogger, @NotNull ConfigManager configManager, @NotNull ResourceProcessor resourceProcessor, @NotNull DataBindingModuleLookup dataBindingModuleLookup, @NotNull GeneratedModelWriter modelWriter) {
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)errorLogger, (String)"errorLogger");
        Intrinsics.checkParameterIsNotNull((Object)configManager, (String)"configManager");
        Intrinsics.checkParameterIsNotNull((Object)resourceProcessor, (String)"resourceProcessor");
        Intrinsics.checkParameterIsNotNull((Object)dataBindingModuleLookup, (String)"dataBindingModuleLookup");
        Intrinsics.checkParameterIsNotNull((Object)modelWriter, (String)"modelWriter");
        this.elements = elements;
        this.types = types;
        this.errorLogger = errorLogger;
        this.configManager = configManager;
        this.resourceProcessor = resourceProcessor;
        this.dataBindingModuleLookup = dataBindingModuleLookup;
        this.modelWriter = modelWriter;
        this.modelsToWrite = new ArrayList();
    }
}

