/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.AttributeInfo;
import com.airbnb.epoxy.AutoModel;
import com.airbnb.epoxy.CallbackProp;
import com.airbnb.epoxy.ClassNames;
import com.airbnb.epoxy.ConfigManager;
import com.airbnb.epoxy.ControllerProcessor;
import com.airbnb.epoxy.DataBindingModuleLookup;
import com.airbnb.epoxy.DataBindingProcessor;
import com.airbnb.epoxy.EpoxyAttribute;
import com.airbnb.epoxy.EpoxyDataBindingLayouts;
import com.airbnb.epoxy.EpoxyDataBindingPattern;
import com.airbnb.epoxy.EpoxyModelClass;
import com.airbnb.epoxy.EpoxyProcessorException;
import com.airbnb.epoxy.ErrorLogger;
import com.airbnb.epoxy.GeneratedModelInfo;
import com.airbnb.epoxy.GeneratedModelWriter;
import com.airbnb.epoxy.HashCodeValidator;
import com.airbnb.epoxy.KotlinModelBuilderExtensionWriter;
import com.airbnb.epoxy.LithoSpecProcessor;
import com.airbnb.epoxy.ModelProcessor;
import com.airbnb.epoxy.ModelView;
import com.airbnb.epoxy.ModelViewProcessor;
import com.airbnb.epoxy.PackageEpoxyConfig;
import com.airbnb.epoxy.PackageModelViewConfig;
import com.airbnb.epoxy.ResourceProcessor;
import com.airbnb.epoxy.TextProp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedOptions(value={"implicitlyAddAutoModels", "validateEpoxyModelUsage", "requireAbstractEpoxyModels", "requireHashCodeInEpoxyModels", "disableEpoxyKotlinExtensionGeneration", "kapt.kotlin.generated"})
public class EpoxyProcessor
extends AbstractProcessor {
    public static final String KAPT_KOTLIN_GENERATED_OPTION_NAME = "kapt.kotlin.generated";
    private final Map<String, String> testOptions;
    private Messager messager;
    private Elements elementUtils;
    private Types typeUtils;
    private ConfigManager configManager;
    private final ErrorLogger errorLogger = new ErrorLogger();
    private ControllerProcessor controllerProcessor;
    private DataBindingProcessor dataBindingProcessor;
    private final List<GeneratedModelInfo> generatedModels = new ArrayList<GeneratedModelInfo>();
    private ModelProcessor modelProcessor;
    private LithoSpecProcessor lithoSpecProcessor;
    private KotlinModelBuilderExtensionWriter kotlinExtensionWriter;
    private ModelViewProcessor modelViewProcessor;

    public EpoxyProcessor() {
        this(Collections.emptyMap());
    }

    public EpoxyProcessor(Map<String, String> options) {
        this.testOptions = options;
    }

    public static EpoxyProcessor withNoValidation() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("validateEpoxyModelUsage", "false");
        return new EpoxyProcessor(options);
    }

    public static EpoxyProcessor withImplicitAdding() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("implicitlyAddAutoModels", "true");
        return new EpoxyProcessor(options);
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Filer filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        ResourceProcessor resourceProcessor = new ResourceProcessor(processingEnv, this.errorLogger, this.elementUtils, this.typeUtils);
        this.configManager = new ConfigManager(!this.testOptions.isEmpty() ? this.testOptions : processingEnv.getOptions(), this.elementUtils, this.typeUtils);
        DataBindingModuleLookup dataBindingModuleLookup = new DataBindingModuleLookup(this.elementUtils, this.typeUtils, this.errorLogger, resourceProcessor);
        GeneratedModelWriter modelWriter = new GeneratedModelWriter(filer, this.typeUtils, this.errorLogger, resourceProcessor, this.configManager, dataBindingModuleLookup, this.elementUtils);
        this.controllerProcessor = new ControllerProcessor(filer, this.elementUtils, this.typeUtils, this.errorLogger, this.configManager);
        this.dataBindingProcessor = new DataBindingProcessor(this.elementUtils, this.typeUtils, this.errorLogger, this.configManager, resourceProcessor, dataBindingModuleLookup, modelWriter);
        this.modelProcessor = new ModelProcessor(this.elementUtils, this.typeUtils, this.configManager, this.errorLogger, modelWriter);
        this.modelViewProcessor = new ModelViewProcessor(this.elementUtils, this.typeUtils, this.configManager, this.errorLogger, modelWriter, resourceProcessor);
        this.lithoSpecProcessor = new LithoSpecProcessor(this.elementUtils, this.typeUtils, this.errorLogger, modelWriter);
        this.kotlinExtensionWriter = new KotlinModelBuilderExtensionWriter(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(EpoxyModelClass.class.getCanonicalName());
        types.add(EpoxyAttribute.class.getCanonicalName());
        types.add(PackageEpoxyConfig.class.getCanonicalName());
        types.add(AutoModel.class.getCanonicalName());
        types.add(EpoxyDataBindingLayouts.class.getCanonicalName());
        types.add(EpoxyDataBindingPattern.class.getCanonicalName());
        types.add(ModelView.class.getCanonicalName());
        types.add(PackageModelViewConfig.class.getCanonicalName());
        types.add(TextProp.class.getCanonicalName());
        types.add(CallbackProp.class.getCanonicalName());
        types.add(ClassNames.LITHO_ANNOTATION_LAYOUT_SPEC.reflectionName());
        return types;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.processRound(roundEnv);
        }
        catch (Exception e) {
            this.errorLogger.logError(e);
        }
        if (roundEnv.processingOver()) {
            this.validateAttributesImplementHashCode(this.generatedModels);
            this.errorLogger.writeExceptions(this.messager);
        }
        return false;
    }

    private void processRound(RoundEnvironment roundEnv) {
        this.errorLogger.logErrors(this.configManager.processConfigurations(roundEnv));
        this.generatedModels.addAll(this.modelProcessor.processModels(roundEnv));
        this.generatedModels.addAll(this.dataBindingProcessor.process(roundEnv));
        this.generatedModels.addAll(this.lithoSpecProcessor.processSpecs(roundEnv));
        this.generatedModels.addAll(this.modelViewProcessor.process(roundEnv, this.generatedModels));
        this.controllerProcessor.process(roundEnv);
        if (roundEnv.processingOver() && !this.configManager.disableKotlinExtensionGeneration()) {
            this.kotlinExtensionWriter.generateExtensionsForModels(this.generatedModels);
        }
        if (this.controllerProcessor.hasControllersToGenerate() && (!this.areModelsWaitingToWrite() || roundEnv.processingOver())) {
            this.controllerProcessor.resolveGeneratedModelsAndWriteJava(this.generatedModels);
        }
    }

    private boolean areModelsWaitingToWrite() {
        return this.dataBindingProcessor.hasModelsToWrite() || this.modelProcessor.hasModelsToWrite() || this.modelViewProcessor.hasModelsToWrite();
    }

    private void validateAttributesImplementHashCode(Collection<GeneratedModelInfo> generatedClasses) {
        HashCodeValidator hashCodeValidator = new HashCodeValidator(this.typeUtils, this.elementUtils);
        for (GeneratedModelInfo generatedClass : generatedClasses) {
            for (AttributeInfo attributeInfo : generatedClass.getAttributeInfo()) {
                if (!this.configManager.requiresHashCode(attributeInfo) || !attributeInfo.getUseInHash() || attributeInfo.getIgnoreRequireHashCode()) continue;
                try {
                    hashCodeValidator.validate(attributeInfo);
                }
                catch (EpoxyProcessorException e) {
                    this.errorLogger.logError(e);
                }
            }
        }
    }
}

