/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.ErrorLogger;

class EpoxyProcessorException
extends Exception {
    EpoxyProcessorException(String message) {
        super(message);
    }

    EpoxyProcessorException(Exception e, String message) {
        super(message, e);
        this.setStackTrace(e.getStackTrace());
    }

    @Override
    public String toString() {
        String string = "Epoxy Processor Exception: " + this.getMessage();
        Throwable cause = this.getCause();
        if (cause != null) {
            string = string + " Caused by " + cause.getClass().getSimpleName() + ": " + cause.getMessage();
            StackTraceElement[] stackTrace = this.getStackTrace();
            boolean firstTraceElement = true;
            if (stackTrace.length > 0) {
                for (StackTraceElement stackTraceElement : stackTrace) {
                    if (!stackTraceElement.getClassName().contains("epoxy") || stackTraceElement.getClassName().contains(ErrorLogger.class.getSimpleName()) || stackTraceElement.getClassName().contains("buildEpoxyException")) continue;
                    if (firstTraceElement) {
                        string = string + "       Stacktrace:      ";
                        firstTraceElement = false;
                    } else {
                        string = string + "       ";
                    }
                    string = string + stackTraceElement;
                }
            }
        }
        return string;
    }
}

