/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.EpoxyProcessorException;
import com.airbnb.epoxy.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\b2\n\u0010\t\u001a\u00060\u0005j\u0002`\u00062\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J'\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0010\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\b2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u0014J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/airbnb/epoxy/ErrorLogger;", "", "()V", "loggedExceptions", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logEpoxyError", "", "e", "Lcom/airbnb/epoxy/EpoxyProcessorException;", "logError", "message", "", "msg", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "logErrors", "exceptions", "", "writeExceptions", "messager", "Ljavax/annotation/processing/Messager;", "epoxy-processor"})
public final class ErrorLogger {
    private final List<Exception> loggedExceptions;

    public final void writeExceptions(@NotNull Messager messager) {
        Intrinsics.checkParameterIsNotNull((Object)messager, (String)"messager");
        Iterable $receiver$iv = this.loggedExceptions;
        for (Object element$iv : $receiver$iv) {
            Exception it = (Exception)element$iv;
            messager.printMessage(Diagnostic.Kind.ERROR, it.toString());
        }
    }

    public final void logErrors(@NotNull List<? extends Exception> exceptions) {
        Intrinsics.checkParameterIsNotNull(exceptions, (String)"exceptions");
        Iterable $receiver$iv = exceptions;
        for (Object element$iv : $receiver$iv) {
            Exception it = (Exception)element$iv;
            ErrorLogger.logError$default(this, it, null, 2, null);
        }
    }

    public final void logError(@NotNull String msg, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        EpoxyProcessorException epoxyProcessorException = Utils.buildEpoxyException(msg, Arrays.copyOf(args, args.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)epoxyProcessorException, (String)"buildEpoxyException(msg, *args)");
        ErrorLogger.logError$default(this, epoxyProcessorException, null, 2, null);
    }

    @JvmOverloads
    public final void logError(@NotNull Exception e, @NotNull String message) {
        EpoxyProcessorException epoxyProcessorException;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Exception exception = e;
        if (!(exception instanceof EpoxyProcessorException)) {
            exception = null;
        }
        if ((epoxyProcessorException = (EpoxyProcessorException)exception) == null) {
            epoxyProcessorException = new EpoxyProcessorException(e, message);
        }
        this.logEpoxyError(epoxyProcessorException);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void logError$default(ErrorLogger errorLogger, Exception exception, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        errorLogger.logError(exception, string);
    }

    @JvmOverloads
    public final void logError(@NotNull Exception e) {
        ErrorLogger.logError$default(this, e, null, 2, null);
    }

    private final void logEpoxyError(EpoxyProcessorException e) {
        Collection collection = this.loggedExceptions;
        collection.add(e);
    }

    public ErrorLogger() {
        List list;
        ErrorLogger errorLogger = this;
        errorLogger.loggedExceptions = list = (List)new ArrayList();
    }
}

