/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import com.airbnb.epoxy.AttributeInfo;
import com.airbnb.epoxy.EpoxyProcessorException;
import com.airbnb.epoxy.ModelView;
import com.airbnb.epoxy.ParisStyleAttributeInfo;
import com.airbnb.epoxy.Utils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.jetbrains.annotations.NotNull;

abstract class GeneratedModelInfo {
    private static final String RESET_METHOD = "reset";
    public static final String GENERATED_CLASS_NAME_SUFFIX = "_";
    public static final String GENERATED_MODEL_SUFFIX = "Model_";
    protected TypeName superClassName;
    protected TypeElement superClassElement;
    protected TypeName parametrizedClassName;
    protected ClassName generatedClassName;
    protected TypeName boundObjectTypeName;
    protected boolean shouldGenerateModel;
    protected boolean includeOtherLayoutOptions;
    protected final List<AttributeInfo> attributeInfo = new ArrayList<AttributeInfo>();
    protected final List<TypeVariableName> typeVariableNames = new ArrayList<TypeVariableName>();
    protected final List<ConstructorInfo> constructors = new ArrayList<ConstructorInfo>();
    protected final Set<MethodInfo> methodsReturningClassType = new LinkedHashSet<MethodInfo>();
    protected final List<AttributeGroup> attributeGroups = new ArrayList<AttributeGroup>();
    protected final List<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
    private ParisStyleAttributeInfo styleBuilderInfo;
    ModelView.Size layoutParams = ModelView.Size.NONE;

    GeneratedModelInfo() {
    }

    protected static List<ConstructorInfo> getClassConstructors(TypeElement classElement) {
        ArrayList<ConstructorInfo> constructors = new ArrayList<ConstructorInfo>(2);
        for (Element element : classElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.CONSTRUCTOR || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            ExecutableElement constructor = (ExecutableElement)element;
            List<? extends VariableElement> params = constructor.getParameters();
            constructors.add(new ConstructorInfo(element.getModifiers(), GeneratedModelInfo.buildParamSpecs(params), constructor.isVarArgs()));
        }
        return constructors;
    }

    protected void collectMethodsReturningClassType(TypeElement modelClass, Types typeUtils) {
        TypeElement clazz = modelClass;
        while (clazz.getSuperclass().getKind() != TypeKind.NONE) {
            for (Element element : clazz.getEnclosedElements()) {
                TypeMirror methodReturnType;
                Set<Modifier> modifiers = element.getModifiers();
                if (element.getKind() != ElementKind.METHOD || modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.FINAL) || modifiers.contains((Object)Modifier.STATIC) || !(methodReturnType = ((ExecutableType)element.asType()).getReturnType()).equals(clazz.asType()) && !typeUtils.isSubtype(clazz.asType(), methodReturnType)) continue;
                ExecutableElement castedSubElement = (ExecutableElement)element;
                List<? extends VariableElement> params = castedSubElement.getParameters();
                String methodName = element.getSimpleName().toString();
                if (methodName.equals(RESET_METHOD) && params.isEmpty()) continue;
                this.methodsReturningClassType.add(new MethodInfo(methodName, modifiers, GeneratedModelInfo.buildParamSpecs(params), castedSubElement.isVarArgs()));
            }
            clazz = (TypeElement)typeUtils.asElement(clazz.getSuperclass());
        }
    }

    protected static List<ParameterSpec> buildParamSpecs(List<? extends VariableElement> params) {
        ArrayList<ParameterSpec> result = new ArrayList<ParameterSpec>();
        for (VariableElement variableElement : params) {
            ParameterSpec.Builder builder = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)variableElement.asType()), (String)variableElement.getSimpleName().toString(), (Modifier[])new Modifier[0]);
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
            }
            result.add(builder.build());
        }
        return result;
    }

    void addAttribute(AttributeInfo attributeInfo) {
        this.addAttributes(Collections.singletonList(attributeInfo));
    }

    void addAttributes(Collection<AttributeInfo> attributesToAdd) {
        this.removeMethodIfDuplicatedBySetter(attributesToAdd);
        for (AttributeInfo info : attributesToAdd) {
            int existingIndex = this.attributeInfo.indexOf(info);
            if (existingIndex > -1) {
                this.attributeInfo.set(existingIndex, info);
                continue;
            }
            this.attributeInfo.add(info);
        }
    }

    void addAttributeIfNotExists(AttributeInfo attributeToAdd) {
        if (!this.attributeInfo.contains(attributeToAdd)) {
            this.addAttribute(attributeToAdd);
        }
    }

    private void removeMethodIfDuplicatedBySetter(Collection<AttributeInfo> attributeInfos) {
        for (AttributeInfo attributeInfo : attributeInfos) {
            Iterator<MethodInfo> iterator = this.methodsReturningClassType.iterator();
            while (iterator.hasNext()) {
                MethodInfo methodInfo = iterator.next();
                if (!methodInfo.name.equals(attributeInfo.getFieldName()) || methodInfo.params.size() != 1 || !methodInfo.params.get((int)0).type.equals((Object)attributeInfo.getTypeName())) continue;
                iterator.remove();
            }
        }
    }

    TypeName getSuperClassName() {
        return this.superClassName;
    }

    Set<MethodInfo> getMethodsReturningClassType() {
        return this.methodsReturningClassType;
    }

    ClassName getGeneratedName() {
        return this.generatedClassName;
    }

    List<AttributeInfo> getAttributeInfo() {
        return this.attributeInfo;
    }

    Iterable<TypeVariableName> getTypeVariables() {
        return this.typeVariableNames;
    }

    TypeName getParameterizedGeneratedName() {
        return this.parametrizedClassName;
    }

    TypeName getModelType() {
        return this.boundObjectTypeName;
    }

    List<AnnotationSpec> getAnnotations() {
        return this.annotations;
    }

    @Nullable
    ParisStyleAttributeInfo getStyleBuilderInfo() {
        return this.styleBuilderInfo;
    }

    boolean isStyleable() {
        return this.getStyleBuilderInfo() != null;
    }

    void setStyleable(@NotNull ParisStyleAttributeInfo parisStyleAttributeInfo) {
        this.styleBuilderInfo = parisStyleAttributeInfo;
        this.addAttribute(parisStyleAttributeInfo);
    }

    boolean isProgrammaticView() {
        return this.isStyleable() || this.layoutParams != ModelView.Size.NONE;
    }

    boolean hasEmptyConstructor() {
        if (this.constructors.isEmpty()) {
            return true;
        }
        for (ConstructorInfo constructor : this.constructors) {
            if (!constructor.params.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isSuperClassAlsoGenerated() {
        return Utils.isSubtypeOfType(this.superClassElement.asType(), "com.airbnb.epoxy.GeneratedModel<?>");
    }

    public String toString() {
        return "GeneratedModelInfo{attributeInfo=" + this.attributeInfo + ", superClassName=" + this.superClassName + '}';
    }

    void addAttributeGroup(String groupName, List<AttributeInfo> attributes) throws EpoxyProcessorException {
        AttributeInfo defaultAttribute = null;
        for (AttributeInfo attribute : attributes) {
            boolean hasSetExplicitDefault;
            if (attribute.isRequired() || attribute.getCodeToSetDefault().isEmpty()) continue;
            boolean bl = hasSetExplicitDefault = defaultAttribute != null && defaultAttribute.getCodeToSetDefault().getExplicit() != null;
            if (hasSetExplicitDefault && attribute.getCodeToSetDefault().getExplicit() != null) {
                throw Utils.buildEpoxyException("Only one default value can exist for a group of attributes: " + attributes, new Object[0]);
            }
            if (hasSetExplicitDefault || defaultAttribute != null && attribute.getCodeToSetDefault().getExplicit() == null && !attribute.hasSetNullability()) continue;
            defaultAttribute = attribute;
        }
        AttributeGroup group = new AttributeGroup(groupName, attributes, defaultAttribute);
        this.attributeGroups.add(group);
        for (AttributeInfo attribute : attributes) {
            attribute.setAttributeGroup(group);
        }
    }

    static class AttributeGroup {
        final String name;
        final List<AttributeInfo> attributes;
        final boolean isRequired;
        final AttributeInfo defaultAttribute;

        AttributeGroup(String groupName, List<AttributeInfo> attributes, AttributeInfo defaultAttribute) throws EpoxyProcessorException {
            if (attributes.isEmpty()) {
                throw Utils.buildEpoxyException("Attributes cannot be empty", new Object[0]);
            }
            if (defaultAttribute != null && defaultAttribute.getCodeToSetDefault().isEmpty()) {
                throw Utils.buildEpoxyException("Default attribute has no default code", new Object[0]);
            }
            this.defaultAttribute = defaultAttribute;
            this.isRequired = defaultAttribute == null;
            this.name = groupName;
            this.attributes = new ArrayList<AttributeInfo>(attributes);
        }

        CodeBlock codeToSetDefaultValue() {
            if (this.defaultAttribute == null || this.defaultAttribute.getCodeToSetDefault().isEmpty()) {
                throw new IllegalStateException("No default value exists");
            }
            return CodeBlock.of((String)this.defaultAttribute.setterCode(), (Object[])new Object[]{this.defaultAttribute.getCodeToSetDefault().value()});
        }
    }

    static class MethodInfo {
        final String name;
        final Set<Modifier> modifiers;
        final List<ParameterSpec> params;
        final boolean varargs;

        MethodInfo(String name, Set<Modifier> modifiers, List<ParameterSpec> params, boolean varargs) {
            this.name = name;
            this.modifiers = modifiers;
            this.params = params;
            this.varargs = varargs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodInfo that = (MethodInfo)o;
            if (this.varargs != that.varargs) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.modifiers != null ? !this.modifiers.equals(that.modifiers) : that.modifiers != null) {
                return false;
            }
            return this.params != null ? this.params.equals(that.params) : that.params == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.modifiers != null ? this.modifiers.hashCode() : 0);
            result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
            result = 31 * result + (this.varargs ? 1 : 0);
            return result;
        }
    }

    static class ConstructorInfo {
        final Set<Modifier> modifiers;
        final List<ParameterSpec> params;
        final boolean varargs;

        ConstructorInfo(Set<Modifier> modifiers, List<ParameterSpec> params, boolean varargs) {
            this.modifiers = modifiers;
            this.params = params;
            this.varargs = varargs;
        }
    }
}

