/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.AttributeInfo;
import com.airbnb.epoxy.ClassNames;
import com.airbnb.epoxy.ErrorLogger;
import com.airbnb.epoxy.GeneratedModelWriter;
import com.airbnb.epoxy.HashCodeValidator;
import com.airbnb.epoxy.KotlinUtilsKt;
import com.airbnb.epoxy.LithoModelInfo;
import com.airbnb.epoxy.Utils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/airbnb/epoxy/LithoSpecProcessor;", "", "elementUtils", "Ljavax/lang/model/util/Elements;", "typeUtils", "Ljavax/lang/model/util/Types;", "errorLogger", "Lcom/airbnb/epoxy/ErrorLogger;", "modelWriter", "Lcom/airbnb/epoxy/GeneratedModelWriter;", "(Ljavax/lang/model/util/Elements;Ljavax/lang/model/util/Types;Lcom/airbnb/epoxy/ErrorLogger;Lcom/airbnb/epoxy/GeneratedModelWriter;)V", "layoutSpecAnnotationClass", "Ljava/lang/Class;", "", "getModelInfoForProp", "Lcom/airbnb/epoxy/LithoModelInfo;", "modelInfoMap", "", "Ljavax/lang/model/element/TypeElement;", "propElement", "Ljavax/lang/model/element/Element;", "hasLithoEpoxyDependency", "", "processSpecs", "", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "updateGeneratedClassForLithoComponent", "", "modelInfo", "classBuilder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "epoxy-processor"})
public final class LithoSpecProcessor {
    private Class<? extends Annotation> layoutSpecAnnotationClass;
    private final Elements elementUtils;
    private final Types typeUtils;
    private final ErrorLogger errorLogger;
    private final GeneratedModelWriter modelWriter;

    @NotNull
    public final Collection<LithoModelInfo> processSpecs(@NotNull RoundEnvironment roundEnv) {
        Object lithoModelInfo;
        Iterator $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)roundEnv, (String)"roundEnv");
        if (!this.hasLithoEpoxyDependency()) {
            return CollectionsKt.emptyList();
        }
        this.layoutSpecAnnotationClass = Utils.getAnnotationClass(ClassNames.LITHO_ANNOTATION_LAYOUT_SPEC);
        if (this.layoutSpecAnnotationClass == null) {
            return CollectionsKt.emptyList();
        }
        LinkedHashMap<TypeElement, LithoModelInfo> modelInfoMap = new LinkedHashMap<TypeElement, LithoModelInfo>();
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(this.layoutSpecAnnotationClass);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"roundEnv.getElementsAnno\u2026ayoutSpecAnnotationClass)");
        Iterable $receiver$iv = set;
        Iterable iterable = $receiver$iv;
        Collection entry = new ArrayList();
        Iterator<Object> iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof TypeElement)) continue;
            entry.add(element$iv$iv);
        }
        $receiver$iv = (List)entry;
        for (Object t : $receiver$iv) {
            TypeElement it = (TypeElement)t;
            modelInfoMap.put(it, new LithoModelInfo(this.typeUtils, this.elementUtils, it));
        }
        Class<? extends Annotation> propClass = Utils.getAnnotationClass(ClassNames.LITHO_ANNOTATION_PROP);
        HashCodeValidator hashCodeValidator = new HashCodeValidator(this.typeUtils, this.elementUtils);
        for (Element element : roundEnv.getElementsAnnotatedWith(propClass)) {
            Map map = modelInfoMap;
            Element element2 = element;
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"propElement");
            Object object = lithoModelInfo = this.getModelInfoForProp(map, element2);
            if (object == null) continue;
            ((LithoModelInfo)object).addProp(element, hashCodeValidator);
        }
        lithoModelInfo = modelInfoMap;
        iterator = lithoModelInfo.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry2;
            Map.Entry $i$f$forEach = entry2 = (Map.Entry)iterator.next();
            LithoModelInfo modelInfo = (LithoModelInfo)$i$f$forEach.getValue();
            try {
                this.modelWriter.generateClassForModel(modelInfo, new GeneratedModelWriter.BuilderHooks(this, modelInfo){
                    final /* synthetic */ LithoSpecProcessor this$0;
                    final /* synthetic */ LithoModelInfo $modelInfo;

                    public void beforeFinalBuild(@NotNull TypeSpec.Builder builder) {
                        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                        LithoSpecProcessor.access$updateGeneratedClassForLithoComponent(this.this$0, this.$modelInfo, builder);
                    }
                    {
                        this.this$0 = $outer;
                        this.$modelInfo = $captured_local_variable$1;
                    }
                });
            }
            catch (Exception e) {
                this.errorLogger.logError(e, "Error generating model classes");
            }
        }
        Collection<LithoModelInfo> collection = modelInfoMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"modelInfoMap.values");
        return collection;
    }

    private final boolean hasLithoEpoxyDependency() {
        String string = ClassNames.EPOXY_LITHO_MODEL.reflectionName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EPOXY_LITHO_MODEL.reflectionName()");
        return KotlinUtilsKt.getTypeMirror(string, this.elementUtils) != null;
    }

    private final void updateGeneratedClassForLithoComponent(LithoModelInfo modelInfo, TypeSpec.Builder classBuilder) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"buildComponent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassNames.LITHO_COMPONENT, (TypeName[])new TypeName[]{(TypeName)modelInfo.getLithoComponentName()})).addParameter((TypeName)ClassNames.LITHO_COMPONENT_CONTEXT, "context", new Modifier[0]).addCode("return $T.create(context)", new Object[]{modelInfo.getLithoComponentName()});
        for (AttributeInfo attributeInfo : modelInfo.attributeInfo) {
            methodBuilder.addCode(".$L($L)", new Object[]{attributeInfo.getFieldName(), attributeInfo.getFieldName()});
        }
        methodBuilder.addStatement(".build()", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
    }

    private final LithoModelInfo getModelInfoForProp(Map<TypeElement, LithoModelInfo> modelInfoMap, Element propElement) {
        LithoModelInfo lithoModelInfo;
        Element element = propElement.getEnclosingElement();
        if (element == null) {
            return null;
        }
        Element methodElement = element;
        Element classElement = methodElement.getEnclosingElement();
        if (classElement.getAnnotation(this.layoutSpecAnnotationClass) == null) {
            lithoModelInfo = null;
        } else {
            Map<TypeElement, LithoModelInfo> map = modelInfoMap;
            lithoModelInfo = map.get(classElement);
        }
        return lithoModelInfo;
    }

    public LithoSpecProcessor(@NotNull Elements elementUtils, @NotNull Types typeUtils, @NotNull ErrorLogger errorLogger, @NotNull GeneratedModelWriter modelWriter) {
        Intrinsics.checkParameterIsNotNull((Object)elementUtils, (String)"elementUtils");
        Intrinsics.checkParameterIsNotNull((Object)typeUtils, (String)"typeUtils");
        Intrinsics.checkParameterIsNotNull((Object)errorLogger, (String)"errorLogger");
        Intrinsics.checkParameterIsNotNull((Object)modelWriter, (String)"modelWriter");
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.errorLogger = errorLogger;
        this.modelWriter = modelWriter;
    }

    public static final /* synthetic */ void access$updateGeneratedClassForLithoComponent(LithoSpecProcessor $this, @NotNull LithoModelInfo modelInfo, @NotNull TypeSpec.Builder classBuilder) {
        $this.updateGeneratedClassForLithoComponent(modelInfo, classBuilder);
    }
}

