/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.AttributeInfo;
import com.airbnb.epoxy.BaseModelAttributeInfo;
import com.airbnb.epoxy.BasicGeneratedModelInfo;
import com.airbnb.epoxy.ConfigManager;
import com.airbnb.epoxy.EpoxyAttribute;
import com.airbnb.epoxy.EpoxyModelClass;
import com.airbnb.epoxy.ErrorLogger;
import com.airbnb.epoxy.GeneratedModelInfo;
import com.airbnb.epoxy.GeneratedModelWriter;
import com.airbnb.epoxy.StyleWriterKt;
import com.airbnb.epoxy.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0002J\u001c\u0010\u0018\u001a\u00020\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u001c\u001a\u00020\u00172\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170!2\u0006\u0010\"\u001a\u00020#J\u001c\u0010$\u001a\u00020\u00112\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0019H\u0002J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/airbnb/epoxy/ModelProcessor;", "", "elements", "Ljavax/lang/model/util/Elements;", "types", "Ljavax/lang/model/util/Types;", "configManager", "Lcom/airbnb/epoxy/ConfigManager;", "errorLogger", "Lcom/airbnb/epoxy/ErrorLogger;", "modelWriter", "Lcom/airbnb/epoxy/GeneratedModelWriter;", "(Ljavax/lang/model/util/Elements;Ljavax/lang/model/util/Types;Lcom/airbnb/epoxy/ConfigManager;Lcom/airbnb/epoxy/ErrorLogger;Lcom/airbnb/epoxy/GeneratedModelWriter;)V", "styleableModelsToWrite", "", "Lcom/airbnb/epoxy/BasicGeneratedModelInfo;", "addAttributeToGeneratedClass", "", "attribute", "Ljavax/lang/model/element/Element;", "modelClassMap", "", "Ljavax/lang/model/element/TypeElement;", "Lcom/airbnb/epoxy/GeneratedModelInfo;", "addAttributesFromOtherModules", "", "buildAttributeInfo", "Lcom/airbnb/epoxy/AttributeInfo;", "getOrCreateTargetClass", "classElement", "hasModelsToWrite", "", "processModels", "", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "updateClassesForInheritance", "helperClassMap", "writeModel", "modelInfo", "epoxy-processor"})
public final class ModelProcessor {
    private final List<BasicGeneratedModelInfo> styleableModelsToWrite;
    private final Elements elements;
    private final Types types;
    private final ConfigManager configManager;
    private final ErrorLogger errorLogger;
    private final GeneratedModelWriter modelWriter;

    public final boolean hasModelsToWrite() {
        Collection collection = this.styleableModelsToWrite;
        return !collection.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<GeneratedModelInfo> processModels(@NotNull RoundEnvironment roundEnv) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)roundEnv, (String)"roundEnv");
        LinkedHashMap modelClassMap = new LinkedHashMap();
        for (Element element : roundEnv.getElementsAnnotatedWith(EpoxyAttribute.class)) {
            try {
                Element element2 = element;
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"attribute");
                this.addAttributeToGeneratedClass(element2, modelClassMap);
            }
            catch (Exception e) {
                ErrorLogger.logError$default(this.errorLogger, e, null, 2, null);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(EpoxyModelClass.class)) {
            try {
                Element element3 = element;
                if (element3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                }
                this.getOrCreateTargetClass(modelClassMap, (TypeElement)element3);
            }
            catch (Exception e) {
                ErrorLogger.logError$default(this.errorLogger, e, null, 2, null);
            }
        }
        try {
            this.addAttributesFromOtherModules(modelClassMap);
        }
        catch (Exception exception) {
            ErrorLogger.logError$default(this.errorLogger, exception, null, 2, null);
        }
        try {
            this.updateClassesForInheritance(modelClassMap);
        }
        catch (Exception exception) {
            ErrorLogger.logError$default(this.errorLogger, exception, null, 2, null);
        }
        Map e = modelClassMap;
        for (Map.Entry entry : e.entrySet()) {
            Map.Entry entry2 = entry;
            GeneratedModelInfo modelInfo = (GeneratedModelInfo)entry2.getValue();
            if (modelInfo instanceof BasicGeneratedModelInfo) {
                TypeElement typeElement = modelInfo.superClassElement;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeElement, (String)"modelInfo.superClassElement");
                Element $receiver$iv = typeElement;
                EpoxyModelClass epoxyModelClass = $receiver$iv.getAnnotation(EpoxyModelClass.class);
                if (epoxyModelClass != null) {
                    if (epoxyModelClass.layout() == 0) {
                        TypeElement typeElement2 = ((BasicGeneratedModelInfo)modelInfo).getBoundObjectTypeElement();
                        if (typeElement2 != null) {
                            if (StyleWriterKt.hasStyleableAnnotation(typeElement2, this.elements)) {
                                this.styleableModelsToWrite.add((BasicGeneratedModelInfo)modelInfo);
                                continue;
                            }
                        }
                    }
                }
            }
            this.writeModel(modelInfo);
        }
        Iterable iterable = this.styleableModelsToWrite;
        Iterator iterator = iterable;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            BasicGeneratedModelInfo it = (BasicGeneratedModelInfo)element$iv$iv;
            if (!StyleWriterKt.tryAddStyleBuilderAttribute(it, this.elements, this.types)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        for (Object element$iv : iterable2) {
            BasicGeneratedModelInfo it = (BasicGeneratedModelInfo)element$iv;
            this.writeModel(it);
            this.styleableModelsToWrite.remove(it);
        }
        Collection<GeneratedModelInfo> collection = modelClassMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"modelClassMap.values");
        return collection;
    }

    private final void writeModel(GeneratedModelInfo modelInfo) {
        try {
            GeneratedModelWriter.generateClassForModel$default(this.modelWriter, modelInfo, null, 2, null);
        }
        catch (Exception e) {
            this.errorLogger.logError(e, "Error generating model classes");
        }
    }

    private final void addAttributeToGeneratedClass(Element attribute, Map<TypeElement, GeneratedModelInfo> modelClassMap) {
        Element element = attribute.getEnclosingElement();
        if (element == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
        }
        TypeElement classElement = (TypeElement)element;
        GeneratedModelInfo helperClass = this.getOrCreateTargetClass(modelClassMap, classElement);
        helperClass.addAttribute(this.buildAttributeInfo(attribute));
    }

    private final AttributeInfo buildAttributeInfo(Element attribute) {
        Utils.validateFieldAccessibleViaGeneratedCode(attribute, EpoxyAttribute.class, this.errorLogger, true);
        return new BaseModelAttributeInfo(attribute, this.types, this.elements, this.errorLogger);
    }

    private final GeneratedModelInfo getOrCreateTargetClass(Map<TypeElement, GeneratedModelInfo> modelClassMap, TypeElement classElement) {
        GeneratedModelInfo generatedModelInfo = modelClassMap.get(classElement);
        boolean isFinal = classElement.getModifiers().contains((Object)Modifier.FINAL);
        if (isFinal) {
            Object[] objectArray = new Object[2];
            String string = EpoxyAttribute.class.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EpoxyAttribute::class.java.simpleName");
            objectArray[0] = string;
            Name name = classElement.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"classElement.simpleName");
            objectArray[1] = name;
            this.errorLogger.logError("Class with %s annotations cannot be final: %s", objectArray);
        }
        NestingKind nestingKind = classElement.getNestingKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)nestingKind), (String)"classElement.nestingKind");
        if (nestingKind.isNested() && !classElement.getModifiers().contains((Object)Modifier.STATIC)) {
            Object[] objectArray = new Object[1];
            Name name = classElement.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"classElement.simpleName");
            objectArray[0] = name;
            this.errorLogger.logError("Nested model classes must be static. (class: %s)", objectArray);
        }
        if (!Utils.isEpoxyModel(classElement.asType())) {
            Object[] objectArray = new Object[3];
            String string = EpoxyAttribute.class.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EpoxyAttribute::class.java.simpleName");
            objectArray[0] = string;
            objectArray[1] = "com.airbnb.epoxy.EpoxyModel<?>";
            Name name = classElement.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"classElement.simpleName");
            objectArray[2] = name;
            this.errorLogger.logError("Class with %s annotations must extend %s (%s)", objectArray);
        }
        if (this.configManager.requiresAbstractModels(classElement) && !classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            Object[] objectArray = new Object[1];
            Name name = classElement.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"classElement.simpleName");
            objectArray[0] = name;
            this.errorLogger.logError("Epoxy model class must be abstract (%s)", objectArray);
        }
        if (generatedModelInfo == null) {
            generatedModelInfo = new BasicGeneratedModelInfo(this.elements, this.types, classElement, this.errorLogger);
            modelClassMap.put(classElement, generatedModelInfo);
        }
        return generatedModelInfo;
    }

    private final void addAttributesFromOtherModules(Map<TypeElement, ? extends GeneratedModelInfo> modelClassMap) {
        HashSet originalEntries = new HashSet(modelClassMap.entrySet());
        Iterator iterator = originalEntries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            TypeElement currentEpoxyModel = (TypeElement)entry2.getKey();
            entry2 = entry;
            GeneratedModelInfo generatedModelInfo = (GeneratedModelInfo)entry2.getValue();
            TypeMirror superclassType = currentEpoxyModel.getSuperclass();
            while (Utils.isEpoxyModel(superclassType)) {
                Element element = this.types.asElement(superclassType);
                if (element == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                }
                TypeElement superclassEpoxyModel = (TypeElement)element;
                if (!modelClassMap.keySet().contains(superclassEpoxyModel)) {
                    Object it;
                    Iterable $receiver$iv$iv;
                    Iterable $receiver$iv;
                    List<? extends Element> list = superclassEpoxyModel.getEnclosedElements();
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"superclassEpoxyModel.enclosedElements");
                    Iterable iterable = list;
                    Iterator iterator2 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        it = (Element)element$iv$iv;
                        if (!(it.getAnnotation(EpoxyAttribute.class) != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        it = (Element)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        Element element2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"it");
                        AttributeInfo attributeInfo = this.buildAttributeInfo(element2);
                        collection.add(attributeInfo);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        it = (AttributeInfo)element$iv$iv;
                        if (!(!((AttributeInfo)it).isPackagePrivate() || Utils.belongToTheSamePackage(currentEpoxyModel, superclassEpoxyModel, this.elements))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    for (Object element$iv : $receiver$iv) {
                        AttributeInfo it2 = (AttributeInfo)element$iv;
                        generatedModelInfo.addAttribute(it2);
                    }
                }
                superclassType = superclassEpoxyModel.getSuperclass();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateClassesForInheritance(Map<TypeElement, ? extends GeneratedModelInfo> helperClassMap) {
        Map<TypeElement, ? extends GeneratedModelInfo> map = helperClassMap;
        Iterator<Map.Entry<TypeElement, ? extends GeneratedModelInfo>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TypeElement, ? extends GeneratedModelInfo> entry;
            Map.Entry<TypeElement, ? extends GeneratedModelInfo> entry2 = entry = iterator.next();
            TypeElement thisClass = entry2.getKey();
            entry2 = entry;
            GeneratedModelInfo value = entry2.getValue();
            LinkedHashMap<TypeElement, ? extends GeneratedModelInfo> otherClasses = new LinkedHashMap<TypeElement, GeneratedModelInfo>(helperClassMap);
            otherClasses.remove(thisClass);
            Map map2 = otherClasses;
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Map.Entry entry3;
                Map.Entry entry4 = entry3 = iterator2.next();
                TypeElement otherClass = (TypeElement)entry4.getKey();
                entry4 = entry3;
                GeneratedModelInfo value1 = (GeneratedModelInfo)entry4.getValue();
                if (!Utils.isSubtype(thisClass, otherClass, this.types)) continue;
                List<AttributeInfo> otherAttributes = value1.getAttributeInfo();
                if (Utils.belongToTheSamePackage(thisClass, otherClass, this.elements)) {
                    value.addAttributes((Collection<AttributeInfo>)otherAttributes);
                    continue;
                }
                List<AttributeInfo> list = otherAttributes;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"otherAttributes");
                Iterable iterable = list;
                Iterator iterator3 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    AttributeInfo it = (AttributeInfo)element$iv$iv;
                    if (it.isPackagePrivate()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (Object element$iv : $receiver$iv) {
                    AttributeInfo it = (AttributeInfo)element$iv;
                    value.addAttribute(it);
                }
            }
        }
    }

    public ModelProcessor(@NotNull Elements elements, @NotNull Types types, @NotNull ConfigManager configManager, @NotNull ErrorLogger errorLogger, @NotNull GeneratedModelWriter modelWriter) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)configManager, (String)"configManager");
        Intrinsics.checkParameterIsNotNull((Object)errorLogger, (String)"errorLogger");
        Intrinsics.checkParameterIsNotNull((Object)modelWriter, (String)"modelWriter");
        this.elements = elements;
        this.types = types;
        this.configManager = configManager;
        this.errorLogger = errorLogger;
        this.modelWriter = modelWriter;
        ModelProcessor modelProcessor = this;
        modelProcessor.styleableModelsToWrite = list = (List)new ArrayList();
    }
}

