/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.AttributeInfo;
import com.airbnb.epoxy.ConfigManager;
import com.airbnb.epoxy.EpoxyProcessorException;
import com.airbnb.epoxy.ErrorLogger;
import com.airbnb.epoxy.GeneratedModelInfo;
import com.airbnb.epoxy.GeneratedModelWriter;
import com.airbnb.epoxy.ModelViewInfo;
import com.airbnb.epoxy.ModelViewWriter;
import com.airbnb.epoxy.ViewAttributeInfo;
import com.airbnb.epoxy.ViewAttributeType;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000u\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000*\u00010\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020!H\u0002J \u0010$\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020!H\u0002J\"\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\u0015\u0010/\u001a\u0002002\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u00101J\u0018\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020)2\u0006\u0010'\u001a\u00020!H\u0002J\u0014\u00104\u001a\u00020\u00162\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001a06R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00067"}, d2={"Lcom/airbnb/epoxy/ModelViewWriter;", "", "modelWriter", "Lcom/airbnb/epoxy/GeneratedModelWriter;", "errorLogger", "Lcom/airbnb/epoxy/ErrorLogger;", "types", "Ljavax/lang/model/util/Types;", "elements", "Ljavax/lang/model/util/Elements;", "configManager", "Lcom/airbnb/epoxy/ConfigManager;", "(Lcom/airbnb/epoxy/GeneratedModelWriter;Lcom/airbnb/epoxy/ErrorLogger;Ljavax/lang/model/util/Types;Ljavax/lang/model/util/Elements;Lcom/airbnb/epoxy/ConfigManager;)V", "getConfigManager", "()Lcom/airbnb/epoxy/ConfigManager;", "getElements", "()Ljavax/lang/model/util/Elements;", "getErrorLogger", "()Lcom/airbnb/epoxy/ErrorLogger;", "getTypes", "()Ljavax/lang/model/util/Types;", "addAfterPropsAddedMethodsToBuilder", "", "methodBuilder", "Lcom/squareup/javapoet/MethodSpec$Builder;", "modelInfo", "Lcom/airbnb/epoxy/ModelViewInfo;", "boundObjectParam", "Lcom/squareup/javapoet/ParameterSpec;", "addResetMethodsToBuilder", "builder", "modelViewInfo", "unbindParamName", "", "addVisibilityChangedMethodsToBuilder", "visibilityParamName", "addVisibilityStateChangedMethodsToBuilder", "buildCodeBlockToSetAttribute", "Lcom/squareup/javapoet/CodeBlock;", "objectName", "attr", "Lcom/airbnb/epoxy/ViewAttributeInfo;", "setToNull", "", "buildFullSpanSizeMethod", "Lcom/squareup/javapoet/MethodSpec;", "buildSaveStateMethod", "generateBuilderHook", "com/airbnb/epoxy/ModelViewWriter$generateBuilderHook$1", "(Lcom/airbnb/epoxy/ModelViewInfo;)Lcom/airbnb/epoxy/ModelViewWriter$generateBuilderHook$1;", "getValueToSetOnView", "viewAttribute", "writeModels", "models", "", "epoxy-processor"})
public final class ModelViewWriter {
    private final GeneratedModelWriter modelWriter;
    @NotNull
    private final ErrorLogger errorLogger;
    @NotNull
    private final Types types;
    @NotNull
    private final Elements elements;
    @NotNull
    private final ConfigManager configManager;

    public final void writeModels(@NotNull List<ModelViewInfo> models) {
        Intrinsics.checkParameterIsNotNull(models, (String)"models");
        for (ModelViewInfo modelInfo : models) {
            try {
                this.modelWriter.generateClassForModel(modelInfo, this.generateBuilderHook(modelInfo));
            }
            catch (Exception e) {
                ErrorLogger.logError$default(this.errorLogger, new EpoxyProcessorException(e, "Error generating model view classes"), null, 2, null);
            }
        }
    }

    private final generateBuilderHook.1 generateBuilderHook(ModelViewInfo modelInfo) {
        return new GeneratedModelWriter.BuilderHooks(this, modelInfo){
            final /* synthetic */ ModelViewWriter this$0;
            final /* synthetic */ ModelViewInfo $modelInfo;

            /*
             * WARNING - void declaration
             */
            public void addToBindMethod(@NotNull MethodSpec.Builder methodBuilder, @NotNull ParameterSpec boundObjectParam) {
                Intrinsics.checkParameterIsNotNull((Object)methodBuilder, (String)"methodBuilder");
                Intrinsics.checkParameterIsNotNull((Object)boundObjectParam, (String)"boundObjectParam");
                for (GeneratedModelInfo.AttributeGroup attributeGroup : this.$modelInfo.attributeGroups) {
                    int attrCount = attributeGroup.attributes.size();
                    if (attrCount == 1) {
                        AttributeInfo attributeInfo = attributeGroup.attributes.get(0);
                        if (attributeInfo == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.airbnb.epoxy.ViewAttributeInfo");
                        }
                        ViewAttributeInfo viewAttribute = (ViewAttributeInfo)attributeInfo;
                        String string = boundObjectParam.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"boundObjectParam.name");
                        methodBuilder.addCode(ModelViewWriter.buildCodeBlockToSetAttribute$default(this.this$0, string, viewAttribute, false, 4, null));
                        continue;
                    }
                    int viewAttribute = 0;
                    int n = attrCount;
                    while (viewAttribute < n) {
                        void i;
                        AttributeInfo attributeInfo = attributeGroup.attributes.get((int)i);
                        if (attributeInfo == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.airbnb.epoxy.ViewAttributeInfo");
                        }
                        ViewAttributeInfo viewAttribute2 = (ViewAttributeInfo)attributeInfo;
                        if (i == false) {
                            methodBuilder.beginControlFlow("if ($L)", new Object[]{GeneratedModelWriter.Companion.isAttributeSetCode(this.$modelInfo, viewAttribute2)});
                        } else if (i == attrCount - 1 && attributeGroup.isRequired) {
                            methodBuilder.beginControlFlow("else", new Object[0]);
                        } else {
                            methodBuilder.beginControlFlow("else if ($L)", new Object[]{GeneratedModelWriter.Companion.isAttributeSetCode(this.$modelInfo, viewAttribute2)});
                        }
                        String string = boundObjectParam.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"boundObjectParam.name");
                        methodBuilder.addCode(ModelViewWriter.buildCodeBlockToSetAttribute$default(this.this$0, string, viewAttribute2, false, 4, null)).endControlFlow();
                        ++i;
                    }
                    if (attributeGroup.isRequired) continue;
                    AttributeInfo attributeInfo = attributeGroup.defaultAttribute;
                    if (attributeInfo == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.airbnb.epoxy.ViewAttributeInfo");
                    }
                    ViewAttributeInfo defaultAttribute = (ViewAttributeInfo)attributeInfo;
                    MethodSpec.Builder builder = methodBuilder.beginControlFlow("else", new Object[0]);
                    String string = boundObjectParam.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"boundObjectParam.name");
                    builder.addCode(ModelViewWriter.buildCodeBlockToSetAttribute$default(this.this$0, string, defaultAttribute, false, 4, null)).endControlFlow();
                }
            }

            /*
             * WARNING - void declaration
             */
            public void addToBindWithDiffMethod(@NotNull MethodSpec.Builder methodBuilder, @NotNull ParameterSpec boundObjectParam, @NotNull ParameterSpec previousModelParam) {
                Intrinsics.checkParameterIsNotNull((Object)methodBuilder, (String)"methodBuilder");
                Intrinsics.checkParameterIsNotNull((Object)boundObjectParam, (String)"boundObjectParam");
                Intrinsics.checkParameterIsNotNull((Object)previousModelParam, (String)"previousModelParam");
                for (GeneratedModelInfo.AttributeGroup attributeGroup : this.$modelInfo.attributeGroups) {
                    CodeBlock[] codeBlockArray;
                    Object object;
                    Collection collection;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Object $receiver;
                    Object $receiver2;
                    List<AttributeInfo> attributes = attributeGroup.attributes;
                    methodBuilder.addCode("\n", new Object[0]);
                    if (attributes.size() == 1) {
                        List<AttributeInfo> list = attributes;
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"attributes");
                        AttributeInfo attribute = (AttributeInfo)CollectionsKt.first(list);
                        MethodSpec.Builder builder = methodBuilder;
                        $receiver2 = builder;
                        AttributeInfo attributeInfo = attribute;
                        Intrinsics.checkExpressionValueIsNotNull((Object)attributeInfo, (String)"attribute");
                        GeneratedModelWriter.Companion.startNotEqualsControlFlow((MethodSpec.Builder)$receiver2, attributeInfo);
                        String string = boundObjectParam.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"boundObjectParam.name");
                        $receiver2.addCode(ModelViewWriter.buildCodeBlockToSetAttribute$default(this.this$0, string, (ViewAttributeInfo)attribute, false, 4, null));
                        $receiver2.endControlFlow();
                        continue;
                    }
                    boolean attribute = false;
                    List<AttributeInfo> list = attributes;
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"attributes");
                    $receiver2 = ((Iterable)list).iterator();
                    while ($receiver2.hasNext()) {
                        void index;
                        AttributeInfo attribute2 = (AttributeInfo)$receiver2.next();
                        GeneratedModelInfo generatedModelInfo = this.$modelInfo;
                        AttributeInfo attributeInfo = attribute2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)attributeInfo, (String)"attribute");
                        CodeBlock isAttributeSetCode = GeneratedModelWriter.Companion.isAttributeSetCode(generatedModelInfo, attributeInfo);
                        MethodSpec.Builder builder = methodBuilder;
                        $receiver = builder;
                        $receiver.beginControlFlow((index != false ? "else " : "") + "if ($L)", new Object[]{isAttributeSetCode});
                        if (attribute2.isPrimitive()) {
                            GeneratedModelWriter.Companion.startNotEqualsControlFlow((MethodSpec.Builder)$receiver, attribute2);
                        } else {
                            $receiver.beginControlFlow("if (!that.$L || $L)", new Object[]{isAttributeSetCode, GeneratedModelWriter.Companion.notEqualsCodeBlock(attribute2)});
                        }
                        String string = boundObjectParam.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"boundObjectParam.name");
                        $receiver.addCode(ModelViewWriter.buildCodeBlockToSetAttribute$default(this.this$0, string, (ViewAttributeInfo)attribute2, false, 4, null));
                        $receiver.endControlFlow();
                        $receiver.endControlFlow();
                        ++index;
                    }
                    if (attributeGroup.isRequired) continue;
                    AttributeInfo attributeInfo = attributeGroup.defaultAttribute;
                    if (attributeInfo == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.airbnb.epoxy.ViewAttributeInfo");
                    }
                    ViewAttributeInfo defaultAttribute = (ViewAttributeInfo)attributeInfo;
                    Object $receiver3 = $receiver2 = new StringBuilder();
                    Iterable $receiver$iv2 = (Iterable)CollectionsKt.getIndices((Collection)attributes);
                    $receiver = $receiver$iv2.iterator();
                    while ($receiver.hasNext()) {
                        int element$iv = ((IntIterator)$receiver).nextInt();
                        int it = element$iv;
                        if (it != 0) {
                            ((StringBuilder)$receiver3).append(" || ");
                        }
                        ((StringBuilder)$receiver3).append("that.$L");
                    }
                    Object ifConditionArgs = $receiver2;
                    $receiver$iv2 = $receiver$iv = (Iterable)attributes;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        AttributeInfo $i$a$1$forEach = (AttributeInfo)item$iv$iv;
                        collection = destination$iv$iv;
                        GeneratedModelInfo generatedModelInfo = this.$modelInfo;
                        void v9 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
                        object = GeneratedModelWriter.Companion.isAttributeSetCode(generatedModelInfo, (AttributeInfo)v9);
                        collection.add(object);
                    }
                    List ifConditionValues = (List)destination$iv$iv;
                    $receiver$iv = ifConditionValues;
                    object = "else if (" + ifConditionArgs + ')';
                    collection = methodBuilder.addComment("A value was not set so we should use the default value, but we only need to set it if the previous model had a custom value set.", new Object[0]);
                    Iterable thisCollection$iv = $receiver$iv;
                    if (thisCollection$iv.toArray(new CodeBlock[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    MethodSpec.Builder builder = collection.beginControlFlow((String)object, Arrays.copyOf(codeBlockArray, codeBlockArray.length));
                    String string = boundObjectParam.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"boundObjectParam.name");
                    builder.addCode(ModelViewWriter.buildCodeBlockToSetAttribute$default(this.this$0, string, defaultAttribute, false, 4, null)).endControlFlow();
                }
            }

            public void addToHandlePostBindMethod(@NotNull MethodSpec.Builder postBindBuilder, @NotNull ParameterSpec boundObjectParam) {
                Intrinsics.checkParameterIsNotNull((Object)postBindBuilder, (String)"postBindBuilder");
                Intrinsics.checkParameterIsNotNull((Object)boundObjectParam, (String)"boundObjectParam");
                ModelViewWriter.access$addAfterPropsAddedMethodsToBuilder(this.this$0, postBindBuilder, this.$modelInfo, boundObjectParam);
            }

            /*
             * WARNING - void declaration
             */
            public void addToUnbindMethod(@NotNull MethodSpec.Builder unbindBuilder, @NotNull String unbindParamName) {
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)unbindBuilder, (String)"unbindBuilder");
                Intrinsics.checkParameterIsNotNull((Object)unbindParamName, (String)"unbindParamName");
                Iterable $receiver$iv = this.$modelInfo.getViewAttributes();
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    ViewAttributeInfo it = (ViewAttributeInfo)element$iv$iv;
                    if (!it.getResetWithNull()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (E element$iv : $receiver$iv) {
                    ViewAttributeInfo it = (ViewAttributeInfo)element$iv;
                    unbindBuilder.addCode(ModelViewWriter.access$buildCodeBlockToSetAttribute(this.this$0, unbindParamName, it, true));
                }
                ModelViewWriter.access$addResetMethodsToBuilder(this.this$0, unbindBuilder, this.$modelInfo, unbindParamName);
            }

            public void addToVisibilityStateChangedMethod(@NotNull MethodSpec.Builder visibilityBuilder, @NotNull String visibilityParamName) {
                Intrinsics.checkParameterIsNotNull((Object)visibilityBuilder, (String)"visibilityBuilder");
                Intrinsics.checkParameterIsNotNull((Object)visibilityParamName, (String)"visibilityParamName");
                ModelViewWriter.access$addVisibilityStateChangedMethodsToBuilder(this.this$0, visibilityBuilder, this.$modelInfo, visibilityParamName);
            }

            public void addToVisibilityChangedMethod(@NotNull MethodSpec.Builder visibilityBuilder, @NotNull String visibilityParamName) {
                Intrinsics.checkParameterIsNotNull((Object)visibilityBuilder, (String)"visibilityBuilder");
                Intrinsics.checkParameterIsNotNull((Object)visibilityParamName, (String)"visibilityParamName");
                ModelViewWriter.access$addVisibilityChangedMethodsToBuilder(this.this$0, visibilityBuilder, this.$modelInfo, visibilityParamName);
            }

            public void beforeFinalBuild(@NotNull TypeSpec.Builder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                if (this.$modelInfo.getSaveViewState()) {
                    builder.addMethod(ModelViewWriter.access$buildSaveStateMethod(this.this$0));
                }
                if (this.$modelInfo.getFullSpanSize()) {
                    builder.addMethod(ModelViewWriter.access$buildFullSpanSizeMethod(this.this$0));
                }
            }
            {
                this.this$0 = $outer;
                this.$modelInfo = $captured_local_variable$1;
            }
        };
    }

    private final CodeBlock buildCodeBlockToSetAttribute(String objectName, ViewAttributeInfo attr, boolean setToNull) {
        String expression = "$L.$L" + (Intrinsics.areEqual((Object)attr.getViewAttributeTypeName(), (Object)ViewAttributeType.Field.INSTANCE) ? (setToNull ? " = ($T) null" : " = $L") : (setToNull ? "(($T) null)" : "($L)"));
        CodeBlock codeBlock = CodeBlock.builder().addStatement(expression, new Object[]{objectName, attr.getViewAttributeName(), setToNull ? attr.getTypeMirror() : this.getValueToSetOnView(attr, objectName)}).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeBlock, (String)"CodeBlock.builder().addS\u2026ctName)\n        ).build()");
        return codeBlock;
    }

    static /* bridge */ /* synthetic */ CodeBlock buildCodeBlockToSetAttribute$default(ModelViewWriter modelViewWriter, String string, ViewAttributeInfo viewAttributeInfo, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return modelViewWriter.buildCodeBlockToSetAttribute(string, viewAttributeInfo, bl);
    }

    private final String getValueToSetOnView(ViewAttributeInfo viewAttribute, String objectName) {
        String fieldName = viewAttribute.getFieldName();
        return viewAttribute.getGenerateStringOverloads() ? fieldName + ".toString(" + objectName + ".getContext())" : fieldName;
    }

    private final MethodSpec buildSaveStateMethod() {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"shouldSaveViewState").addAnnotation(Override.class).returns(TypeName.BOOLEAN).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return true", new Object[0]).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026\n                .build()");
        return methodSpec;
    }

    private final MethodSpec buildFullSpanSizeMethod() {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"getSpanSize").addAnnotation(Override.class).returns(TypeName.INT).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.INT, "totalSpanCount", new Modifier[0]).addParameter(TypeName.INT, "position", new Modifier[0]).addParameter(TypeName.INT, "itemCount", new Modifier[0]).addStatement("return totalSpanCount", new Object[0]).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026\n                .build()");
        return methodSpec;
    }

    private final void addResetMethodsToBuilder(MethodSpec.Builder builder, ModelViewInfo modelViewInfo, String unbindParamName) {
        for (String methodName : modelViewInfo.getResetMethodNames()) {
            builder.addStatement(unbindParamName + '.' + methodName + "()", new Object[0]);
        }
    }

    private final void addVisibilityStateChangedMethodsToBuilder(MethodSpec.Builder builder, ModelViewInfo modelViewInfo, String visibilityParamName) {
        for (String methodName : modelViewInfo.getVisibilityStateChangedMethodNames()) {
            builder.addStatement(visibilityParamName + '.' + methodName + "(visibilityState)", new Object[0]);
        }
    }

    private final void addVisibilityChangedMethodsToBuilder(MethodSpec.Builder builder, ModelViewInfo modelViewInfo, String visibilityParamName) {
        for (String methodName : modelViewInfo.getVisibilityChangedMethodNames()) {
            builder.addStatement(visibilityParamName + '.' + methodName + "(percentVisibleHeight, percentVisibleWidth, visibleHeight, visibleWidth)", new Object[0]);
        }
    }

    private final void addAfterPropsAddedMethodsToBuilder(MethodSpec.Builder methodBuilder, ModelViewInfo modelInfo, ParameterSpec boundObjectParam) {
        for (String methodName : modelInfo.getAfterPropsSetMethodNames()) {
            methodBuilder.addStatement(boundObjectParam.name + "." + methodName + "()", new Object[0]);
        }
    }

    @NotNull
    public final ErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    @NotNull
    public final Types getTypes() {
        return this.types;
    }

    @NotNull
    public final Elements getElements() {
        return this.elements;
    }

    @NotNull
    public final ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ModelViewWriter(@NotNull GeneratedModelWriter modelWriter, @NotNull ErrorLogger errorLogger, @NotNull Types types, @NotNull Elements elements, @NotNull ConfigManager configManager) {
        Intrinsics.checkParameterIsNotNull((Object)modelWriter, (String)"modelWriter");
        Intrinsics.checkParameterIsNotNull((Object)errorLogger, (String)"errorLogger");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull((Object)configManager, (String)"configManager");
        this.modelWriter = modelWriter;
        this.errorLogger = errorLogger;
        this.types = types;
        this.elements = elements;
        this.configManager = configManager;
    }

    public static final /* synthetic */ void access$addAfterPropsAddedMethodsToBuilder(ModelViewWriter $this, @NotNull MethodSpec.Builder methodBuilder, @NotNull ModelViewInfo modelInfo, @NotNull ParameterSpec boundObjectParam) {
        $this.addAfterPropsAddedMethodsToBuilder(methodBuilder, modelInfo, boundObjectParam);
    }

    @NotNull
    public static final /* synthetic */ CodeBlock access$buildCodeBlockToSetAttribute(ModelViewWriter $this, @NotNull String objectName, @NotNull ViewAttributeInfo attr, boolean setToNull) {
        return $this.buildCodeBlockToSetAttribute(objectName, attr, setToNull);
    }

    public static final /* synthetic */ void access$addResetMethodsToBuilder(ModelViewWriter $this, @NotNull MethodSpec.Builder builder, @NotNull ModelViewInfo modelViewInfo, @NotNull String unbindParamName) {
        $this.addResetMethodsToBuilder(builder, modelViewInfo, unbindParamName);
    }

    public static final /* synthetic */ void access$addVisibilityStateChangedMethodsToBuilder(ModelViewWriter $this, @NotNull MethodSpec.Builder builder, @NotNull ModelViewInfo modelViewInfo, @NotNull String visibilityParamName) {
        $this.addVisibilityStateChangedMethodsToBuilder(builder, modelViewInfo, visibilityParamName);
    }

    public static final /* synthetic */ void access$addVisibilityChangedMethodsToBuilder(ModelViewWriter $this, @NotNull MethodSpec.Builder builder, @NotNull ModelViewInfo modelViewInfo, @NotNull String visibilityParamName) {
        $this.addVisibilityChangedMethodsToBuilder(builder, modelViewInfo, visibilityParamName);
    }

    @NotNull
    public static final /* synthetic */ MethodSpec access$buildSaveStateMethod(ModelViewWriter $this) {
        return $this.buildSaveStateMethod();
    }

    @NotNull
    public static final /* synthetic */ MethodSpec access$buildFullSpanSizeMethod(ModelViewWriter $this) {
        return $this.buildFullSpanSizeMethod();
    }
}

