/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.PackageModelViewConfig;
import com.airbnb.epoxy.ResourceValue;
import com.airbnb.epoxy.Utils;
import com.squareup.javapoet.ClassName;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lcom/airbnb/epoxy/PackageModelViewSettings;", "", "rClassName", "Lcom/squareup/javapoet/ClassName;", "annotation", "Lcom/airbnb/epoxy/PackageModelViewConfig;", "(Lcom/squareup/javapoet/ClassName;Lcom/airbnb/epoxy/PackageModelViewConfig;)V", "defaultBaseModel", "Ljavax/lang/model/type/TypeMirror;", "getDefaultBaseModel", "()Ljavax/lang/model/type/TypeMirror;", "generatedModelSuffix", "", "getGeneratedModelSuffix", "()Ljava/lang/String;", "includeAlternateLayouts", "", "getIncludeAlternateLayouts", "()Z", "layoutName", "getLayoutName", "rClass", "getRClass", "()Lcom/squareup/javapoet/ClassName;", "getNameForView", "Lcom/airbnb/epoxy/ResourceValue;", "viewElement", "Ljavax/lang/model/element/TypeElement;", "epoxy-processor"})
public final class PackageModelViewSettings {
    @NotNull
    private final ClassName rClass;
    @NotNull
    private final String layoutName;
    @Nullable
    private final TypeMirror defaultBaseModel;
    private final boolean includeAlternateLayouts;
    @NotNull
    private final String generatedModelSuffix;

    @NotNull
    public final ClassName getRClass() {
        return this.rClass;
    }

    @NotNull
    public final String getLayoutName() {
        return this.layoutName;
    }

    @Nullable
    public final TypeMirror getDefaultBaseModel() {
        return this.defaultBaseModel;
    }

    public final boolean getIncludeAlternateLayouts() {
        return this.includeAlternateLayouts;
    }

    @NotNull
    public final String getGeneratedModelSuffix() {
        return this.generatedModelSuffix;
    }

    private final TypeMirror getDefaultBaseModel(PackageModelViewConfig annotation) {
        TypeMirror defaultBaseModel = null;
        try {
            annotation.defaultBaseModelClass();
        }
        catch (MirroredTypeException mte) {
            defaultBaseModel = mte.getTypeMirror();
        }
        if (defaultBaseModel != null && Intrinsics.areEqual((Object)((Object)defaultBaseModel).toString(), (Object)Void.class.getCanonicalName())) {
            defaultBaseModel = null;
        }
        return defaultBaseModel;
    }

    @NotNull
    public final ResourceValue getNameForView(@NotNull TypeElement viewElement) {
        String viewName;
        Intrinsics.checkParameterIsNotNull((Object)viewElement, (String)"viewElement");
        String string = viewName = Utils.toSnakeCase(viewElement.getSimpleName().toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"viewName");
        String resourceName = StringsKt.replace$default((String)this.layoutName, (String)"%s", (String)string, (boolean)false, (int)4, null);
        return new ResourceValue(this.rClass, resourceName, 0);
    }

    public PackageModelViewSettings(@NotNull ClassName rClassName, @NotNull PackageModelViewConfig annotation) {
        Intrinsics.checkParameterIsNotNull((Object)rClassName, (String)"rClassName");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        ClassName className = ClassName.get((String)rClassName.packageName(), (String)"R", (String[])new String[]{"layout"});
        Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"ClassName.get(rClassName\u2026ageName(), \"R\", \"layout\")");
        this.rClass = className;
        this.layoutName = annotation.defaultLayoutPattern();
        this.defaultBaseModel = this.getDefaultBaseModel(annotation);
        this.includeAlternateLayouts = annotation.useLayoutOverloads();
        this.generatedModelSuffix = annotation.generatedModelSuffix();
    }
}

