/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.EpoxyDataBindingLayouts;
import com.airbnb.epoxy.EpoxyModelClass;
import com.airbnb.epoxy.ErrorLogger;
import com.airbnb.epoxy.ModelView;
import com.airbnb.epoxy.ResourceValue;
import com.airbnb.epoxy.Utils;
import com.squareup.javapoet.ClassName;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class ResourceProcessor {
    private final ErrorLogger errorLogger;
    private final Elements elementUtils;
    private final Types typeUtils;
    private Trees trees;
    private final Map<String, ClassName> rClassNameMap = new HashMap<String, ClassName>();
    private final Map<ClassName, List<ResourceValue>> rClassResources = new HashMap<ClassName, List<ResourceValue>>();
    private final AnnotationResourceParamScanner scanner = new AnnotationResourceParamScanner();

    ResourceProcessor(ProcessingEnvironment processingEnv, ErrorLogger errorLogger, Elements elementUtils, Types typeUtils) {
        this.errorLogger = errorLogger;
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        try {
            this.trees = Trees.instance(processingEnv);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    ResourceValue getLayoutInAnnotation(Element element, Class annotationClass) {
        List<ResourceValue> layouts = this.getLayoutsInAnnotation(element, annotationClass);
        if (layouts.size() != 1) {
            this.errorLogger.logError("Expected exactly 1 layout resource in the %s annotation but received %s. Annotated element is %s", annotationClass.getSimpleName(), layouts.size(), element.getSimpleName());
            if (layouts.isEmpty()) {
                return new ResourceValue(0);
            }
        }
        return layouts.get(0);
    }

    List<ResourceValue> getLayoutsInAnnotation(Element element, Class annotationClass) {
        List<Integer> layoutValues = ResourceProcessor.getLayoutValues(element, annotationClass);
        return this.getResourcesInAnnotation(element, annotationClass, "layout", layoutValues);
    }

    ResourceValue getStringResourceInAnnotation(Element element, Class annotationClass, int resourceValue) {
        return this.getResourceInAnnotation(element, annotationClass, "string", resourceValue);
    }

    ResourceValue getResourceInAnnotation(Element element, Class annotationClass, String resourceType, int resourceValue) {
        List<ResourceValue> layouts = this.getResourcesInAnnotation(element, annotationClass, resourceType, Collections.singletonList(resourceValue));
        if (layouts.size() != 1) {
            this.errorLogger.logError("Expected exactly 1 %s resource in the %s annotation but received %s. Annotated element is %s", resourceType, annotationClass.getSimpleName(), layouts.size(), element.getSimpleName());
            if (layouts.isEmpty()) {
                return new ResourceValue(0);
            }
        }
        return layouts.get(0);
    }

    List<ResourceValue> getResourcesInAnnotation(Element element, Class annotationClass, String resourceType, List<Integer> resourceValues) {
        ArrayList<ResourceValue> resources = new ArrayList<ResourceValue>(resourceValues.size());
        JCTree tree = (JCTree)this.trees.getTree(element, this.getAnnotationMirror(element, annotationClass));
        if (tree != null) {
            this.scanner.clearResults();
            this.scanner.setCurrentAnnotationDetails(element, annotationClass, resourceType);
            tree.accept(this.scanner);
            resources.addAll(this.scanner.getResults());
        }
        if (resources.size() != resourceValues.size()) {
            for (int layoutValue : resourceValues) {
                if (this.isLayoutValueInResources(resources, layoutValue)) continue;
                resources.add(new ResourceValue(layoutValue));
            }
        }
        return resources;
    }

    private boolean isLayoutValueInResources(List<ResourceValue> resources, int layoutValue) {
        for (ResourceValue resource : resources) {
            if (resource.getValue() != layoutValue) continue;
            return true;
        }
        return false;
    }

    private static List<Integer> getLayoutValues(Element element, Class annotationClass) {
        Object annotation = element.getAnnotation(annotationClass);
        ArrayList<Integer> layoutResources = new ArrayList<Integer>();
        if (annotation instanceof EpoxyModelClass) {
            layoutResources.add(((EpoxyModelClass)annotation).layout());
        } else if (annotation instanceof EpoxyDataBindingLayouts) {
            for (int layoutRes : ((EpoxyDataBindingLayouts)annotation).value()) {
                layoutResources.add(layoutRes);
            }
        } else if (annotation instanceof ModelView) {
            layoutResources.add(((ModelView)annotation).defaultLayout());
        }
        return layoutResources;
    }

    private AnnotationMirror getAnnotationMirror(Element element, Class annotationClass) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationClass.getCanonicalName())) continue;
            return annotationMirror;
        }
        this.errorLogger.logError("Unable to get %s annotation on model %", annotationClass.getSimpleName(), element.getSimpleName());
        return null;
    }

    List<ClassName> getRClassNames() {
        return new ArrayList<ClassName>(this.rClassNameMap.values());
    }

    List<ResourceValue> getAlternateLayouts(ResourceValue layout) {
        List<ResourceValue> layouts;
        if (this.rClassResources.isEmpty()) {
            TypeElement rLayoutClassElement = Utils.getElementByName(layout.getClassName(), this.elementUtils, this.typeUtils);
            this.saveResourceValuesForRClass(layout.getClassName(), rLayoutClassElement);
        }
        if ((layouts = this.rClassResources.get(layout.getClassName())) == null) {
            this.errorLogger.logError("No layout files found for R class: %s", layout.getClassName());
            return Collections.emptyList();
        }
        ArrayList<ResourceValue> result = new ArrayList<ResourceValue>();
        String target = layout.getResourceName() + "_";
        for (ResourceValue otherLayout : layouts) {
            if (!otherLayout.getResourceName().startsWith(target)) continue;
            result.add(otherLayout);
        }
        return result;
    }

    private void saveResourceValuesForRClass(ClassName rClass, Element resourceClass) {
        if (this.rClassResources.containsKey(rClass)) {
            return;
        }
        List<? extends Element> resourceElements = resourceClass.getEnclosedElements();
        ArrayList<ResourceValue> resourceNames = new ArrayList<ResourceValue>(resourceElements.size());
        for (Element element : resourceElements) {
            if (!(element instanceof VariableElement)) continue;
            String resourceName = element.getSimpleName().toString();
            resourceNames.add(new ResourceValue(rClass, resourceName, 0));
        }
        this.rClassResources.put(rClass, resourceNames);
    }

    private ClassName getClassName(String rClass, String resourceType) {
        ClassName className = this.rClassNameMap.get(rClass);
        if (className == null) {
            Element rClassElement = Utils.getElementByName(rClass, this.elementUtils, this.typeUtils);
            String rClassPackageName = this.elementUtils.getPackageOf(rClassElement).getQualifiedName().toString();
            className = ClassName.get((String)rClassPackageName, (String)"R", (String[])new String[]{resourceType});
            this.rClassNameMap.put(rClass, className);
        }
        return className;
    }

    private class AnnotationResourceParamScanner
    extends TreeScanner {
        private final List<ResourceValue> results = new ArrayList<ResourceValue>();
        private Element element;
        private Class annotationClass;
        private String resourceType;

        private AnnotationResourceParamScanner() {
        }

        void clearResults() {
            this.results.clear();
        }

        List<ResourceValue> getResults() {
            return this.results;
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jcFieldAccess) {
            ResourceValue result;
            Symbol symbol = jcFieldAccess.sym;
            if (symbol instanceof Symbol.VarSymbol && symbol.getEnclosingElement() != null && symbol.getEnclosingElement().getEnclosingElement() != null && symbol.getEnclosingElement().getEnclosingElement().enclClass() != null && (result = this.parseResourceSymbol((VariableElement)((Object)symbol))) != null) {
                this.results.add(result);
            }
        }

        private ResourceValue parseResourceSymbol(VariableElement symbol) {
            TypeElement resourceClass = (TypeElement)symbol.getEnclosingElement();
            String rClass = ((TypeElement)resourceClass.getEnclosingElement()).getQualifiedName().toString();
            String resourceClassName = resourceClass.getQualifiedName().toString();
            if (!(rClass + "." + this.resourceType).equals(resourceClassName)) {
                ResourceProcessor.this.errorLogger.logError("%s annotation requires a %s resource but received %s. (Element: %s)", this.annotationClass.getSimpleName(), this.resourceType, resourceClass, this.element.getSimpleName());
                return null;
            }
            String resourceName = symbol.getSimpleName().toString();
            Object resourceValue = symbol.getConstantValue();
            if (!(resourceValue instanceof Integer)) {
                ResourceProcessor.this.errorLogger.logError("%s annotation requires an int value but received %s. (Element: %s)", this.annotationClass.getSimpleName(), symbol.getSimpleName(), this.element.getSimpleName());
                return null;
            }
            ClassName rClassName = ResourceProcessor.this.getClassName(resourceClassName, this.resourceType);
            ResourceProcessor.this.saveResourceValuesForRClass(rClassName, resourceClass);
            return new ResourceValue(rClassName, resourceName, (Integer)resourceValue);
        }

        void setCurrentAnnotationDetails(Element element, Class annotationClass, String resourceType) {
            this.element = element;
            this.annotationClass = annotationClass;
            this.resourceType = resourceType;
        }
    }
}

