/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.support.annotation.Nullable;
import com.airbnb.epoxy.EpoxyProcessorException;
import com.airbnb.epoxy.ErrorLogger;
import com.airbnb.epoxy.KotlinUtilsKt;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class Utils {
    private static final Pattern PATTERN_STARTS_WITH_SET = Pattern.compile("set[A-Z]\\w*");
    static final String EPOXY_MODEL_TYPE = "com.airbnb.epoxy.EpoxyModel<?>";
    static final String UNTYPED_EPOXY_MODEL_TYPE = "com.airbnb.epoxy.EpoxyModel";
    static final String EPOXY_MODEL_WITH_HOLDER_TYPE = "com.airbnb.epoxy.EpoxyModelWithHolder<?>";
    static final String EPOXY_VIEW_HOLDER_TYPE = "com.airbnb.epoxy.EpoxyViewHolder";
    static final String EPOXY_HOLDER_TYPE = "com.airbnb.epoxy.EpoxyHolder";
    static final String ANDROID_VIEW_TYPE = "android.view.View";
    static final String EPOXY_CONTROLLER_TYPE = "com.airbnb.epoxy.EpoxyController";
    static final String VIEW_CLICK_LISTENER_TYPE = "android.view.View.OnClickListener";
    static final String VIEW_LONG_CLICK_LISTENER_TYPE = "android.view.View.OnLongClickListener";
    static final String DRAWABLE_TYPE = "android.graphics.drawable.Drawable";
    static final String GENERATED_MODEL_INTERFACE = "com.airbnb.epoxy.GeneratedModel";
    static final String MODEL_CLICK_LISTENER_TYPE = "com.airbnb.epoxy.OnModelClickListener";
    static final String MODEL_LONG_CLICK_LISTENER_TYPE = "com.airbnb.epoxy.OnModelLongClickListener";
    static final String ON_BIND_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelBoundListener";
    static final String ON_UNBIND_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelUnboundListener";
    static final String WRAPPED_LISTENER_TYPE = "com.airbnb.epoxy.WrappedEpoxyModelClickListener";
    static final String DATA_BINDING_MODEL_TYPE = "com.airbnb.epoxy.DataBindingEpoxyModel";
    static final String ON_VISIBILITY_STATE_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelVisibilityStateChangedListener";
    static final String ON_VISIBILITY_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelVisibilityChangedListener";

    Utils() {
    }

    static void throwError(String msg, Object ... args) throws EpoxyProcessorException {
        throw new EpoxyProcessorException(String.format(msg, args));
    }

    static Class<?> getClass(ClassName name) {
        try {
            return Class.forName(name.reflectionName());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    static Class<? extends Annotation> getAnnotationClass(ClassName name) {
        try {
            return Utils.getClass(name);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    static TypeElement getElementByName(ClassName name, Elements elements, Types types) {
        String canonicalName = name.reflectionName().replace("$", ".");
        return (TypeElement)Utils.getElementByName(canonicalName, elements, types);
    }

    static Element getElementByName(String name, Elements elements, Types types) {
        try {
            return elements.getTypeElement(name);
        }
        catch (MirroredTypeException mte) {
            return types.asElement(mte.getTypeMirror());
        }
    }

    static ClassName getClassName(String className) {
        return ClassName.bestGuess((String)className);
    }

    static EpoxyProcessorException buildEpoxyException(String msg, Object ... args) {
        return new EpoxyProcessorException(String.format(msg, args));
    }

    static boolean isViewClickListenerType(TypeMirror type) {
        return Utils.isType(type, VIEW_CLICK_LISTENER_TYPE);
    }

    static boolean isViewLongClickListenerType(TypeMirror type) {
        return Utils.isType(type, VIEW_LONG_CLICK_LISTENER_TYPE);
    }

    static boolean isBooleanType(TypeMirror type) {
        return type.getKind() == TypeKind.BOOLEAN || Utils.isType(type, "java.lang.Boolean");
    }

    static boolean isDoubleType(TypeMirror type) {
        return type.getKind() == TypeKind.DOUBLE || Utils.isType(type, "java.lang.Double");
    }

    static boolean isIntType(TypeMirror type) {
        return type.getKind() == TypeKind.INT || Utils.isType(type, "java.lang.Integer");
    }

    static boolean isLongType(TypeMirror type) {
        return type.getKind() == TypeKind.LONG || Utils.isType(type, "java.lang.Long");
    }

    static boolean isStringType(TypeMirror type) {
        return Utils.isType(type, "java.lang.String");
    }

    static boolean isCharSequenceOrStringType(TypeMirror type) {
        return Utils.isType(type, "java.lang.CharSequence") || Utils.isStringType(type);
    }

    static boolean isIterableType(TypeElement element) {
        return Utils.isSubtypeOfType(element.asType(), "java.lang.Iterable<?>");
    }

    static boolean isController(TypeElement element) {
        return Utils.isSubtypeOfType(element.asType(), EPOXY_CONTROLLER_TYPE);
    }

    static boolean isEpoxyModel(TypeMirror type) {
        return Utils.isSubtypeOfType(type, EPOXY_MODEL_TYPE) || Utils.isSubtypeOfType(type, UNTYPED_EPOXY_MODEL_TYPE);
    }

    static boolean isEpoxyModel(TypeElement type) {
        return Utils.isEpoxyModel(type.asType());
    }

    static boolean isEpoxyModelWithHolder(TypeElement type) {
        return Utils.isSubtypeOfType(type.asType(), EPOXY_MODEL_WITH_HOLDER_TYPE);
    }

    static boolean isDataBindingModel(TypeElement type) {
        return Utils.isSubtypeOfType(type.asType(), DATA_BINDING_MODEL_TYPE);
    }

    static boolean isSubtypeOfType(TypeMirror typeMirror, String otherType) {
        Element element;
        if (otherType.equals(typeMirror.toString())) {
            return true;
        }
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() > 0) {
            StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
            typeString.append('<');
            for (int i = 0; i < typeArguments.size(); ++i) {
                if (i > 0) {
                    typeString.append(',');
                }
                typeString.append('?');
            }
            typeString.append('>');
            if (typeString.toString().equals(otherType)) {
                return true;
            }
        }
        if (!((element = declaredType.asElement()) instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superType = typeElement.getSuperclass();
        if (Utils.isSubtypeOfType(superType, otherType)) {
            return true;
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            if (!Utils.isSubtypeOfType(typeMirror2, otherType)) continue;
            return true;
        }
        return false;
    }

    static boolean belongToTheSamePackage(TypeElement class1, TypeElement class2, Elements elements) {
        Name package1 = elements.getPackageOf(class1).getQualifiedName();
        Name package2 = elements.getPackageOf(class2).getQualifiedName();
        return package1.equals(package2);
    }

    static boolean isSubtype(TypeElement e1, TypeElement e2, Types types) {
        return Utils.isSubtype(e1.asType(), e2.asType(), types);
    }

    static boolean isSubtype(TypeMirror e1, TypeMirror e2, Types types) {
        return types.isSubtype(e1, types.erasure(e2));
    }

    static boolean isFieldPackagePrivate(Element element) {
        Set<Modifier> modifiers = element.getModifiers();
        return !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
    }

    static boolean implementsMethod(TypeElement clazz, MethodSpec method, Types typeUtils, Elements elements) {
        ExecutableElement methodOnClass = Utils.getMethodOnClass(clazz, method, typeUtils, elements);
        if (methodOnClass == null) {
            return false;
        }
        Set<Modifier> modifiers = methodOnClass.getModifiers();
        return !modifiers.contains((Object)Modifier.ABSTRACT);
    }

    static ExecutableElement getMethodOnClass(TypeElement clazz, MethodSpec method, Types typeUtils, Elements elements) {
        if (clazz.asType().getKind() != TypeKind.DECLARED) {
            return null;
        }
        for (Element element : clazz.getEnclosedElements()) {
            ExecutableElement methodElement;
            if (element.getKind() != ElementKind.METHOD || !(methodElement = (ExecutableElement)element).getSimpleName().toString().equals(method.name) || !Utils.areParamsTheSame(methodElement, method, typeUtils, elements)) continue;
            return methodElement;
        }
        TypeElement superClazz = KotlinUtilsKt.getParentClassElement(clazz, typeUtils);
        if (superClazz == null) {
            return null;
        }
        return Utils.getMethodOnClass(superClazz, method, typeUtils, elements);
    }

    private static boolean areParamsTheSame(ExecutableElement method1, MethodSpec method2, Types types, Elements elements) {
        List<? extends VariableElement> params1 = method1.getParameters();
        List params2 = method2.parameters;
        if (params1.size() != params2.size()) {
            return false;
        }
        for (int i = 0; i < params1.size(); ++i) {
            VariableElement param1 = params1.get(i);
            ParameterSpec param2 = (ParameterSpec)params2.get(i);
            TypeMirror param1Type = types.erasure(param1.asType());
            TypeMirror param2Type = types.erasure(KotlinUtilsKt.getTypeMirror(param2.type.toString(), elements));
            if (!(param1.asType().getKind() == TypeKind.TYPEVAR ? !types.isAssignable(param2Type, param1Type) : !param1Type.toString().equals(param2Type.toString()))) continue;
            return false;
        }
        return true;
    }

    static TypeMirror getEpoxyObjectType(TypeElement clazz, Types typeUtils) {
        if (clazz.getSuperclass().getKind() != TypeKind.DECLARED) {
            return null;
        }
        DeclaredType superclass = (DeclaredType)clazz.getSuperclass();
        TypeMirror recursiveResult = Utils.getEpoxyObjectType((TypeElement)typeUtils.asElement(superclass), typeUtils);
        if (recursiveResult != null && recursiveResult.getKind() != TypeKind.TYPEVAR) {
            return recursiveResult;
        }
        List<? extends TypeMirror> superTypeArguments = superclass.getTypeArguments();
        if (superTypeArguments.size() == 1) {
            return superTypeArguments.get(0);
        }
        for (TypeMirror typeMirror : superTypeArguments) {
            if (!Utils.isSubtypeOfType(typeMirror, ANDROID_VIEW_TYPE) && !Utils.isSubtypeOfType(typeMirror, EPOXY_HOLDER_TYPE)) continue;
            return typeMirror;
        }
        return null;
    }

    static void validateFieldAccessibleViaGeneratedCode(Element fieldElement, Class<?> annotationClass, ErrorLogger errorLogger, boolean skipPrivateFieldCheck) {
        TypeElement enclosingElement = (TypeElement)fieldElement.getEnclosingElement();
        Set<Modifier> modifiers = fieldElement.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) && !skipPrivateFieldCheck || modifiers.contains((Object)Modifier.STATIC)) {
            errorLogger.logError("%s annotations must not be on private or static fields. (class: %s, field: %s)", annotationClass.getSimpleName(), enclosingElement.getSimpleName(), fieldElement.getSimpleName());
        }
        if (enclosingElement.getNestingKind().isNested() && !enclosingElement.getModifiers().contains((Object)Modifier.STATIC)) {
            errorLogger.logError("Nested classes with %s annotations must be static. (class: %s, field: %s)", annotationClass.getSimpleName(), enclosingElement.getSimpleName(), fieldElement.getSimpleName());
        }
        if (enclosingElement.getKind() != ElementKind.CLASS) {
            errorLogger.logError("%s annotations may only be contained in classes. (class: %s, field: %s)", annotationClass.getSimpleName(), enclosingElement.getSimpleName(), fieldElement.getSimpleName());
        }
        if (enclosingElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            errorLogger.logError("%s annotations may not be contained in private classes. (class: %s, field: %s)", annotationClass.getSimpleName(), enclosingElement.getSimpleName(), fieldElement.getSimpleName());
        }
    }

    static void validateFieldAccessibleViaGeneratedCode(Element fieldElement, Class<?> annotationClass, ErrorLogger errorLogger) {
        Utils.validateFieldAccessibleViaGeneratedCode(fieldElement, annotationClass, errorLogger, false);
    }

    static String capitalizeFirstLetter(String original) {
        if (original == null || original.isEmpty()) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1);
    }

    static String decapitalizeFirstLetter(String original) {
        if (original == null || original.isEmpty()) {
            return original;
        }
        return original.substring(0, 1).toLowerCase() + original.substring(1);
    }

    static boolean startsWithIs(String original) {
        return original.startsWith("is") && original.length() > 2 && Character.isUpperCase(original.charAt(2));
    }

    static boolean isSetterMethod(Element element) {
        if (element.getKind() != ElementKind.METHOD) {
            return false;
        }
        ExecutableElement method = (ExecutableElement)element;
        String methodName = method.getSimpleName().toString();
        return PATTERN_STARTS_WITH_SET.matcher(methodName).matches() && method.getParameters().size() == 1;
    }

    static String removeSetPrefix(String string) {
        if (!PATTERN_STARTS_WITH_SET.matcher(string).matches()) {
            return string;
        }
        return String.valueOf(string.charAt(3)).toLowerCase() + string.substring(4);
    }

    static boolean isType(TypeMirror typeMirror, String otherType) {
        return otherType.equals(typeMirror.toString());
    }

    static boolean isType(Elements elements, Types types, TypeMirror typeMirror, Class<?> clazz) {
        TypeMirror classType = KotlinUtilsKt.getTypeMirror(clazz, elements);
        return types.isSameType(typeMirror, classType);
    }

    static boolean isType(Elements elements, Types types, TypeMirror typeMirror, Class<?> ... typeNames) {
        for (Class<?> clazz : typeNames) {
            if (!Utils.isType(elements, types, typeMirror, clazz)) continue;
            return true;
        }
        return false;
    }

    static boolean isType(TypeMirror type, ClassName className) {
        return Utils.isType(type, className.reflectionName());
    }

    static boolean isListOfType(TypeMirror typeMirror, String type) {
        return Utils.isType(typeMirror, "java.util.List<" + type + ">");
    }

    @Nullable
    static <T extends Annotation> ClassName getClassParamFromAnnotation(Element annotatedElement, Class<T> annotationClass, String paramName, Types typeUtils) {
        AnnotationMirror am = Utils.getAnnotationMirror(annotatedElement, annotationClass);
        if (am == null) {
            return null;
        }
        AnnotationValue av = Utils.getAnnotationValue(am, paramName);
        if (av == null) {
            return null;
        }
        Object value = av.getValue();
        if (value instanceof TypeMirror) {
            return ClassName.get((TypeElement)((TypeElement)typeUtils.asElement((TypeMirror)value)));
        }
        return null;
    }

    private static AnnotationMirror getAnnotationMirror(Element typeElement, Class<? extends Annotation> annotationClass) {
        String clazzName = annotationClass.getName();
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(clazzName)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    static String toSnakeCase(String s) {
        return s.replaceAll("([^_A-Z])([A-Z])", "$1_$2").toLowerCase();
    }

    static <T> T notNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    static String getDefaultValue(TypeName attributeType) {
        if (attributeType == TypeName.BOOLEAN) {
            return "false";
        }
        if (attributeType == TypeName.INT) {
            return "0";
        }
        if (attributeType == TypeName.BYTE) {
            return "(byte) 0";
        }
        if (attributeType == TypeName.CHAR) {
            return "(char) 0";
        }
        if (attributeType == TypeName.SHORT) {
            return "(short) 0";
        }
        if (attributeType == TypeName.LONG) {
            return "0L";
        }
        if (attributeType == TypeName.FLOAT) {
            return "0.0f";
        }
        if (attributeType == TypeName.DOUBLE) {
            return "0.0d";
        }
        return "null";
    }
}

