/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import com.airbnb.epoxy.AttributeInfo;
import com.airbnb.epoxy.CallbackProp;
import com.airbnb.epoxy.ClassNames;
import com.airbnb.epoxy.ErrorLogger;
import com.airbnb.epoxy.JavaPoetDslKt;
import com.airbnb.epoxy.KotlinUtilsKt;
import com.airbnb.epoxy.ModelProp;
import com.airbnb.epoxy.ModelViewInfo;
import com.airbnb.epoxy.ModelViewProcessor;
import com.airbnb.epoxy.ResourceProcessor;
import com.airbnb.epoxy.ResourceValue;
import com.airbnb.epoxy.TextProp;
import com.airbnb.epoxy.Utils;
import com.airbnb.epoxy.ViewAttributeInfoKt;
import com.airbnb.epoxy.ViewAttributeType;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J(\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J<\u0010/\u001a\u00020%2\b\u00100\u001a\u0004\u0018\u00010\u00102\u0006\u00101\u001a\u0002022\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u00103\u001a\u0002042\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\b\u00105\u001a\u00020\u0010H\u0016J\b\u00106\u001a\u00020\u0010H\u0016J\u0012\u00107\u001a\u0004\u0018\u00010\u00102\u0006\u00108\u001a\u000209H\u0002J\u001a\u0010:\u001a\u0004\u0018\u00010!2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010;\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0002J(\u0010<\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u000209H\u0002J\b\u0010?\u001a\u00020\u0010H\u0016J.\u0010@\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\u001c\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u0011\u0010\u001e\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012R\u0013\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006D"}, d2={"Lcom/airbnb/epoxy/ViewAttributeInfo;", "Lcom/airbnb/epoxy/AttributeInfo;", "modelInfo", "Lcom/airbnb/epoxy/ModelViewInfo;", "viewAttributeElement", "Ljavax/lang/model/element/Element;", "types", "Ljavax/lang/model/util/Types;", "elements", "Ljavax/lang/model/util/Elements;", "errorLogger", "Lcom/airbnb/epoxy/ErrorLogger;", "resourceProcessor", "Lcom/airbnb/epoxy/ResourceProcessor;", "(Lcom/airbnb/epoxy/ModelViewInfo;Ljavax/lang/model/element/Element;Ljavax/lang/model/util/Types;Ljavax/lang/model/util/Elements;Lcom/airbnb/epoxy/ErrorLogger;Lcom/airbnb/epoxy/ResourceProcessor;)V", "constantFieldNameForDefaultValue", "", "getConstantFieldNameForDefaultValue", "()Ljava/lang/String;", "setConstantFieldNameForDefaultValue", "(Ljava/lang/String;)V", "generateStringOverloads", "", "getGenerateStringOverloads", "()Z", "isRequired", "propName", "getPropName", "resetWithNull", "getResetWithNull", "viewAttributeName", "getViewAttributeName", "viewAttributeTypeName", "Lcom/airbnb/epoxy/ViewAttributeType;", "getViewAttributeTypeName", "()Lcom/airbnb/epoxy/ViewAttributeType;", "assignDefaultValue", "", "defaultConstant", "assignNullability", "paramElement", "Ljavax/lang/model/element/VariableElement;", "typeMirror", "Ljavax/lang/model/type/TypeMirror;", "checkElementForConstant", "element", "constantName", "createJavaDoc", "docComment", "codeToSetDefault", "Lcom/airbnb/epoxy/AttributeInfo$DefaultValue;", "viewElement", "Ljavax/lang/model/element/TypeElement;", "generatedGetterName", "generatedSetterName", "getSimpleName", "name", "Lcom/squareup/javapoet/TypeName;", "getViewAttributeType", "isMarkedNullable", "parseAnnotations", "markedNullable", "typeName", "toString", "validatePropOptions", "options", "", "Lcom/airbnb/epoxy/ModelProp$Option;", "epoxy-processor"})
public final class ViewAttributeInfo
extends AttributeInfo {
    @NotNull
    private final String propName;
    @NotNull
    private final String viewAttributeName;
    private final boolean resetWithNull;
    private final boolean generateStringOverloads;
    @Nullable
    private final ViewAttributeType viewAttributeTypeName;
    @Nullable
    private String constantFieldNameForDefaultValue;
    private final ModelViewInfo modelInfo;

    @NotNull
    public final String getPropName() {
        return this.propName;
    }

    @NotNull
    public final String getViewAttributeName() {
        return this.viewAttributeName;
    }

    public final boolean getResetWithNull() {
        return this.resetWithNull;
    }

    public final boolean getGenerateStringOverloads() {
        return this.generateStringOverloads;
    }

    @Nullable
    public final ViewAttributeType getViewAttributeTypeName() {
        return this.viewAttributeTypeName;
    }

    @Nullable
    public final String getConstantFieldNameForDefaultValue() {
        return this.constantFieldNameForDefaultValue;
    }

    public final void setConstantFieldNameForDefaultValue(@Nullable String string) {
        this.constantFieldNameForDefaultValue = string;
    }

    @Override
    public boolean isRequired() {
        return this.generateStringOverloads ? !this.isNullable() && this.constantFieldNameForDefaultValue == null : super.isRequired();
    }

    private final ViewAttributeType getViewAttributeType(Element element, ErrorLogger errorLogger) {
        ViewAttributeType viewAttributeType;
        if (element.getKind() == ElementKind.METHOD) {
            viewAttributeType = ViewAttributeType.Method.INSTANCE;
        } else if (element.getKind() == ElementKind.FIELD) {
            viewAttributeType = ViewAttributeType.Field.INSTANCE;
        } else {
            errorLogger.logError("Element must be either method or field (element: %s)", element);
            viewAttributeType = null;
        }
        return viewAttributeType;
    }

    private final void assignNullability(VariableElement paramElement, TypeMirror typeMirror) {
        if (this.isPrimitive()) {
            return;
        }
        this.setNullable((Boolean)false);
        if (this.isMarkedNullable(paramElement)) {
            this.setNullable((Boolean)true);
            this.getCodeToSetDefault().setImplicit(CodeBlock.of((String)"($T) null", (Object[])new Object[]{typeMirror}));
        }
    }

    private final boolean isMarkedNullable(VariableElement paramElement) {
        boolean bl;
        block3: {
            List<? extends AnnotationMirror> list = paramElement.getAnnotationMirrors();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"paramElement.annotationMirrors");
            Iterable $receiver$iv = list;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    AnnotationMirror it;
                    AnnotationMirror annotationMirror = it = (AnnotationMirror)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)annotationMirror, (String)"it");
                    Element element = annotationMirror.getAnnotationType().asElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it.annotationType.asElement()");
                    if (!Intrinsics.areEqual((Object)element.getSimpleName().toString(), (Object)"Nullable")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void assignDefaultValue(String defaultConstant, ErrorLogger errorLogger, Types types) {
        CharSequence charSequence = defaultConstant;
        if (charSequence.length() == 0) {
            if (this.isPrimitive()) {
                this.getCodeToSetDefault().setImplicit(CodeBlock.of((String)Utils.getDefaultValue(this.getTypeName()), (Object[])new Object[0]));
            }
            return;
        }
        TypeElement viewClass = this.modelInfo.getViewElement();
        while (viewClass != null) {
            Iterator<? extends Element> iterator = viewClass.getEnclosedElements().iterator();
            while (iterator.hasNext()) {
                Element element;
                Element element2 = element = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
                if (!this.checkElementForConstant(element2, defaultConstant, types, errorLogger)) continue;
                return;
            }
            viewClass = KotlinUtilsKt.getParentClassElement(viewClass, types);
        }
        Object[] objectArray = new Object[3];
        Name name = this.modelInfo.getViewElement().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"modelInfo.viewElement.simpleName");
        objectArray[0] = name;
        objectArray[1] = this.viewAttributeName;
        objectArray[2] = defaultConstant;
        errorLogger.logError("The default value for (%s#%s) could not be found. Expected a constant named '%s' in the view class.", objectArray);
    }

    private final boolean checkElementForConstant(Element element, String constantName, Types types, ErrorLogger errorLogger) {
        if (element.getKind() == ElementKind.FIELD && Intrinsics.areEqual((Object)element.getSimpleName().toString(), (Object)constantName)) {
            Set<Modifier> modifiers = element.getModifiers();
            if (!modifiers.contains((Object)Modifier.FINAL) || !modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE)) {
                Object[] objectArray = new Object[2];
                Name name = this.modelInfo.getViewElement().getSimpleName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"modelInfo.viewElement.simpleName");
                objectArray[0] = name;
                objectArray[1] = this.viewAttributeName;
                errorLogger.logError("Default values for view props must be static, final, and not private. (%s#%s)", objectArray);
                return true;
            }
            if (!types.isAssignable(element.asType(), this.getTypeMirror())) {
                Object[] objectArray = new Object[3];
                Name name = this.modelInfo.getViewElement().getSimpleName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"modelInfo.viewElement.simpleName");
                objectArray[0] = name;
                objectArray[1] = this.viewAttributeName;
                objectArray[2] = this.getTypeMirror();
                errorLogger.logError("The default value for (%s#%s) must be a %s.", objectArray);
                return true;
            }
            this.constantFieldNameForDefaultValue = constantName;
            this.getCodeToSetDefault().setExplicit(CodeBlock.of((String)"$T.$L", (Object[])new Object[]{ClassName.get((TypeElement)this.modelInfo.getViewElement()), constantName}));
            return true;
        }
        return false;
    }

    private final void validatePropOptions(ErrorLogger errorLogger, Set<? extends ModelProp.Option> options, Types types, Elements elements) {
        if (options.contains(ModelProp.Option.IgnoreRequireHashCode) && options.contains(ModelProp.Option.DoNotHash)) {
            Object[] objectArray = new Object[5];
            objectArray[0] = ModelProp.Option.DoNotHash;
            objectArray[1] = ModelProp.Option.IgnoreRequireHashCode;
            String string = ModelProp.class.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ModelProp::class.java.simpleName");
            objectArray[2] = string;
            objectArray[3] = this.getModelName();
            objectArray[4] = this.viewAttributeName;
            errorLogger.logError("Illegal to use both %s and %s options in an %s annotation. (%s#%s)", objectArray);
        }
        if (options.contains(ModelProp.Option.GenerateStringOverloads) && !types.isAssignable(KotlinUtilsKt.getTypeMirror(CharSequence.class, elements), this.getTypeMirror())) {
            errorLogger.logError("Setters with %s option must be a CharSequence. (%s#%s)", ModelProp.Option.GenerateStringOverloads, this.getModelName(), this.viewAttributeName);
        }
        if (!(!options.contains(ModelProp.Option.NullOnRecycle) || this.hasSetNullability() && this.isNullable())) {
            errorLogger.logError("Setters with %s option must have a type that is annotated with @Nullable. (%s#%s)", ModelProp.Option.NullOnRecycle, this.getModelName(), this.viewAttributeName);
        }
    }

    private final String getSimpleName(TypeName name) {
        String string;
        if (name.isPrimitive()) {
            return Utils.capitalizeFirstLetter(name.toString());
        }
        TypeName typeName = name;
        if (typeName instanceof ClassName) {
            string = ((ClassName)name).simpleName();
        } else if (typeName instanceof ArrayTypeName) {
            StringBuilder stringBuilder = new StringBuilder();
            TypeName typeName2 = ((ArrayTypeName)name).componentType;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeName2, (String)"name.componentType");
            String string2 = this.getSimpleName(typeName2);
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = stringBuilder.append(string2).append("Array").toString();
        } else if (typeName instanceof ParameterizedTypeName) {
            ClassName className = ((ParameterizedTypeName)name).rawType;
            Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"name.rawType");
            string = this.getSimpleName((TypeName)className);
        } else if (typeName instanceof TypeVariableName) {
            string = Utils.capitalizeFirstLetter(((TypeVariableName)name).name);
        } else {
            String string3 = name.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"name.toString()");
            string = StringsKt.replace$default((String)string3, (String)".", (String)"", (boolean)false, (int)4, null);
        }
        return string;
    }

    private final void parseAnnotations(VariableElement paramElement, Types types, boolean markedNullable, TypeName typeName) {
        Iterator<? extends AnnotationMirror> iterator = paramElement.getAnnotationMirrors().iterator();
        while (iterator.hasNext()) {
            Map.Entry it;
            Map.Entry $receiver$iv$iv;
            Iterable $receiver$iv;
            TypeElement annotationType;
            AnnotationMirror annotationMirror;
            AnnotationMirror annotationMirror2 = annotationMirror = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationMirror2, (String)"annotationMirror");
            Element element = types.asElement(annotationMirror2.getAnnotationType());
            if (!(element instanceof TypeElement)) {
                element = null;
            }
            if ((TypeElement)element == null) {
                continue;
            }
            ClassName elementClassName = ClassName.get((TypeElement)annotationType);
            Iterable iterable = $receiver$iv = (Iterable)ModelViewProcessor.Companion.getModelPropAnnotations();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Object object = $receiver$iv$iv.iterator();
            while (object.hasNext()) {
                Object item$iv$iv = object.next();
                Class clazz = (Class)item$iv$iv;
                Collection collection = destination$iv$iv;
                ClassName className = JavaPoetDslKt.className(it);
                collection.add(className);
            }
            if (((List)destination$iv$iv).contains(elementClassName)) continue;
            AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)elementClassName);
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"annotationMirror\n                .elementValues");
            object = map;
            Iterator iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = $receiver$iv$iv = iterator2.next();
                ExecutableElement key = (ExecutableElement)it.getKey();
                it = $receiver$iv$iv;
                AnnotationValue value = (AnnotationValue)it.getValue();
                ExecutableElement executableElement = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)executableElement, (String)"key");
                String paramName = executableElement.getSimpleName().toString();
                AnnotationValue annotationValue = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)annotationValue, (String)"value");
                String paramValue = annotationValue.getValue().toString();
                builder.addMember(paramName, paramValue, new Object[0]);
            }
            AnnotationSpec annotationSpec = builder.build();
            List<AnnotationSpec> list = this.getSetterAnnotations();
            AnnotationSpec annotationSpec2 = annotationSpec;
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationSpec2, (String)"annotationSpec");
            list.add(annotationSpec2);
            this.getGetterAnnotations().add(annotationSpec);
        }
        if (!(typeName.isPrimitive() || markedNullable || this.getSetterAnnotations().contains(ViewAttributeInfoKt.access$getNON_NULL_ANNOTATION_SPEC$p()) || this.getSetterAnnotations().contains(ViewAttributeInfoKt.access$getNOT_NULL_ANNOTATION_SPEC$p()))) {
            List<AnnotationSpec> list = this.getSetterAnnotations();
            AnnotationSpec annotationSpec = ViewAttributeInfoKt.access$getNON_NULL_ANNOTATION_SPEC$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationSpec, (String)"NON_NULL_ANNOTATION_SPEC");
            list.add(annotationSpec);
            List<AnnotationSpec> list2 = this.getGetterAnnotations();
            AnnotationSpec annotationSpec3 = ViewAttributeInfoKt.access$getNON_NULL_ANNOTATION_SPEC$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationSpec3, (String)"NON_NULL_ANNOTATION_SPEC");
            list2.add(annotationSpec3);
        }
    }

    private final void createJavaDoc(String docComment, AttributeInfo.DefaultValue codeToSetDefault, String constantFieldNameForDefaultValue, TypeElement viewElement, TypeMirror typeMirror, String viewAttributeName) {
        this.setJavaDocString(docComment);
        if (this.getJavaDoc() == null) {
            this.setJavaDoc(CodeBlock.of((String)"", (Object[])new Object[0]));
        }
        CodeBlock codeBlock = this.getJavaDoc();
        if (codeBlock == null) {
            Intrinsics.throwNpe();
        }
        CodeBlock.Builder builder = codeBlock.toBuilder();
        CodeBlock codeBlock2 = this.getJavaDoc();
        if (codeBlock2 == null) {
            Intrinsics.throwNpe();
        }
        if (!codeBlock2.isEmpty()) {
            builder.add("\n<p>\n", new Object[0]);
        }
        if (this.isRequired()) {
            builder.add("<i>Required.</i>", new Object[0]);
        } else {
            builder.add("<i>Optional</i>: ", new Object[0]);
            if (constantFieldNameForDefaultValue == null) {
                builder.add("Default value is $L", new Object[]{codeToSetDefault.value()});
            } else {
                builder.add("Default value is <b>{@value $T#$L}</b>", new Object[]{ClassName.get((TypeElement)viewElement), constantFieldNameForDefaultValue});
            }
        }
        if (Intrinsics.areEqual((Object)this.viewAttributeTypeName, (Object)ViewAttributeType.Field.INSTANCE)) {
            builder.add("\n\n@see $T#$L", new Object[]{viewElement.asType(), viewAttributeName});
        } else {
            builder.add("\n\n@see $T#$L($T)", new Object[]{viewElement.asType(), viewAttributeName, typeMirror});
        }
        this.setJavaDoc(builder.add("\n", new Object[0]).build());
    }

    @Override
    @NotNull
    public String generatedSetterName() {
        return this.propName;
    }

    @Override
    @NotNull
    public String generatedGetterName() {
        if (this.isOverload()) {
            StringBuilder stringBuilder = new StringBuilder().append(this.propName);
            String string = this.getSimpleName(this.getTypeName());
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return stringBuilder.append(string).toString();
        }
        if (this.generateStringOverloads) {
            return "get" + Utils.capitalizeFirstLetter(this.propName);
        }
        return this.propName;
    }

    @Override
    @NotNull
    public String toString() {
        return "View Prop {view='" + this.modelInfo.getViewElement().getSimpleName() + '\'' + ", name='" + this.viewAttributeName + '\'' + ", type=" + this.getTypeName() + '}';
    }

    public ViewAttributeInfo(@NotNull ModelViewInfo modelInfo, @NotNull Element viewAttributeElement, @NotNull Types types, @NotNull Elements elements, @NotNull ErrorLogger errorLogger, @NotNull ResourceProcessor resourceProcessor) {
        VariableElement variableElement;
        Intrinsics.checkParameterIsNotNull((Object)modelInfo, (String)"modelInfo");
        Intrinsics.checkParameterIsNotNull((Object)viewAttributeElement, (String)"viewAttributeElement");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        Intrinsics.checkParameterIsNotNull((Object)errorLogger, (String)"errorLogger");
        Intrinsics.checkParameterIsNotNull((Object)resourceProcessor, (String)"resourceProcessor");
        this.modelInfo = modelInfo;
        ModelProp propAnnotation = viewAttributeElement.getAnnotation(ModelProp.class);
        TextProp textAnnotation = viewAttributeElement.getAnnotation(TextProp.class);
        CallbackProp callbackAnnotation = viewAttributeElement.getAnnotation(CallbackProp.class);
        HashSet<ModelProp.Option> options = new HashSet<ModelProp.Option>();
        Element element = viewAttributeElement;
        if (element instanceof ExecutableElement) {
            variableElement = ((ExecutableElement)viewAttributeElement).getParameters().get(0);
        } else if (element instanceof VariableElement) {
            variableElement = (VariableElement)viewAttributeElement;
        } else {
            throw (Throwable)new IllegalStateException("Unsuppported element type " + viewAttributeElement);
        }
        VariableElement param = variableElement;
        this.viewAttributeTypeName = this.getViewAttributeType(viewAttributeElement, errorLogger);
        this.setGroupKey("");
        String defaultConstant = "";
        if (propAnnotation != null) {
            defaultConstant = propAnnotation.defaultValue();
            this.setGroupKey(propAnnotation.group());
            ModelProp.Option[] optionArray = propAnnotation.options();
            options.addAll((Collection)Arrays.asList(Arrays.copyOf(optionArray, optionArray.length)));
            ModelProp.Option[] optionArray2 = propAnnotation.value();
            options.addAll((Collection)Arrays.asList(Arrays.copyOf(optionArray2, optionArray2.length)));
        } else if (textAnnotation != null) {
            int stringResValue = textAnnotation.defaultRes();
            if (stringResValue != 0) {
                ResourceValue stringResource = resourceProcessor.getStringResourceInAnnotation(viewAttributeElement, TextProp.class, stringResValue);
                this.getCodeToSetDefault().setExplicit(stringResource.getCode());
            }
            options.add(ModelProp.Option.GenerateStringOverloads);
        } else if (callbackAnnotation != null) {
            options.add(ModelProp.Option.DoNotHash);
            VariableElement variableElement2 = param;
            Intrinsics.checkExpressionValueIsNotNull((Object)variableElement2, (String)"param");
            if (this.isMarkedNullable(variableElement2)) {
                options.add(ModelProp.Option.NullOnRecycle);
            } else {
                Object[] objectArray = new Object[1];
                String string = CallbackProp.class.getSimpleName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CallbackProp::class.java.simpleName");
                objectArray[0] = string;
                errorLogger.logError("Setters with %s must be marked Nullable", objectArray);
            }
        }
        this.setGenerateSetter(true);
        this.setGenerateGetter(true);
        this.setHasFinalModifier(false);
        this.setPackagePrivate(Utils.isFieldPackagePrivate(viewAttributeElement));
        this.setGenerated(true);
        this.setUseInHash(!options.contains(ModelProp.Option.DoNotHash));
        this.setIgnoreRequireHashCode(options.contains(ModelProp.Option.IgnoreRequireHashCode));
        this.resetWithNull = options.contains(ModelProp.Option.NullOnRecycle);
        this.generateStringOverloads = options.contains(ModelProp.Option.GenerateStringOverloads);
        String string = this.modelInfo.getGeneratedName().simpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"modelInfo.generatedName.simpleName()");
        this.setModelName(string);
        this.setPackageName(this.modelInfo.generatedClassName.packageName());
        this.viewAttributeName = viewAttributeElement.getSimpleName().toString();
        String string2 = Utils.removeSetPrefix(this.viewAttributeName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"removeSetPrefix(viewAttributeName)");
        this.propName = string2;
        TypeMirror typeMirror = param.asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"param.asType()");
        this.setTypeMirror(typeMirror);
        this.assignDefaultValue(defaultConstant, errorLogger, types);
        VariableElement variableElement3 = param;
        Intrinsics.checkExpressionValueIsNotNull((Object)variableElement3, (String)"param");
        this.assignNullability(variableElement3, this.getTypeMirror());
        this.createJavaDoc(elements.getDocComment(viewAttributeElement), this.getCodeToSetDefault(), this.constantFieldNameForDefaultValue, this.modelInfo.getViewElement(), this.getTypeMirror(), this.viewAttributeName);
        this.validatePropOptions(errorLogger, (Set<? extends ModelProp.Option>)options, types, elements);
        if (this.generateStringOverloads) {
            this.setTypeMirror(KotlinUtilsKt.getTypeMirror(ClassNames.EPOXY_STRING_ATTRIBUTE_DATA, elements, types));
            if (this.getCodeToSetDefault().isPresent()) {
                if (this.getCodeToSetDefault().getExplicit() != null) {
                    this.getCodeToSetDefault().setExplicit(CodeBlock.of((String)" new $T($L)", (Object[])new Object[]{this.getTypeMirror(), this.getCodeToSetDefault().getExplicit()}));
                }
                if (this.getCodeToSetDefault().getImplicit() != null) {
                    this.getCodeToSetDefault().setImplicit(CodeBlock.of((String)" new $T($L)", (Object[])new Object[]{this.getTypeMirror(), this.getCodeToSetDefault().getImplicit()}));
                }
            } else {
                this.getCodeToSetDefault().setImplicit(CodeBlock.of((String)" new $T()", (Object[])new Object[]{this.getTypeMirror()}));
            }
        }
        this.setFieldName(this.propName + "_" + this.getSimpleName(this.getTypeName()));
        boolean bl = this.isMarkedNullable(param);
        TypeName typeName = TypeName.get((TypeMirror)this.getTypeMirror());
        Intrinsics.checkExpressionValueIsNotNull((Object)typeName, (String)"TypeName.get(typeMirror)");
        this.parseAnnotations(param, types, bl, typeName);
        if (this.generateStringOverloads) {
            this.getSetterAnnotations().clear();
            this.getGetterAnnotations().clear();
        }
    }
}

