/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.deeplinkdispatch;

import java.net.IDN;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import okio.Buffer;

final class DeepLinkUri {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    static final String QUERY_ENCODE_SET = " \"'<>#";
    static final String QUERY_COMPONENT_ENCODE_SET = " \"'<>#&=";
    static final String CONVERT_TO_URI_ENCODE_SET = "^`{}|\\";
    static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    static final String FRAGMENT_ENCODE_SET = "";
    private final String scheme;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final List<String> pathSegments;
    private final List<String> queryNamesAndValues;
    private final String fragment;
    private final String url;

    private DeepLinkUri(Builder builder) {
        this.scheme = builder.scheme;
        this.username = DeepLinkUri.percentDecode(builder.encodedUsername);
        this.password = DeepLinkUri.percentDecode(builder.encodedPassword);
        this.host = builder.host;
        this.port = builder.effectivePort();
        this.pathSegments = this.percentDecode(builder.encodedPathSegments);
        this.queryNamesAndValues = builder.encodedQueryNamesAndValues != null ? this.percentDecode(builder.encodedQueryNamesAndValues) : null;
        this.fragment = builder.encodedFragment != null ? DeepLinkUri.percentDecode(builder.encodedFragment) : null;
        this.url = builder.toString();
    }

    URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    URI uri() {
        try {
            String uriSafeUrl = DeepLinkUri.canonicalize(this.url, CONVERT_TO_URI_ENCODE_SET, true, false);
            return new URI(uriSafeUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("not valid as a java.net.URI: " + this.url);
        }
    }

    String scheme() {
        return this.scheme;
    }

    boolean isHttps() {
        return this.scheme.equals("https");
    }

    String encodedUsername() {
        if (this.username.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int usernameStart = this.scheme.length() + 3;
        int usernameEnd = DeepLinkUri.delimiterOffset(this.url, usernameStart, this.url.length(), ":@");
        return this.url.substring(usernameStart, usernameEnd);
    }

    String username() {
        return this.username;
    }

    String encodedPassword() {
        if (this.password.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int passwordStart = this.url.indexOf(58, this.scheme.length() + 3) + 1;
        int passwordEnd = this.url.indexOf(64);
        return this.url.substring(passwordStart, passwordEnd);
    }

    String password() {
        return this.password;
    }

    String host() {
        return this.host;
    }

    String encodedHost() {
        return DeepLinkUri.canonicalize(this.host, CONVERT_TO_URI_ENCODE_SET, true, true);
    }

    int port() {
        return this.port;
    }

    static int defaultPort(String scheme) {
        if (scheme.equals("http")) {
            return 80;
        }
        if (scheme.equals("https")) {
            return 443;
        }
        return -1;
    }

    int pathSize() {
        return this.pathSegments.size();
    }

    String encodedPath() {
        int pathStart = this.url.indexOf(47, this.scheme.length() + 3);
        int pathEnd = DeepLinkUri.delimiterOffset(this.url, pathStart, this.url.length(), "?#");
        return this.url.substring(pathStart, pathEnd);
    }

    static void pathSegmentsToString(StringBuilder out, List<String> pathSegments) {
        int size = pathSegments.size();
        for (int i = 0; i < size; ++i) {
            out.append('/');
            out.append(pathSegments.get(i));
        }
    }

    List<String> encodedPathSegments() {
        int pathStart = this.url.indexOf(47, this.scheme.length() + 3);
        int pathEnd = DeepLinkUri.delimiterOffset(this.url, pathStart, this.url.length(), "?#");
        ArrayList<String> result = new ArrayList<String>();
        int i = pathStart;
        while (i < pathEnd) {
            int segmentEnd = DeepLinkUri.delimiterOffset(this.url, ++i, pathEnd, "/");
            result.add(this.url.substring(i, segmentEnd));
            i = segmentEnd;
        }
        return result;
    }

    List<String> pathSegments() {
        return this.pathSegments;
    }

    String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int queryStart = this.url.indexOf(63) + 1;
        int queryEnd = DeepLinkUri.delimiterOffset(this.url, queryStart + 1, this.url.length(), "#");
        return this.url.substring(queryStart, queryEnd);
    }

    static void namesAndValuesToQueryString(StringBuilder out, List<String> namesAndValues) {
        int size = namesAndValues.size();
        for (int i = 0; i < size; i += 2) {
            String name = namesAndValues.get(i);
            String value = namesAndValues.get(i + 1);
            if (i > 0) {
                out.append('&');
            }
            out.append(name);
            if (value == null) continue;
            out.append('=');
            out.append(value);
        }
    }

    static List<String> queryStringToNamesAndValues(String encodedQuery) {
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        while (pos <= encodedQuery.length()) {
            int equalsOffset;
            int ampersandOffset = encodedQuery.indexOf(38, pos);
            if (ampersandOffset == -1) {
                ampersandOffset = encodedQuery.length();
            }
            if ((equalsOffset = encodedQuery.indexOf(61, pos)) == -1 || equalsOffset > ampersandOffset) {
                result.add(encodedQuery.substring(pos, ampersandOffset));
                result.add(null);
            } else {
                result.add(encodedQuery.substring(pos, equalsOffset));
                result.add(encodedQuery.substring(equalsOffset + 1, ampersandOffset));
            }
            pos = ampersandOffset + 1;
        }
        return result;
    }

    String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        DeepLinkUri.namesAndValuesToQueryString(result, this.queryNamesAndValues);
        return result.toString();
    }

    int querySize() {
        return this.queryNamesAndValues != null ? this.queryNamesAndValues.size() / 2 : 0;
    }

    String queryParameter(String name) {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int size = this.queryNamesAndValues.size();
        for (int i = 0; i < size; i += 2) {
            if (!name.equals(this.queryNamesAndValues.get(i))) continue;
            return this.queryNamesAndValues.get(i + 1);
        }
        return null;
    }

    Set<String> queryParameterNames() {
        if (this.queryNamesAndValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int size = this.queryNamesAndValues.size();
        for (int i = 0; i < size; i += 2) {
            result.add(this.queryNamesAndValues.get(i));
        }
        return Collections.unmodifiableSet(result);
    }

    List<String> queryParameterValues(String name) {
        if (this.queryNamesAndValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        int size = this.queryNamesAndValues.size();
        for (int i = 0; i < size; i += 2) {
            if (!name.equals(this.queryNamesAndValues.get(i))) continue;
            result.add(this.queryNamesAndValues.get(i + 1));
        }
        return Collections.unmodifiableList(result);
    }

    String queryParameterName(int index) {
        return this.queryNamesAndValues.get(index * 2);
    }

    String queryParameterValue(int index) {
        return this.queryNamesAndValues.get(index * 2 + 1);
    }

    String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int fragmentStart = this.url.indexOf(35) + 1;
        return this.url.substring(fragmentStart);
    }

    String fragment() {
        return this.fragment;
    }

    DeepLinkUri resolve(String link) {
        Builder builder = new Builder();
        Builder.ParseResult result = builder.parse(this, link);
        return result == Builder.ParseResult.SUCCESS ? builder.build() : null;
    }

    Builder newBuilder() {
        Builder result = new Builder();
        result.scheme = this.scheme;
        result.encodedUsername = this.encodedUsername();
        result.encodedPassword = this.encodedPassword();
        result.host = this.host;
        result.port = this.port;
        result.encodedPathSegments.clear();
        result.encodedPathSegments.addAll(this.encodedPathSegments());
        result.encodedQuery(this.encodedQuery());
        result.encodedFragment = this.encodedFragment();
        return result;
    }

    static DeepLinkUri parse(String url) {
        Builder builder = new Builder();
        Builder.ParseResult result = builder.parse(null, url);
        return result == Builder.ParseResult.SUCCESS ? builder.build() : null;
    }

    static DeepLinkUri get(URL url) {
        return DeepLinkUri.parse(url.toString());
    }

    static DeepLinkUri getChecked(String url) throws MalformedURLException, UnknownHostException {
        Builder builder = new Builder();
        Builder.ParseResult result = builder.parse(null, url);
        switch (result) {
            case SUCCESS: {
                return builder.build();
            }
            case INVALID_HOST: {
                throw new UnknownHostException("Invalid host: " + url);
            }
        }
        throw new MalformedURLException("Invalid URL: " + (Object)((Object)result) + " for " + url);
    }

    static DeepLinkUri get(URI uri) {
        return DeepLinkUri.parse(uri.toString());
    }

    public boolean equals(Object o) {
        return o instanceof DeepLinkUri && ((DeepLinkUri)o).url.equals(this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }

    private static int delimiterOffset(String input, int pos, int limit, String delimiters) {
        for (int i = pos; i < limit; ++i) {
            if (delimiters.indexOf(input.charAt(i)) == -1) continue;
            return i;
        }
        return limit;
    }

    static String percentDecode(String encoded) {
        return DeepLinkUri.percentDecode(encoded, 0, encoded.length());
    }

    private List<String> percentDecode(List<String> list) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (String s : list) {
            result.add(s != null ? DeepLinkUri.percentDecode(s) : null);
        }
        return Collections.unmodifiableList(result);
    }

    static String percentDecode(String encoded, int pos, int limit) {
        for (int i = pos; i < limit; ++i) {
            char c = encoded.charAt(i);
            if (c != '%') continue;
            Buffer out = new Buffer();
            out.writeUtf8(encoded, pos, i);
            DeepLinkUri.percentDecode(out, encoded, i, limit);
            return out.readUtf8();
        }
        return encoded.substring(pos, limit);
    }

    static void percentDecode(Buffer out, String encoded, int pos, int limit) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = encoded.codePointAt(i);
            if (codePoint == 37 && i + 2 < limit) {
                int d1 = DeepLinkUri.decodeHexDigit(encoded.charAt(i + 1));
                int d2 = DeepLinkUri.decodeHexDigit(encoded.charAt(i + 2));
                if (d1 != -1 && d2 != -1) {
                    out.writeByte((d1 << 4) + d2);
                    i += 2;
                    continue;
                }
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    static String canonicalize(String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean query) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (codePoint >= 32 && codePoint < 127 && encodeSet.indexOf(codePoint) == -1 && (codePoint != 37 || alreadyEncoded) && (!query || codePoint != 43)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(input, pos, i);
            DeepLinkUri.canonicalize(out, input, i, limit, encodeSet, alreadyEncoded, query);
            return out.readUtf8();
        }
        return input.substring(pos, limit);
    }

    static void canonicalize(Buffer out, String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean query) {
        int codePoint;
        Buffer utf8Buffer = null;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (alreadyEncoded && (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13)) continue;
            if (query && codePoint == 43) {
                out.writeUtf8(alreadyEncoded ? "%20" : "%2B");
                continue;
            }
            if (codePoint < 32 || codePoint >= 127 || encodeSet.indexOf(codePoint) != -1 || codePoint == 37 && !alreadyEncoded) {
                if (utf8Buffer == null) {
                    utf8Buffer = new Buffer();
                }
                utf8Buffer.writeUtf8CodePoint(codePoint);
                while (!utf8Buffer.exhausted()) {
                    int b = utf8Buffer.readByte() & 0xFF;
                    out.writeByte(37);
                    out.writeByte((int)HEX_DIGITS[b >> 4 & 0xF]);
                    out.writeByte((int)HEX_DIGITS[b & 0xF]);
                }
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    static String canonicalize(String input, String encodeSet, boolean alreadyEncoded, boolean query) {
        return DeepLinkUri.canonicalize(input, 0, input.length(), encodeSet, alreadyEncoded, query);
    }

    static final class Builder {
        String scheme;
        String encodedUsername = "";
        String encodedPassword = "";
        String host;
        int port = -1;
        final List<String> encodedPathSegments = new ArrayList<String>();
        List<String> encodedQueryNamesAndValues;
        String encodedFragment;

        Builder() {
            this.encodedPathSegments.add(DeepLinkUri.FRAGMENT_ENCODE_SET);
        }

        Builder scheme(String scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException("scheme == null");
            }
            this.scheme = scheme;
            return this;
        }

        Builder username(String username) {
            if (username == null) {
                throw new IllegalArgumentException("username == null");
            }
            this.encodedUsername = DeepLinkUri.canonicalize(username, " \"':;<=>@[]^`{}|/\\?#", false, false);
            return this;
        }

        Builder encodedUsername(String encodedUsername) {
            if (encodedUsername == null) {
                throw new IllegalArgumentException("encodedUsername == null");
            }
            this.encodedUsername = DeepLinkUri.canonicalize(encodedUsername, " \"':;<=>@[]^`{}|/\\?#", true, false);
            return this;
        }

        Builder password(String password) {
            if (password == null) {
                throw new IllegalArgumentException("password == null");
            }
            this.encodedPassword = DeepLinkUri.canonicalize(password, " \"':;<=>@[]^`{}|/\\?#", false, false);
            return this;
        }

        Builder encodedPassword(String encodedPassword) {
            if (encodedPassword == null) {
                throw new IllegalArgumentException("encodedPassword == null");
            }
            this.encodedPassword = DeepLinkUri.canonicalize(encodedPassword, " \"':;<=>@[]^`{}|/\\?#", true, false);
            return this;
        }

        Builder host(String host) {
            if (host == null) {
                throw new IllegalArgumentException("host == null");
            }
            String encoded = Builder.canonicalizeHost(host, 0, host.length());
            if (encoded == null) {
                throw new IllegalArgumentException("unexpected host: " + host);
            }
            this.host = encoded;
            return this;
        }

        Builder port(int port) {
            if (port <= 0 || port > 65535) {
                throw new IllegalArgumentException("unexpected port: " + port);
            }
            this.port = port;
            return this;
        }

        int effectivePort() {
            return this.port != -1 ? this.port : DeepLinkUri.defaultPort(this.scheme);
        }

        Builder addPathSegment(String pathSegment) {
            if (pathSegment == null) {
                throw new IllegalArgumentException("pathSegment == null");
            }
            this.push(pathSegment, 0, pathSegment.length(), false, false);
            return this;
        }

        Builder addEncodedPathSegment(String encodedPathSegment) {
            if (encodedPathSegment == null) {
                throw new IllegalArgumentException("encodedPathSegment == null");
            }
            this.push(encodedPathSegment, 0, encodedPathSegment.length(), false, true);
            return this;
        }

        Builder setPathSegment(int index, String pathSegment) {
            if (pathSegment == null) {
                throw new IllegalArgumentException("pathSegment == null");
            }
            String canonicalPathSegment = DeepLinkUri.canonicalize(pathSegment, 0, pathSegment.length(), DeepLinkUri.PATH_SEGMENT_ENCODE_SET, false, false);
            if (this.isDot(canonicalPathSegment) || this.isDotDot(canonicalPathSegment)) {
                throw new IllegalArgumentException("unexpected path segment: " + pathSegment);
            }
            this.encodedPathSegments.set(index, canonicalPathSegment);
            return this;
        }

        Builder setEncodedPathSegment(int index, String encodedPathSegment) {
            if (encodedPathSegment == null) {
                throw new IllegalArgumentException("encodedPathSegment == null");
            }
            String canonicalPathSegment = DeepLinkUri.canonicalize(encodedPathSegment, 0, encodedPathSegment.length(), DeepLinkUri.PATH_SEGMENT_ENCODE_SET, true, false);
            this.encodedPathSegments.set(index, canonicalPathSegment);
            if (this.isDot(canonicalPathSegment) || this.isDotDot(canonicalPathSegment)) {
                throw new IllegalArgumentException("unexpected path segment: " + encodedPathSegment);
            }
            return this;
        }

        Builder removePathSegment(int index) {
            this.encodedPathSegments.remove(index);
            if (this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add(DeepLinkUri.FRAGMENT_ENCODE_SET);
            }
            return this;
        }

        Builder encodedPath(String encodedPath) {
            if (encodedPath == null) {
                throw new IllegalArgumentException("encodedPath == null");
            }
            if (!encodedPath.startsWith("/")) {
                throw new IllegalArgumentException("unexpected encodedPath: " + encodedPath);
            }
            this.resolvePath(encodedPath, 0, encodedPath.length());
            return this;
        }

        Builder query(String query) {
            this.encodedQueryNamesAndValues = query != null ? DeepLinkUri.queryStringToNamesAndValues(DeepLinkUri.canonicalize(query, DeepLinkUri.QUERY_ENCODE_SET, false, true)) : null;
            return this;
        }

        Builder encodedQuery(String encodedQuery) {
            this.encodedQueryNamesAndValues = encodedQuery != null ? DeepLinkUri.queryStringToNamesAndValues(DeepLinkUri.canonicalize(encodedQuery, DeepLinkUri.QUERY_ENCODE_SET, true, true)) : null;
            return this;
        }

        Builder addQueryParameter(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(DeepLinkUri.canonicalize(name, DeepLinkUri.QUERY_COMPONENT_ENCODE_SET, false, true));
            this.encodedQueryNamesAndValues.add(value != null ? DeepLinkUri.canonicalize(value, DeepLinkUri.QUERY_COMPONENT_ENCODE_SET, false, true) : null);
            return this;
        }

        Builder addEncodedQueryParameter(String encodedName, String encodedValue) {
            if (encodedName == null) {
                throw new IllegalArgumentException("encodedName == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(DeepLinkUri.canonicalize(encodedName, DeepLinkUri.QUERY_COMPONENT_ENCODE_SET, true, true));
            this.encodedQueryNamesAndValues.add(encodedValue != null ? DeepLinkUri.canonicalize(encodedValue, DeepLinkUri.QUERY_COMPONENT_ENCODE_SET, true, true) : null);
            return this;
        }

        Builder setQueryParameter(String name, String value) {
            this.removeAllQueryParameters(name);
            this.addQueryParameter(name, value);
            return this;
        }

        Builder setEncodedQueryParameter(String encodedName, String encodedValue) {
            this.removeAllEncodedQueryParameters(encodedName);
            this.addEncodedQueryParameter(encodedName, encodedValue);
            return this;
        }

        Builder removeAllQueryParameters(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            String nameToRemove = DeepLinkUri.canonicalize(name, DeepLinkUri.QUERY_COMPONENT_ENCODE_SET, false, true);
            this.removeAllCanonicalQueryParameters(nameToRemove);
            return this;
        }

        Builder removeAllEncodedQueryParameters(String encodedName) {
            if (encodedName == null) {
                throw new IllegalArgumentException("encodedName == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(DeepLinkUri.canonicalize(encodedName, DeepLinkUri.QUERY_COMPONENT_ENCODE_SET, true, true));
            return this;
        }

        private void removeAllCanonicalQueryParameters(String canonicalName) {
            for (int i = this.encodedQueryNamesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!canonicalName.equals(this.encodedQueryNamesAndValues.get(i))) continue;
                this.encodedQueryNamesAndValues.remove(i + 1);
                this.encodedQueryNamesAndValues.remove(i);
                if (!this.encodedQueryNamesAndValues.isEmpty()) continue;
                this.encodedQueryNamesAndValues = null;
                return;
            }
        }

        Builder fragment(String fragment) {
            if (fragment == null) {
                throw new IllegalArgumentException("fragment == null");
            }
            this.encodedFragment = DeepLinkUri.canonicalize(fragment, DeepLinkUri.FRAGMENT_ENCODE_SET, false, false);
            return this;
        }

        Builder encodedFragment(String encodedFragment) {
            if (encodedFragment == null) {
                throw new IllegalArgumentException("encodedFragment == null");
            }
            this.encodedFragment = DeepLinkUri.canonicalize(encodedFragment, DeepLinkUri.FRAGMENT_ENCODE_SET, true, false);
            return this;
        }

        DeepLinkUri build() {
            if (this.scheme == null) {
                throw new IllegalStateException("scheme == null");
            }
            if (this.host == null) {
                throw new IllegalStateException("host == null");
            }
            return new DeepLinkUri(this);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.scheme);
            result.append("://");
            if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
                result.append(this.encodedUsername);
                if (!this.encodedPassword.isEmpty()) {
                    result.append(':');
                    result.append(this.encodedPassword);
                }
                result.append('@');
            }
            if (this.host.indexOf(58) != -1) {
                result.append('[');
                result.append(this.host);
                result.append(']');
            } else {
                result.append(this.host);
            }
            int effectivePort = this.effectivePort();
            if (effectivePort != DeepLinkUri.defaultPort(this.scheme)) {
                result.append(':');
                result.append(effectivePort);
            }
            DeepLinkUri.pathSegmentsToString(result, this.encodedPathSegments);
            if (this.encodedQueryNamesAndValues != null) {
                result.append('?');
                DeepLinkUri.namesAndValuesToQueryString(result, this.encodedQueryNamesAndValues);
            }
            if (this.encodedFragment != null) {
                result.append('#');
                result.append(this.encodedFragment);
            }
            return result.toString();
        }

        ParseResult parse(DeepLinkUri base, String input) {
            int limit;
            int pos;
            block24: {
                pos = this.skipLeadingAsciiWhitespace(input, 0, input.length());
                int schemeDelimiterOffset = Builder.schemeDelimiterOffset(input, pos, limit = this.skipTrailingAsciiWhitespace(input, pos, input.length()));
                if (schemeDelimiterOffset != -1) {
                    if (input.regionMatches(true, pos, "https:", 0, 6)) {
                        this.scheme = "https";
                        pos += "https:".length();
                    } else if (input.regionMatches(true, pos, "http:", 0, 5)) {
                        this.scheme = "http";
                        pos += "http:".length();
                    } else {
                        this.scheme = input.substring(pos, schemeDelimiterOffset);
                        pos += this.scheme.length() + 1;
                    }
                } else if (base != null) {
                    this.scheme = base.scheme;
                } else {
                    return ParseResult.MISSING_SCHEME;
                }
                boolean hasUsername = false;
                boolean hasPassword = false;
                int slashCount = Builder.slashCount(input, pos, limit);
                if (slashCount >= 2 || base == null || !base.scheme.equals(this.scheme)) {
                    pos += slashCount;
                    while (true) {
                        int componentDelimiterOffset;
                        int c = (componentDelimiterOffset = DeepLinkUri.delimiterOffset(input, pos, limit, "@/\\?#")) != limit ? (int)input.charAt(componentDelimiterOffset) : -1;
                        switch (c) {
                            case 64: {
                                if (!hasPassword) {
                                    int passwordColonOffset = DeepLinkUri.delimiterOffset(input, pos, componentDelimiterOffset, ":");
                                    String canonicalUsername = DeepLinkUri.canonicalize(input, pos, passwordColonOffset, " \"':;<=>@[]^`{}|/\\?#", true, false);
                                    String string = this.encodedUsername = hasUsername ? this.encodedUsername + "%40" + canonicalUsername : canonicalUsername;
                                    if (passwordColonOffset != componentDelimiterOffset) {
                                        hasPassword = true;
                                        this.encodedPassword = DeepLinkUri.canonicalize(input, passwordColonOffset + 1, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false);
                                    }
                                    hasUsername = true;
                                } else {
                                    this.encodedPassword = this.encodedPassword + "%40" + DeepLinkUri.canonicalize(input, pos, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false);
                                }
                                pos = componentDelimiterOffset + 1;
                                break;
                            }
                            case -1: 
                            case 35: 
                            case 47: 
                            case 63: 
                            case 92: {
                                int portColonOffset = Builder.portColonOffset(input, pos, componentDelimiterOffset);
                                if (portColonOffset + 1 < componentDelimiterOffset) {
                                    this.host = Builder.canonicalizeHost(input, pos, portColonOffset);
                                    this.port = Builder.parsePort(input, portColonOffset + 1, componentDelimiterOffset);
                                    if (this.port == -1) {
                                        return ParseResult.INVALID_PORT;
                                    }
                                } else {
                                    this.host = Builder.canonicalizeHost(input, pos, portColonOffset);
                                    this.port = DeepLinkUri.defaultPort(this.scheme);
                                }
                                if (this.host == null) {
                                    return ParseResult.INVALID_HOST;
                                }
                                pos = componentDelimiterOffset;
                                break block24;
                            }
                        }
                    }
                }
                this.encodedUsername = base.encodedUsername();
                this.encodedPassword = base.encodedPassword();
                this.host = base.host;
                this.port = base.port;
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll(base.encodedPathSegments());
                if (pos == limit || input.charAt(pos) == '#') {
                    this.encodedQuery(base.encodedQuery());
                }
            }
            int pathDelimiterOffset = DeepLinkUri.delimiterOffset(input, pos, limit, "?#");
            this.resolvePath(input, pos, pathDelimiterOffset);
            pos = pathDelimiterOffset;
            if (pos < limit && input.charAt(pos) == '?') {
                int queryDelimiterOffset = DeepLinkUri.delimiterOffset(input, pos, limit, "#");
                this.encodedQueryNamesAndValues = DeepLinkUri.queryStringToNamesAndValues(DeepLinkUri.canonicalize(input, pos + 1, queryDelimiterOffset, DeepLinkUri.QUERY_ENCODE_SET, true, true));
                pos = queryDelimiterOffset;
            }
            if (pos < limit && input.charAt(pos) == '#') {
                this.encodedFragment = DeepLinkUri.canonicalize(input, pos + 1, limit, DeepLinkUri.FRAGMENT_ENCODE_SET, true, false);
            }
            return ParseResult.SUCCESS;
        }

        private void resolvePath(String input, int pos, int limit) {
            if (pos == limit) {
                return;
            }
            char c = input.charAt(pos);
            if (c == '/' || c == '\\') {
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add(DeepLinkUri.FRAGMENT_ENCODE_SET);
                ++pos;
            } else {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, DeepLinkUri.FRAGMENT_ENCODE_SET);
            }
            int i = pos;
            while (i < limit) {
                int pathSegmentDelimiterOffset = DeepLinkUri.delimiterOffset(input, i, limit, "/\\");
                boolean segmentHasTrailingSlash = pathSegmentDelimiterOffset < limit;
                this.push(input, i, pathSegmentDelimiterOffset, segmentHasTrailingSlash, true);
                i = pathSegmentDelimiterOffset;
                if (!segmentHasTrailingSlash) continue;
                ++i;
            }
        }

        private void push(String input, int pos, int limit, boolean addTrailingSlash, boolean alreadyEncoded) {
            String segment = DeepLinkUri.canonicalize(input, pos, limit, DeepLinkUri.PATH_SEGMENT_ENCODE_SET, alreadyEncoded, false);
            if (this.isDot(segment)) {
                return;
            }
            if (this.isDotDot(segment)) {
                this.pop();
                return;
            }
            if (this.encodedPathSegments.get(this.encodedPathSegments.size() - 1).isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, segment);
            } else {
                this.encodedPathSegments.add(segment);
            }
            if (addTrailingSlash) {
                this.encodedPathSegments.add(DeepLinkUri.FRAGMENT_ENCODE_SET);
            }
        }

        private boolean isDot(String input) {
            return input.equals(".") || input.equalsIgnoreCase("%2e");
        }

        private boolean isDotDot(String input) {
            return input.equals("..") || input.equalsIgnoreCase("%2e.") || input.equalsIgnoreCase(".%2e") || input.equalsIgnoreCase("%2e%2e");
        }

        private void pop() {
            String removed = this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1);
            if (removed.isEmpty() && !this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, DeepLinkUri.FRAGMENT_ENCODE_SET);
            } else {
                this.encodedPathSegments.add(DeepLinkUri.FRAGMENT_ENCODE_SET);
            }
        }

        private int skipLeadingAsciiWhitespace(String input, int pos, int limit) {
            block3: for (int i = pos; i < limit; ++i) {
                switch (input.charAt(i)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        return i;
                    }
                }
            }
            return limit;
        }

        private int skipTrailingAsciiWhitespace(String input, int pos, int limit) {
            block3: for (int i = limit - 1; i >= pos; --i) {
                switch (input.charAt(i)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        return i + 1;
                    }
                }
            }
            return pos;
        }

        private static int schemeDelimiterOffset(String input, int pos, int limit) {
            if (limit - pos < 2) {
                return -1;
            }
            char c0 = input.charAt(pos);
            if (!(c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z')) {
                return -1;
            }
            for (int i = pos + 1; i < limit; ++i) {
                char c = input.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '+' || c == '-' || c == '.') continue;
                if (c == ':') {
                    return i;
                }
                return -1;
            }
            return -1;
        }

        private static int slashCount(String input, int pos, int limit) {
            char c;
            int slashCount = 0;
            while (pos < limit && ((c = input.charAt(pos)) == '\\' || c == '/')) {
                ++slashCount;
                ++pos;
            }
            return slashCount;
        }

        private static int portColonOffset(String input, int pos, int limit) {
            block4: for (int i = pos; i < limit; ++i) {
                switch (input.charAt(i)) {
                    case '[': {
                        while (++i < limit && input.charAt(i) != ']') {
                        }
                        continue block4;
                    }
                    case ':': {
                        return i;
                    }
                }
            }
            return limit;
        }

        private static String canonicalizeHost(String input, int pos, int limit) {
            String percentDecoded = DeepLinkUri.percentDecode(input, pos, limit);
            if (percentDecoded.startsWith("[") && percentDecoded.endsWith("]")) {
                InetAddress inetAddress = Builder.decodeIpv6(percentDecoded, 1, percentDecoded.length() - 1);
                if (inetAddress == null) {
                    return null;
                }
                byte[] address = inetAddress.getAddress();
                if (address.length == 16) {
                    return Builder.inet6AddressToAscii(address);
                }
                throw new AssertionError();
            }
            return Builder.domainToAscii(percentDecoded);
        }

        private static InetAddress decodeIpv6(String input, int pos, int limit) {
            byte[] address = new byte[16];
            int b = 0;
            int compress = -1;
            int groupOffset = -1;
            int i = pos;
            while (i < limit) {
                char c;
                int hexDigit;
                if (b == address.length) {
                    return null;
                }
                if (i + 2 <= limit && input.regionMatches(i, "::", 0, 2)) {
                    if (compress != -1) {
                        return null;
                    }
                    compress = b += 2;
                    if ((i += 2) == limit) {
                        break;
                    }
                } else if (b != 0 && !input.regionMatches(i, ":", 0, 1)) {
                    if (input.regionMatches(i, ".", 0, 1)) {
                        if (!Builder.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                            return null;
                        }
                        b += 2;
                        break;
                    }
                    return null;
                }
                int value = 0;
                groupOffset = ++i;
                while (i < limit && (hexDigit = DeepLinkUri.decodeHexDigit(c = input.charAt(i))) != -1) {
                    value = (value << 4) + hexDigit;
                    ++i;
                }
                int groupLength = i - groupOffset;
                if (groupLength == 0 || groupLength > 4) {
                    return null;
                }
                address[b++] = (byte)(value >>> 8 & 0xFF);
                address[b++] = (byte)(value & 0xFF);
            }
            if (b != address.length) {
                if (compress == -1) {
                    return null;
                }
                System.arraycopy(address, compress, address, address.length - (b - compress), b - compress);
                Arrays.fill(address, compress, compress + (address.length - b), (byte)0);
            }
            try {
                return InetAddress.getByAddress(address);
            }
            catch (UnknownHostException e) {
                throw new AssertionError();
            }
        }

        private static boolean decodeIpv4Suffix(String input, int pos, int limit, byte[] address, int addressOffset) {
            int b = addressOffset;
            int i = pos;
            while (i < limit) {
                char c;
                if (b == address.length) {
                    return false;
                }
                if (b != addressOffset && input.charAt(i) != '.') {
                    return false;
                }
                int value = 0;
                int groupOffset = ++i;
                while (i < limit && (c = input.charAt(i)) >= '0' && c <= '9') {
                    if (value == 0 && groupOffset != i) {
                        return false;
                    }
                    if ((value = value * 10 + c - 48) > 255) {
                        return false;
                    }
                    ++i;
                }
                int groupLength = i - groupOffset;
                if (groupLength == 0) {
                    return false;
                }
                address[b++] = (byte)value;
            }
            return b == addressOffset + 4;
        }

        private static String domainToAscii(String input) {
            try {
                String result = IDN.toASCII(input).toLowerCase(Locale.US);
                if (result.isEmpty()) {
                    return null;
                }
                if (result == null) {
                    return null;
                }
                if (Builder.containsInvalidHostnameAsciiCodes(result)) {
                    return null;
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        private static boolean containsInvalidHostnameAsciiCodes(String hostnameAscii) {
            for (int i = 0; i < hostnameAscii.length(); ++i) {
                char c = hostnameAscii.charAt(i);
                if (c <= '\u001f' || c >= '\u007f') {
                    return true;
                }
                if (" #%/:?@[\\]".indexOf(c) == -1) continue;
                return true;
            }
            return false;
        }

        private static String inet6AddressToAscii(byte[] address) {
            int longestRunOffset = -1;
            int longestRunLength = 0;
            for (int i = 0; i < address.length; i += 2) {
                int currentRunOffset = i;
                while (i < 16 && address[i] == 0 && address[i + 1] == 0) {
                    i += 2;
                }
                int currentRunLength = i - currentRunOffset;
                if (currentRunLength <= longestRunLength) continue;
                longestRunOffset = currentRunOffset;
                longestRunLength = currentRunLength;
            }
            Buffer result = new Buffer();
            int i = 0;
            while (i < address.length) {
                if (i == longestRunOffset) {
                    result.writeByte(58);
                    if ((i += longestRunLength) != 16) continue;
                    result.writeByte(58);
                    continue;
                }
                if (i > 0) {
                    result.writeByte(58);
                }
                int group = (address[i] & 0xFF) << 8 | address[i + 1] & 0xFF;
                result.writeHexadecimalUnsignedLong((long)group);
                i += 2;
            }
            return result.readUtf8();
        }

        private static int parsePort(String input, int pos, int limit) {
            try {
                String portString = DeepLinkUri.canonicalize(input, pos, limit, DeepLinkUri.FRAGMENT_ENCODE_SET, false, false);
                int i = Integer.parseInt(portString);
                if (i > 0 && i <= 65535) {
                    return i;
                }
                return -1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        static enum ParseResult {
            SUCCESS,
            MISSING_SCHEME,
            UNSUPPORTED_SCHEME,
            INVALID_PORT,
            INVALID_HOST;

        }
    }
}

