/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClientConfiguration;
import com.algolia.search.ApacheHttpClient;
import com.algolia.search.ApacheHttpClientConfiguration;
import com.algolia.search.AsyncAPIClientConfiguration;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.http.AlgoliaRequest;
import com.algolia.search.http.AsyncAlgoliaHttpClient;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import net.javacrumbs.futureconverter.java8guava.FutureConverter;

class AsyncHttpClient
extends AsyncAlgoliaHttpClient {
    private final ApacheHttpClient internal;
    private final ListeningExecutorService service;

    AsyncHttpClient(AsyncAPIClientConfiguration configuration) {
        this.service = MoreExecutors.listeningDecorator((ExecutorService)configuration.getExecutorService());
        this.internal = new ApacheHttpClient((APIClientConfiguration)configuration, new ApacheHttpClientConfiguration());
    }

    public <T> CompletableFuture<T> requestWithRetry(@Nonnull AlgoliaRequest<T> request) {
        return FutureConverter.toCompletableFuture((ListenableFuture)this.service.submit(() -> this.internal.requestWithRetry(request)));
    }

    public <T> CompletableFuture<T> requestAnalytics(@Nonnull AlgoliaRequest<T> request) {
        return FutureConverter.toCompletableFuture((ListenableFuture)this.service.submit(() -> this.internal.requestAnalytics(request)));
    }

    public <T> CompletableFuture<T> requestInsights(@Nonnull AlgoliaRequest<T> request, @Nonnull String host) {
        return FutureConverter.toCompletableFuture((ListenableFuture)this.service.submit(() -> this.internal.requestInsights(request, host)));
    }

    public void close() throws AlgoliaException {
        this.internal.close();
    }
}

