/** A/B Testing API The Algolia A/B Testing API lets you manage your Algolia A/B tests to optimize your search
  * experience. ## Base URLs The base URLs for requests to the A/B testing API are: - `https://analytics.us.algolia.com`
  * (alias: `https://analytics.algolia.com`) - `https://analytics.de.algolia.com` Use the URL that matches your
  * [analytics region](https://dashboard.algolia.com/account/infrastructure/analytics). **All requests must use HTTPS.**
  * ## Availability and authentication Access to the A/B testing API is available as part of the [Premium or Elevate
  * plans](https://www.algolia.com/pricing). To authenticate your API requests, add these headers: -
  * `x-algolia-application-id`. Your Algolia application ID. - `x-algolia-api-key`. An API key with the necessary
  * permissions to make the request. The required access control list (ACL) to make a request is listed in each
  * endpoint's reference. You can find your application ID and API key in the [Algolia
  * dashboard](https://dashboard.algolia.com/account). ## Rate limits You can make up to **100 requests per minute per
  * app** to the A/B testing API. The response includes headers with information about the limits. ## Parameters Query
  * parameters must be [URL-encoded](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). Non-ASCII
  * characters must be UTF-8 encoded. Plus characters (`+`) are interpreted as spaces. ## Response status and errors The
  * A/B testing API returns JSON responses. Since JSON doesn't guarantee any specific ordering, don't rely on the order
  * of attributes in the API response. Successful responses return a `2xx` status. Client errors return a `4xx` status.
  * Server errors are indicated by a `5xx` status. Error responses have a `message` property with more information. ##
  * Version The current version of the A/B Testing API is version 2, as indicated by the `/2/` in each endpoint's URL.
  *
  * The version of the OpenAPI document: 2.0.0
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
  * https://openapi-generator.tech Do not edit the class manually.
  */
package algoliasearch.abtesting

import org.json4s.MonadicJValue.jvalueToMonadic
import org.json4s.{Extraction, Formats, JField, JObject, JValue, Serializer, TypeInfo}

/** Error.
  */
case class ErrorBase(
    message: Option[String] = scala.None,
    additionalProperties: Option[List[JField]] = None
)

class ErrorBaseSerializer extends Serializer[ErrorBase] {

  override def deserialize(implicit format: Formats): PartialFunction[(TypeInfo, JValue), ErrorBase] = {
    case (TypeInfo(clazz, _), json) if clazz == classOf[ErrorBase] =>
      json match {
        case jobject: JObject =>
          val formats = format - this
          val mf = manifest[ErrorBase]
          val obj = Extraction.extract[ErrorBase](jobject)(formats, mf)

          val fields = Set("message")
          val additionalProperties = jobject removeField {
            case (name, _) if fields.contains(name) => true
            case _                                  => false
          }
          additionalProperties.values match {
            case JObject(fieldsList) => obj copy (additionalProperties = Some(fieldsList))
            case _                   => obj
          }
        case _ => throw new IllegalArgumentException(s"Can't deserialize $json as ErrorBase")
      }
  }

  override def serialize(implicit format: Formats): PartialFunction[Any, JValue] = { case value: ErrorBase =>
    val formats = format - this // remove current serializer from formats to avoid stackoverflow
    value.additionalProperties match {
      case Some(fields) => Extraction.decompose(value.copy(additionalProperties = None))(formats) merge JObject(fields)
      case None         => Extraction.decompose(value)(formats)
    }
  }
}
