/** Usage API The Usage API gives you access to statistics about all requests made to your Algolia applications. ## Base
  * URL The base URL for requests to the Usage API is: - `https://usage.algolia.com` **All requests must use HTTPS.** ##
  * Authentication To authenticate your API requests, add these headers: - `x-algolia-application-id`. Your Algolia
  * application ID. - `x-algolia-api-key`. The Usage API key. You can find your application ID and Usage API key in the
  * [Algolia dashboard](https://dashboard.algolia.com/account). ## Response status and errors The Usage API returns JSON
  * responses. Since JSON doesn't guarantee any specific ordering, don't rely on the order of attributes in the API
  * response. Successful responses return a `2xx` status. Client errors return a `4xx` status. Server errors are
  * indicated by a `5xx` status. Error responses have a `message` property with more information. ## Version The current
  * version of the Usage API is version 1, as indicated by the `/1/` in each endpoint's URL.
  *
  * The version of the OpenAPI document: 1.0.0
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
  * https://openapi-generator.tech Do not edit the class manually.
  */
package algoliasearch.usage

import org.json4s._

sealed trait Granularity

/** Granularity enumeration
  */
object Granularity {
  case object Hourly extends Granularity {
    override def toString = "hourly"
  }
  case object Daily extends Granularity {
    override def toString = "daily"
  }
  val values: Seq[Granularity] = Seq(Hourly, Daily)

  def withName(name: String): Granularity = Granularity.values
    .find(_.toString == name)
    .getOrElse(throw new MappingException(s"Unknown Granularity value: $name"))
}

class GranularitySerializer
    extends CustomSerializer[Granularity](_ =>
      (
        {
          case JString(value) => Granularity.withName(value)
          case JNull          => null
        },
        { case value: Granularity =>
          JString(value.toString)
        }
      )
    )
