/** Usage API The Usage API gives you access to statistics about all requests made to your Algolia applications. ## Base
  * URL The base URL for requests to the Usage API is: - `https://usage.algolia.com` **All requests must use HTTPS.** ##
  * Authentication To authenticate your API requests, add these headers: - `x-algolia-application-id`. Your Algolia
  * application ID. - `x-algolia-api-key`. The Usage API key. You can find your application ID and Usage API key in the
  * [Algolia dashboard](https://dashboard.algolia.com/account). ## Response status and errors The Usage API returns JSON
  * responses. Since JSON doesn't guarantee any specific ordering, don't rely on the order of attributes in the API
  * response. Successful responses return a `2xx` status. Client errors return a `4xx` status. Server errors are
  * indicated by a `5xx` status. Error responses have a `message` property with more information. ## Version The current
  * version of the Usage API is version 1, as indicated by the `/1/` in each endpoint's URL.
  *
  * The version of the OpenAPI document: 1.0.0
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
  * https://openapi-generator.tech Do not edit the class manually.
  */
package algoliasearch.usage

import org.json4s._

/** StatisticValue
  */
sealed trait StatisticValue

object StatisticValue {

  case class IntValue(value: Int) extends StatisticValue
  case class MapOfStringInt(value: Map[String, Int]) extends StatisticValue

  def apply(value: Int): StatisticValue = {
    StatisticValue.IntValue(value)
  }
  def apply(value: Map[String, Int]): StatisticValue = {
    StatisticValue.MapOfStringInt(value)
  }

}

object StatisticValueSerializer extends Serializer[StatisticValue] {
  override def deserialize(implicit format: Formats): PartialFunction[(TypeInfo, JValue), StatisticValue] = {

    case (TypeInfo(clazz, _), json) if clazz == classOf[StatisticValue] =>
      json match {
        case JInt(value)    => StatisticValue.IntValue(value.toInt)
        case value: JObject => StatisticValue.apply(Extraction.extract[Map[String, Int]](value))
        case _              => throw new MappingException("Can't convert " + json + " to StatisticValue")
      }
  }

  override def serialize(implicit format: Formats): PartialFunction[Any, JValue] = { case value: StatisticValue =>
    value match {
      case StatisticValue.IntValue(value) => JInt(value)
    }
  }
}
