/** Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on
  * https://github.com/algolia/api-clients-automation. DO NOT EDIT.
  */
package algoliasearch.api

import algoliasearch.personalization.DeleteUserProfileResponse
import algoliasearch.personalization.ErrorBase
import algoliasearch.personalization.GetUserTokenResponse
import algoliasearch.personalization.PersonalizationStrategyParams
import algoliasearch.personalization.SetPersonalizationStrategyResponse
import algoliasearch.personalization._
import algoliasearch.ApiClient
import algoliasearch.api.PersonalizationClient.hosts
import algoliasearch.config._
import algoliasearch.internal.util._

import scala.concurrent.{ExecutionContext, Future}
import scala.util.Random

object PersonalizationClient {

  /** Creates a new SearchApi instance using default hosts.
    *
    * @param appId
    *   application ID
    * @param apiKey
    *   api key
    * @param region
    *   region
    * @param clientOptions
    *   client options
    */
  def apply(
      appId: String,
      apiKey: String,
      region: String,
      clientOptions: ClientOptions = ClientOptions()
  ) = new PersonalizationClient(
    appId = appId,
    apiKey = apiKey,
    region = region,
    clientOptions = clientOptions
  )

  private def hosts(region: String): Seq[Host] = {
    val allowedRegions = Seq("eu", "us")
    if (!allowedRegions.contains(region)) {
      throw new IllegalArgumentException(
        s"`region` is required and must be one of the following: ${allowedRegions.mkString(", ")}"
      )
    }
    val url = "personalization.{region}.algolia.com".replace("{region}", region)
    Seq(Host(url = url, callTypes = Set(CallType.Read, CallType.Write)))
  }
}

class PersonalizationClient(
    appId: String,
    apiKey: String,
    region: String,
    clientOptions: ClientOptions = ClientOptions()
) extends ApiClient(
      appId = appId,
      apiKey = apiKey,
      clientName = "Personalization",
      defaultHosts = hosts(region),
      formats = JsonSupport.format,
      options = clientOptions
    ) {

  /** This method allow you to send requests to the Algolia REST API.
    *
    * @param path
    *   Path of the endpoint, anything after \"/1\" must be specified.
    * @param parameters
    *   Query parameters to apply to the current query.
    */
  def customDelete[T: Manifest](
      path: String,
      parameters: Option[Map[String, Any]] = None,
      requestOptions: Option[RequestOptions] = None
  )(implicit ec: ExecutionContext): Future[T] = Future {
    requireNotNull(path, "Parameter `path` is required when calling `customDelete`.")

    val request = HttpRequest
      .builder()
      .withMethod("DELETE")
      .withPath(s"/${path}")
      .withQueryParameters(parameters)
      .build()
    execute[T](request, requestOptions)
  }

  /** This method allow you to send requests to the Algolia REST API.
    *
    * @param path
    *   Path of the endpoint, anything after \"/1\" must be specified.
    * @param parameters
    *   Query parameters to apply to the current query.
    */
  def customGet[T: Manifest](
      path: String,
      parameters: Option[Map[String, Any]] = None,
      requestOptions: Option[RequestOptions] = None
  )(implicit ec: ExecutionContext): Future[T] = Future {
    requireNotNull(path, "Parameter `path` is required when calling `customGet`.")

    val request = HttpRequest
      .builder()
      .withMethod("GET")
      .withPath(s"/${path}")
      .withQueryParameters(parameters)
      .build()
    execute[T](request, requestOptions)
  }

  /** This method allow you to send requests to the Algolia REST API.
    *
    * @param path
    *   Path of the endpoint, anything after \"/1\" must be specified.
    * @param parameters
    *   Query parameters to apply to the current query.
    * @param body
    *   Parameters to send with the custom request.
    */
  def customPost[T: Manifest](
      path: String,
      parameters: Option[Map[String, Any]] = None,
      body: Option[Any] = None,
      requestOptions: Option[RequestOptions] = None
  )(implicit ec: ExecutionContext): Future[T] = Future {
    requireNotNull(path, "Parameter `path` is required when calling `customPost`.")

    val request = HttpRequest
      .builder()
      .withMethod("POST")
      .withPath(s"/${path}")
      .withBody(body)
      .withQueryParameters(parameters)
      .build()
    execute[T](request, requestOptions)
  }

  /** This method allow you to send requests to the Algolia REST API.
    *
    * @param path
    *   Path of the endpoint, anything after \"/1\" must be specified.
    * @param parameters
    *   Query parameters to apply to the current query.
    * @param body
    *   Parameters to send with the custom request.
    */
  def customPut[T: Manifest](
      path: String,
      parameters: Option[Map[String, Any]] = None,
      body: Option[Any] = None,
      requestOptions: Option[RequestOptions] = None
  )(implicit ec: ExecutionContext): Future[T] = Future {
    requireNotNull(path, "Parameter `path` is required when calling `customPut`.")

    val request = HttpRequest
      .builder()
      .withMethod("PUT")
      .withPath(s"/${path}")
      .withBody(body)
      .withQueryParameters(parameters)
      .build()
    execute[T](request, requestOptions)
  }

  /** Deletes a user profile. The response includes a date and time when the user profile can safely be considered
    * deleted.
    *
    * Required API Key ACLs:
    *   - recommendation
    *
    * @param userToken
    *   Unique identifier representing a user for which to fetch the personalization profile.
    */
  def deleteUserProfile(userToken: String, requestOptions: Option[RequestOptions] = None)(implicit
      ec: ExecutionContext
  ): Future[DeleteUserProfileResponse] = Future {
    requireNotNull(userToken, "Parameter `userToken` is required when calling `deleteUserProfile`.")

    val request = HttpRequest
      .builder()
      .withMethod("DELETE")
      .withPath(s"/1/profiles/${escape(userToken)}")
      .build()
    execute[DeleteUserProfileResponse](request, requestOptions)
  }

  /** Retrieves the current personalization strategy.
    *
    * Required API Key ACLs:
    *   - recommendation
    */
  def getPersonalizationStrategy(
      requestOptions: Option[RequestOptions] = None
  )(implicit ec: ExecutionContext): Future[PersonalizationStrategyParams] = Future {

    val request = HttpRequest
      .builder()
      .withMethod("GET")
      .withPath(s"/1/strategies/personalization")
      .build()
    execute[PersonalizationStrategyParams](request, requestOptions)
  }

  /** Retrieves a user profile and their affinities for different facets.
    *
    * Required API Key ACLs:
    *   - recommendation
    *
    * @param userToken
    *   Unique identifier representing a user for which to fetch the personalization profile.
    */
  def getUserTokenProfile(userToken: String, requestOptions: Option[RequestOptions] = None)(implicit
      ec: ExecutionContext
  ): Future[GetUserTokenResponse] = Future {
    requireNotNull(userToken, "Parameter `userToken` is required when calling `getUserTokenProfile`.")

    val request = HttpRequest
      .builder()
      .withMethod("GET")
      .withPath(s"/1/profiles/personalization/${escape(userToken)}")
      .build()
    execute[GetUserTokenResponse](request, requestOptions)
  }

  /** Creates a new personalization strategy.
    *
    * Required API Key ACLs:
    *   - recommendation
    */
  def setPersonalizationStrategy(
      personalizationStrategyParams: PersonalizationStrategyParams,
      requestOptions: Option[RequestOptions] = None
  )(implicit ec: ExecutionContext): Future[SetPersonalizationStrategyResponse] = Future {
    requireNotNull(
      personalizationStrategyParams,
      "Parameter `personalizationStrategyParams` is required when calling `setPersonalizationStrategy`."
    )

    val request = HttpRequest
      .builder()
      .withMethod("POST")
      .withPath(s"/1/strategies/personalization")
      .withBody(personalizationStrategyParams)
      .build()
    execute[SetPersonalizationStrategyResponse](request, requestOptions)
  }

}
