/** Search API The Algolia Search API lets you search, configure, and manage your indices and records. ## Client
  * libraries Use Algolia's API clients and libraries to reliably integrate Algolia's APIs with your apps. The official
  * API clients are covered by Algolia's [Service Level Agreement](https://www.algolia.com/policies/sla/). See:
  * [Algolia's ecosystem](https://www.algolia.com/doc/guides/getting-started/how-algolia-works/in-depth/ecosystem/) ##
  * Base URLs The base URLs for requests to the Search API are: - `https://{APPLICATION_ID}.algolia.net` -
  * `https://{APPLICATION_ID}-dsn.algolia.net`. If your subscription includes a [Distributed Search
  * Network](https://dashboard.algolia.com/infra), this ensures that requests are sent to servers closest to users. Both
  * URLs provide high availability by distributing requests with load balancing. **All requests must use HTTPS.** ##
  * Retry strategy To guarantee high availability, implement a retry strategy for all API requests using the URLs of
  * your servers as fallbacks: - `https://{APPLICATION_ID}-1.algolianet.com` -
  * `https://{APPLICATION_ID}-2.algolianet.com` - `https://{APPLICATION_ID}-3.algolianet.com` These URLs use a different
  * DNS provider than the primary URLs. You should randomize this list to ensure an even load across the three servers.
  * All Algolia API clients implement this retry strategy. ## Authentication To authenticate your API requests, add
  * these headers: - `x-algolia-application-id`. Your Algolia application ID. - `x-algolia-api-key`. An API key with the
  * necessary permissions to make the request. The required access control list (ACL) to make a request is listed in
  * each endpoint's reference. You can find your application ID and API key in the [Algolia
  * dashboard](https://dashboard.algolia.com/account). ## Request format Depending on the endpoint, request bodies are
  * either JSON objects or arrays of JSON objects, ## Parameters Parameters are passed as query parameters for GET and
  * DELETE requests, and in the request body for POST and PUT requests. Query parameters must be
  * [URL-encoded](https://developer.mozilla.org/en-US/docs/Glossary/Percent-encoding). Non-ASCII characters must be
  * UTF-8 encoded. Plus characters (`+`) are interpreted as spaces. Arrays as query parameters must be one of: - A
  * comma-separated string: `attributesToRetrieve=title,description` - A URL-encoded JSON array:
  * `attributesToRetrieve=%5B%22title%22,%22description%22%D` ## Response status and errors The Search API returns JSON
  * responses. Since JSON doesn't guarantee any specific ordering, don't rely on the order of attributes in the API
  * response. Successful responses return a `2xx` status. Client errors return a `4xx` status. Server errors are
  * indicated by a `5xx` status. Error responses have a `message` property with more information. ## Version The current
  * version of the Search API is version 1, as indicated by the `/1/` in each endpoint's URL.
  *
  * The version of the OpenAPI document: 1.0.0
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
  * https://openapi-generator.tech Do not edit the class manually.
  */
package algoliasearch.search

import algoliasearch.search.SupportedLanguage._

/** BaseIndexSettings
  *
  * @param attributesForFaceting
  *   Attributes used for [faceting](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/).
  *   Facets are attributes that let you categorize search results. They can be used for filtering search results. By
  *   default, no attribute is used for faceting. Attribute names are case-sensitive. **Modifiers** -
  *   `filterOnly(\"ATTRIBUTE\")`. Allows the attribute to be used as a filter but doesn't evaluate the facet values. -
  *   `searchable(\"ATTRIBUTE\")`. Allows searching for facet values. - `afterDistinct(\"ATTRIBUTE\")`. Evaluates the
  *   facet count _after_ deduplication with `distinct`. This ensures accurate facet counts. You can apply this modifier
  *   to searchable facets: `afterDistinct(searchable(ATTRIBUTE))`.
  * @param replicas
  *   Creates [replica
  *   indices](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/replicas/). Replicas
  *   are copies of a primary index with the same records but different settings, synonyms, or rules. If you want to
  *   offer a different ranking or sorting of your search results, you'll use replica indices. All index operations on a
  *   primary index are automatically forwarded to its replicas. To add a replica index, you must provide the complete
  *   set of replicas to this parameter. If you omit a replica from this list, the replica turns into a regular,
  *   standalone index that will no longer be synced with the primary index. **Modifier** - `virtual(\"REPLICA\")`.
  *   Create a virtual replica, Virtual replicas don't increase the number of records and are optimized for [Relevant
  *   sorting](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/relevant-sort/).
  * @param paginationLimitedTo
  *   Maximum number of search results that can be obtained through pagination. Higher pagination limits might slow down
  *   your search. For pagination limits above 1,000, the sorting of results beyond the 1,000th hit can't be guaranteed.
  * @param unretrievableAttributes
  *   Attributes that can't be retrieved at query time. This can be useful if you want to use an attribute for ranking
  *   or to [restrict
  *   access](https://www.algolia.com/doc/guides/security/api-keys/how-to/user-restricted-access-to-data/), but don't
  *   want to include it in the search results. Attribute names are case-sensitive.
  * @param disableTypoToleranceOnWords
  *   Creates a list of [words which require exact
  *   matches](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#turn-off-typo-tolerance-for-certain-words).
  *   This also turns off [word splitting and
  *   concatenation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/splitting-and-concatenation/)
  *   for the specified words.
  * @param attributesToTransliterate
  *   Attributes, for which you want to support [Japanese
  *   transliteration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/#japanese-transliteration-and-type-ahead).
  *   Transliteration supports searching in any of the Japanese writing systems. To support transliteration, you must
  *   set the indexing language to Japanese. Attribute names are case-sensitive.
  * @param camelCaseAttributes
  *   Attributes for which to split [camel case](https://wikipedia.org/wiki/Camel_case) words. Attribute names are
  *   case-sensitive.
  * @param decompoundedAttributes
  *   Searchable attributes to which Algolia should apply [word
  *   segmentation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
  *   (decompounding). Attribute names are case-sensitive. Compound words are formed by combining two or more individual
  *   words, and are particularly prevalent in Germanic languages—for example, \"firefighter\". With decompounding, the
  *   individual components are indexed separately. You can specify different lists for different languages.
  *   Decompounding is supported for these languages: Dutch (`nl`), German (`de`), Finnish (`fi`), Danish (`da`),
  *   Swedish (`sv`), and Norwegian (`no`). Decompounding doesn't work for words with [non-spacing mark Unicode
  *   characters](https://www.charactercodes.net/category/non-spacing_mark). For example, `Gartenstühle` won't be
  *   decompounded if the `ü` consists of `u` (U+0075) and `◌̈` (U+0308).
  * @param indexLanguages
  *   Languages for language-specific processing steps, such as word detection and dictionary settings. **You should
  *   always specify an indexing language.** If you don't specify an indexing language, the search engine uses all
  *   [supported
  *   languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/),
  *   or the languages you specified with the `ignorePlurals` or `removeStopWords` parameters. This can lead to
  *   unexpected search results. For more information, see [Language-specific
  *   configuration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/).
  * @param disablePrefixOnAttributes
  *   Searchable attributes for which you want to turn off [prefix
  *   matching](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/#adjusting-prefix-search).
  *   Attribute names are case-sensitive.
  * @param allowCompressionOfIntegerArray
  *   Whether arrays with exclusively non-negative integers should be compressed for better performance. If true, the
  *   compressed arrays may be reordered.
  * @param numericAttributesForFiltering
  *   Numeric attributes that can be used as [numerical
  *   filters](https://www.algolia.com/doc/guides/managing-results/rules/detecting-intent/how-to/applying-a-custom-filter-for-a-specific-query/#numerical-filters).
  *   Attribute names are case-sensitive. By default, all numeric attributes are available as numerical filters. For
  *   faster indexing, reduce the number of numeric attributes. To turn off filtering for all numeric attributes,
  *   specify an attribute that doesn't exist in your index, such as `NO_NUMERIC_FILTERING`. **Modifier** -
  *   `equalOnly(\"ATTRIBUTE\")`. Support only filtering based on equality comparisons `=` and `!=`.
  * @param separatorsToIndex
  *   Control which non-alphanumeric characters are indexed. By default, Algolia ignores [non-alphanumeric
  *   characters](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/how-to/how-to-search-in-hyphenated-attributes/#handling-non-alphanumeric-characters)
  *   like hyphen (`-`), plus (`+`), and parentheses (`(`,`)`). To include such characters, define them with
  *   `separatorsToIndex`. Separators are all non-letter characters except spaces and currency characters, such as $€£¥.
  *   With `separatorsToIndex`, Algolia treats separator characters as separate words. For example, in a search for
  *   \"Disney+\", Algolia considers \"Disney\" and \"+\" as two separate words.
  * @param searchableAttributes
  *   Attributes used for searching. Attribute names are case-sensitive. By default, all attributes are searchable and
  *   the
  *   [Attribute](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#attribute)
  *   ranking criterion is turned off. With a non-empty list, Algolia only returns results with matches in the selected
  *   attributes. In addition, the Attribute ranking criterion is turned on: matches in attributes that are higher in
  *   the list of `searchableAttributes` rank first. To make matches in two attributes rank equally, include them in a
  *   comma-separated string, such as `\"title,alternate_title\"`. Attributes with the same priority are always
  *   unordered. For more information, see [Searchable
  *   attributes](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/setting-searchable-attributes/).
  *   **Modifier** - `unordered(\"ATTRIBUTE\")`. Ignore the position of a match within the attribute. Without a
  *   modifier, matches at the beginning of an attribute rank higher than matches at the end.
  * @param userData
  *   An object with custom data. You can store up to 32kB as custom data.
  * @param customNormalization
  *   Characters and their normalized replacements. This overrides Algolia's default
  *   [normalization](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/normalization/).
  * @param attributeForDistinct
  *   Attribute that should be used to establish groups of results. Attribute names are case-sensitive. All records with
  *   the same value for this attribute are considered a group. You can combine `attributeForDistinct` with the
  *   `distinct` search parameter to control how many items per group are included in the search results. If you want to
  *   use the same attribute also for faceting, use the `afterDistinct` modifier of the `attributesForFaceting` setting.
  *   This applies faceting _after_ deduplication, which will result in accurate facet counts.
  */
case class BaseIndexSettings(
    attributesForFaceting: Option[Seq[String]] = scala.None,
    replicas: Option[Seq[String]] = scala.None,
    paginationLimitedTo: Option[Int] = scala.None,
    unretrievableAttributes: Option[Seq[String]] = scala.None,
    disableTypoToleranceOnWords: Option[Seq[String]] = scala.None,
    attributesToTransliterate: Option[Seq[String]] = scala.None,
    camelCaseAttributes: Option[Seq[String]] = scala.None,
    decompoundedAttributes: Option[Any] = scala.None,
    indexLanguages: Option[Seq[SupportedLanguage]] = scala.None,
    disablePrefixOnAttributes: Option[Seq[String]] = scala.None,
    allowCompressionOfIntegerArray: Option[Boolean] = scala.None,
    numericAttributesForFiltering: Option[Seq[String]] = scala.None,
    separatorsToIndex: Option[String] = scala.None,
    searchableAttributes: Option[Seq[String]] = scala.None,
    userData: Option[Any] = scala.None,
    customNormalization: Option[Map[String, Map[String, String]]] = scala.None,
    attributeForDistinct: Option[String] = scala.None
)
