/*
 * Decompiled with CFR 0.152.
 */
package algoliasearch;

import algoliasearch.ApiClient$;
import algoliasearch.BuildInfo$;
import algoliasearch.config.AgentSegment$;
import algoliasearch.config.ClientOptions;
import algoliasearch.config.Host;
import algoliasearch.config.HttpRequest;
import algoliasearch.config.RequestOptions;
import algoliasearch.config.Requester;
import algoliasearch.exception.AlgoliaClientException$;
import algoliasearch.internal.AlgoliaAgent;
import algoliasearch.internal.AlgoliaAgent$;
import algoliasearch.internal.HttpRequester;
import algoliasearch.internal.HttpRequester$;
import algoliasearch.internal.StatefulHost;
import algoliasearch.internal.StatefulHost$;
import algoliasearch.internal.interceptor.AuthInterceptor;
import algoliasearch.internal.interceptor.RetryStrategy;
import algoliasearch.internal.interceptor.UserAgentInterceptor;
import java.io.Serializable;
import org.json4s.Formats;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.util.Try$;

public abstract class ApiClient
implements AutoCloseable {
    private final Formats formats;
    private final AuthInterceptor authInterceptor;
    private final Requester requester;

    public static ClientOptions $lessinit$greater$default$6() {
        return ApiClient$.MODULE$.$lessinit$greater$default$6();
    }

    public ApiClient(String appId, String apiKey, String clientName, Seq<Host> defaultHosts, Formats formats, ClientOptions options) {
        Requester requester;
        this.formats = formats;
        if (appId == null || appId.isEmpty()) {
            throw AlgoliaClientException$.MODULE$.apply("`appId` is missing.", AlgoliaClientException$.MODULE$.$lessinit$greater$default$2());
        }
        if (apiKey == null || apiKey.isEmpty()) {
            throw AlgoliaClientException$.MODULE$.apply("`apiKey` is missing.", AlgoliaClientException$.MODULE$.$lessinit$greater$default$2());
        }
        this.authInterceptor = new AuthInterceptor(appId, apiKey);
        Option<Requester> option = options.customRequester();
        if (option instanceof Some) {
            Requester customRequester;
            requester = customRequester = (Requester)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            requester = this.defaultRequester(appId, apiKey, clientName, options, defaultHosts);
        } else {
            throw new MatchError(option);
        }
        this.requester = requester;
    }

    private Requester defaultRequester(String appId, String apiKey, String clientName, ClientOptions options, Seq<Host> defaultHosts) {
        AlgoliaAgent algoliaAgent = AlgoliaAgent$.MODULE$.apply(BuildInfo$.MODULE$.version()).addSegment(AgentSegment$.MODULE$.apply(clientName, (Option<String>)Some$.MODULE$.apply((Object)BuildInfo$.MODULE$.version()))).addSegments(options.agentSegments());
        Seq<Host> hosts = options.hosts().isEmpty() ? defaultHosts : options.hosts();
        List statefulHosts = ((IterableOnceOps)hosts.map((Function1 & Serializable)host -> StatefulHost$.MODULE$.apply((Host)host))).toList();
        HttpRequester.Builder builder = HttpRequester$.MODULE$.builder((Formats)options.customFormats().getOrElse(this::$anonfun$2)).withInterceptor(this.authInterceptor).withInterceptor(new UserAgentInterceptor(algoliaAgent)).withInterceptor(new RetryStrategy((List<StatefulHost>)statefulHosts));
        options.requesterConfig().foreach((Function1 & Serializable)_$1 -> _$1.apply((Object)builder));
        return builder.build(options);
    }

    public <T> T execute(HttpRequest httpRequest, Option<RequestOptions> requestOptions, Manifest<T> evidence$1) {
        return this.requester.execute(httpRequest, requestOptions, evidence$1);
    }

    public <T> Option<RequestOptions> execute$default$2() {
        return None$.MODULE$;
    }

    @Override
    public void close() {
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.close$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public void setClientApiKey(String apiKey) {
        this.authInterceptor.setApiKey(apiKey);
    }

    private final Formats $anonfun$2() {
        return this.formats;
    }

    private final void close$$anonfun$1() {
        this.requester.close();
    }
}

