/*
 * Decompiled with CFR 0.152.
 */
package algoliasearch.extension.internal;

import algoliasearch.exception.AlgoliaWaitException$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;

public final class RetryUntil$
implements Serializable {
    private static final Function1<Object, Object> DEFAULT_DELAY;
    public static final RetryUntil$ MODULE$;

    private RetryUntil$() {
    }

    static {
        MODULE$ = new RetryUntil$();
        DEFAULT_DELAY = (JFunction1.mcJJ.sp & Serializable)retries -> Math.min(retries * 200L, 5000L);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RetryUntil$.class);
    }

    public Function1<Object, Object> DEFAULT_DELAY() {
        return DEFAULT_DELAY;
    }

    public <T> Future<T> retryUntil(Function0<Future<T>> retry, Function1<T, Object> until, int maxRetries, Function1<Object, Object> delay, ExecutionContext ec) {
        long initialDelay = delay.apply$mcJJ$sp(0L);
        return this.attempt$1(maxRetries, retry, until, delay, ec, 0, initialDelay);
    }

    public <T> Function1<Object, Object> retryUntil$default$4() {
        return this.DEFAULT_DELAY();
    }

    private <T> Future<T> after(long delay, Function0<Future<T>> block, ExecutionContext ec) {
        Promise promise = Promise$.MODULE$.apply();
        ec.execute(() -> {
            try {
                Thread.sleep(delay);
                ((Future)block.apply()).onComplete((Function1 & Serializable)result -> promise.complete(result), ec);
            }
            catch (InterruptedException e) {
                promise.failure((Throwable)e);
            }
        });
        return promise.future();
    }

    private final Future attempt$1$$anonfun$1$$anonfun$1(int retryCount$2, long nextDelay$1, int maxRetries$3, Function0 retry$3, Function1 until$3, Function1 delay$3, ExecutionContext ec$3) {
        return this.attempt$1(maxRetries$3, retry$3, until$3, delay$3, ec$3, retryCount$2 + 1, nextDelay$1);
    }

    private final Future attempt$1(int maxRetries$1, Function0 retry$1, Function1 until$1, Function1 delay$1, ExecutionContext ec$1, int retryCount, long currentDelay) {
        if (retryCount >= maxRetries$1) {
            return Future$.MODULE$.failed((Throwable)AlgoliaWaitException$.MODULE$.apply("The maximum number of retries exceeded."));
        }
        return ((Future)retry$1.apply()).flatMap((Function1 & Serializable)result -> {
            if (BoxesRunTime.unboxToBoolean((Object)until$1.apply(result))) {
                return Future$.MODULE$.successful(result);
            }
            long nextDelay = delay$1.apply$mcJJ$sp(currentDelay);
            return this.after(nextDelay, () -> this.attempt$1$$anonfun$1$$anonfun$1(retryCount, nextDelay, maxRetries$1, retry$1, until$1, delay$1, ec$1), ec$1);
        }, ec$1);
    }
}

