/*
 * Decompiled with CFR 0.152.
 */
package algoliasearch.extension;

import algoliasearch.api.SearchClient;
import algoliasearch.config.RequestOptions;
import algoliasearch.exception.AlgoliaApiException;
import algoliasearch.extension.internal.RetryUntil$;
import algoliasearch.extension.package$;
import algoliasearch.search.Action;
import algoliasearch.search.Action$AddObject$;
import algoliasearch.search.Action$DeleteObject$;
import algoliasearch.search.Action$PartialUpdateObject$;
import algoliasearch.search.Action$PartialUpdateObjectNoCreate$;
import algoliasearch.search.ApiKey;
import algoliasearch.search.ApiKeyOperation;
import algoliasearch.search.ApiKeyOperation$Add$;
import algoliasearch.search.ApiKeyOperation$Delete$;
import algoliasearch.search.ApiKeyOperation$Update$;
import algoliasearch.search.BatchRequest;
import algoliasearch.search.BatchResponse;
import algoliasearch.search.BatchWriteParams$;
import algoliasearch.search.GetApiKeyResponse;
import algoliasearch.search.OperationIndexParams$;
import algoliasearch.search.OperationType$Copy$;
import algoliasearch.search.OperationType$Move$;
import algoliasearch.search.ReplaceAllObjectsResponse;
import algoliasearch.search.ScopeType;
import algoliasearch.search.ScopeType$Rules$;
import algoliasearch.search.ScopeType$Settings$;
import algoliasearch.search.ScopeType$Synonyms$;
import algoliasearch.search.TaskStatus;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Random$;

public final class package {
    public static SearchClientExtensions SearchClientExtensions(SearchClient searchClient) {
        return package$.MODULE$.SearchClientExtensions(searchClient);
    }

    public static class SearchClientExtensions {
        private final SearchClient client;

        public SearchClientExtensions(SearchClient client) {
            this.client = client;
        }

        public SearchClient client() {
            return this.client;
        }

        public Future<Object> waitForApiKey(ApiKeyOperation operation, String key, Option<ApiKey> apiKey, int maxRetries, Function1<Object, Object> delay, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            ApiKeyOperation apiKeyOperation = operation;
            if (ApiKeyOperation$Add$.MODULE$.equals(apiKeyOperation)) {
                return package$.MODULE$.SearchClientExtensions(this.client()).waitKeyCreation(key, maxRetries, delay, requestOptions, ec);
            }
            if (ApiKeyOperation$Update$.MODULE$.equals(apiKeyOperation)) {
                return package$.MODULE$.SearchClientExtensions(this.client()).waitKeyUpdate(key, (ApiKey)apiKey.get(), maxRetries, delay, requestOptions, ec);
            }
            if (ApiKeyOperation$Delete$.MODULE$.equals(apiKeyOperation)) {
                return package$.MODULE$.SearchClientExtensions(this.client()).waitKeyDelete(key, maxRetries, delay, requestOptions, ec);
            }
            throw new MatchError((Object)apiKeyOperation);
        }

        public Option<ApiKey> waitForApiKey$default$3() {
            return None$.MODULE$;
        }

        public int waitForApiKey$default$4() {
            return 50;
        }

        public Function1<Object, Object> waitForApiKey$default$5() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public Option<RequestOptions> waitForApiKey$default$6() {
            return None$.MODULE$;
        }

        public Future<TaskStatus> waitTask(String indexName, long taskID, Function1<Object, Object> delay, int maxRetries, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return RetryUntil$.MODULE$.retryUntil((Function0 & Serializable)() -> this.client().getTask(indexName, taskID, requestOptions, ec).map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitTask$$anonfun$1$$anonfun$1, ec), package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitTask$$anonfun$2, maxRetries, delay, ec);
        }

        public Function1<Object, Object> waitTask$default$3() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public int waitTask$default$4() {
            return 50;
        }

        public Option<RequestOptions> waitTask$default$5() {
            return None$.MODULE$;
        }

        public Future<TaskStatus> waitAppTask(long taskID, Function1<Object, Object> delay, int maxRetries, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return RetryUntil$.MODULE$.retryUntil((Function0 & Serializable)() -> this.client().getAppTask(taskID, requestOptions, ec).map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitAppTask$$anonfun$1$$anonfun$1, ec), package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitAppTask$$anonfun$2, maxRetries, delay, ec);
        }

        public Function1<Object, Object> waitAppTask$default$2() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public int waitAppTask$default$3() {
            return 50;
        }

        public Option<RequestOptions> waitAppTask$default$4() {
            return None$.MODULE$;
        }

        public Future<GetApiKeyResponse> waitKeyUpdate(String key, ApiKey apiKey, int maxRetries, Function1<Object, Object> delay, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return RetryUntil$.MODULE$.retryUntil((Function0 & Serializable)() -> this.client().getApiKey(key, requestOptions, ec), arg_0 -> package$.algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyUpdate$$anonfun$2(apiKey, arg_0), maxRetries, delay, ec);
        }

        public int waitKeyUpdate$default$3() {
            return 50;
        }

        public Function1<Object, Object> waitKeyUpdate$default$4() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public Option<RequestOptions> waitKeyUpdate$default$5() {
            return None$.MODULE$;
        }

        public Future<GetApiKeyResponse> waitKeyCreation(String key, int maxRetries, Function1<Object, Object> delay, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return RetryUntil$.MODULE$.retryUntil((Function0 & Serializable)() -> this.client().getApiKey(key, requestOptions, ec).map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyCreation$$anonfun$1$$anonfun$1, ec).recover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    return None$.MODULE$;
                }
            }, ec), package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyCreation$$anonfun$2, maxRetries, delay, ec).map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyCreation$$anonfun$3, ec);
        }

        public int waitKeyCreation$default$2() {
            return 50;
        }

        public Function1<Object, Object> waitKeyCreation$default$3() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public Option<RequestOptions> waitKeyCreation$default$4() {
            return None$.MODULE$;
        }

        public Future<Object> waitKeyDelete(String key, int maxRetries, Function1<Object, Object> delay, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            RetryUntil$.MODULE$.retryUntil((Function0 & Serializable)() -> this.client().getApiKey(key, requestOptions, ec).map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyDelete$$anonfun$1$$anonfun$1, ec).recover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    AlgoliaApiException e;
                    Throwable throwable = x;
                    if (throwable instanceof AlgoliaApiException && (e = (AlgoliaApiException)throwable).httpErrorCode() == 404) {
                        return true;
                    }
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    AlgoliaApiException e;
                    Throwable throwable = x;
                    if (throwable instanceof AlgoliaApiException && (e = (AlgoliaApiException)throwable).httpErrorCode() == 404) {
                        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    return None$.MODULE$;
                }
            }, ec), package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyDelete$$anonfun$2, maxRetries, delay, ec);
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }

        public int waitKeyDelete$default$2() {
            return 50;
        }

        public Function1<Object, Object> waitKeyDelete$default$3() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public Option<RequestOptions> waitKeyDelete$default$4() {
            return None$.MODULE$;
        }

        public Future<Seq<BatchResponse>> chunkedBatch(String indexName, Seq<Object> objects, Action action, boolean waitForTasks, int batchSize, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            ObjectRef futures = ObjectRef.create((Object)((Seq)scala.package$.MODULE$.Seq().empty()));
            objects.grouped(batchSize).foreach((Function1)(JProcedure1 & Serializable)chunk -> {
                Seq requests = (Seq)chunk.map(arg_0 -> package$.algoliasearch$extension$package$SearchClientExtensions$$_$_$$anonfun$1(action, arg_0));
                Future<BatchResponse> future = this.client().batch(indexName, BatchWriteParams$.MODULE$.apply((Seq<BatchRequest>)requests), requestOptions, ec);
                futures$1.elem = (Seq)((Seq)futures$1.elem).$colon$plus(future);
            });
            Future responses = Future$.MODULE$.sequence((IterableOnce)((Seq)futures.elem), BuildFrom$.MODULE$.buildFromIterableOps(), ec);
            if (waitForTasks) {
                responses.foreach((Function1)(JProcedure1 & Serializable)tasks -> tasks.foreach((Function1 & Serializable)task -> {
                    SearchClientExtensions searchClientExtensions = package$.MODULE$.SearchClientExtensions(this.client());
                    return searchClientExtensions.waitTask(indexName, task.taskID(), searchClientExtensions.waitTask$default$3(), searchClientExtensions.waitTask$default$4(), requestOptions, ec);
                }), ec);
            }
            return responses;
        }

        public Action chunkedBatch$default$3() {
            return Action$AddObject$.MODULE$;
        }

        public int chunkedBatch$default$5() {
            return 1000;
        }

        public Option<RequestOptions> chunkedBatch$default$6() {
            return None$.MODULE$;
        }

        public Future<Seq<BatchResponse>> saveObjects(String indexName, Seq<Object> objects, boolean waitForTasks, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return this.chunkedBatch(indexName, objects, Action$AddObject$.MODULE$, waitForTasks, 1000, requestOptions, ec);
        }

        public boolean saveObjects$default$3() {
            return false;
        }

        public Option<RequestOptions> saveObjects$default$4() {
            return None$.MODULE$;
        }

        public Future<Seq<BatchResponse>> deleteObjects(String indexName, Seq<String> objectIDs, boolean waitForTasks, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return this.chunkedBatch(indexName, (Seq<Object>)((Seq)objectIDs.map((Function1 & Serializable)id -> new Object((String)id){
                private final String objectID;
                {
                    this.objectID = id$1;
                }

                public String objectID() {
                    return this.objectID;
                }
            })), Action$DeleteObject$.MODULE$, waitForTasks, 1000, requestOptions, ec);
        }

        public boolean deleteObjects$default$3() {
            return false;
        }

        public Option<RequestOptions> deleteObjects$default$4() {
            return None$.MODULE$;
        }

        public Future<Seq<BatchResponse>> partialUpdateObjects(String indexName, Seq<Object> objects, boolean createIfNotExists, boolean waitForTasks, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return this.chunkedBatch(indexName, objects, (Action)(createIfNotExists ? Action$PartialUpdateObject$.MODULE$ : Action$PartialUpdateObjectNoCreate$.MODULE$), waitForTasks, 1000, requestOptions, ec);
        }

        public boolean partialUpdateObjects$default$3() {
            return false;
        }

        public boolean partialUpdateObjects$default$4() {
            return false;
        }

        public Option<RequestOptions> partialUpdateObjects$default$5() {
            return None$.MODULE$;
        }

        public Future<ReplaceAllObjectsResponse> replaceAllObjects(String indexName, Seq<Object> objects, int batchSize, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            Seq requests = (Seq)objects.map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$_$$anonfun$2);
            String tmpIndexName = new StringBuilder(5).append(indexName).append("_tmp_").append(Random$.MODULE$.nextInt(100)).toString();
            return this.client().operationIndex(indexName, OperationIndexParams$.MODULE$.apply(OperationType$Copy$.MODULE$, tmpIndexName, (Option<Seq<ScopeType>>)Some$.MODULE$.apply((Object)((SeqOps)new .colon.colon((Object)ScopeType$Settings$.MODULE$, (List)new .colon.colon((Object)ScopeType$Rules$.MODULE$, (List)new .colon.colon((Object)ScopeType$Synonyms$.MODULE$, (List)Nil$.MODULE$)))))), requestOptions, ec).flatMap((Function1 & Serializable)copy -> this.chunkedBatch(tmpIndexName, objects, Action$AddObject$.MODULE$, true, batchSize, requestOptions, ec).flatMap((Function1 & Serializable)batchResponses -> {
                SearchClientExtensions searchClientExtensions = package$.MODULE$.SearchClientExtensions(this.client());
                return searchClientExtensions.waitTask(tmpIndexName, copy.taskID(), searchClientExtensions.waitTask$default$3(), searchClientExtensions.waitTask$default$4(), requestOptions, ec).flatMap((Function1 & Serializable)x$1 -> {
                    TaskStatus taskStatus = x$1;
                    return this.client().operationIndex(indexName, OperationIndexParams$.MODULE$.apply(OperationType$Copy$.MODULE$, tmpIndexName, (Option<Seq<ScopeType>>)Some$.MODULE$.apply((Object)((SeqOps)new .colon.colon((Object)ScopeType$Settings$.MODULE$, (List)new .colon.colon((Object)ScopeType$Rules$.MODULE$, (List)new .colon.colon((Object)ScopeType$Synonyms$.MODULE$, (List)Nil$.MODULE$)))))), requestOptions, ec).flatMap((Function1 & Serializable)copy -> {
                        SearchClientExtensions searchClientExtensions = package$.MODULE$.SearchClientExtensions(this.client());
                        return searchClientExtensions.waitTask(tmpIndexName, copy.taskID(), searchClientExtensions.waitTask$default$3(), searchClientExtensions.waitTask$default$4(), requestOptions, ec).flatMap((Function1 & Serializable)x$1 -> {
                            TaskStatus taskStatus = x$1;
                            return this.client().operationIndex(tmpIndexName, OperationIndexParams$.MODULE$.apply(OperationType$Move$.MODULE$, indexName, OperationIndexParams$.MODULE$.$lessinit$greater$default$3()), requestOptions, ec).flatMap((Function1 & Serializable)move -> {
                                SearchClientExtensions searchClientExtensions = package$.MODULE$.SearchClientExtensions(this.client());
                                return searchClientExtensions.waitTask(tmpIndexName, move.taskID(), searchClientExtensions.waitTask$default$3(), searchClientExtensions.waitTask$default$4(), requestOptions, ec).map(arg_0 -> package$.algoliasearch$extension$package$SearchClientExtensions$$_$replaceAllObjects$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(copy, batchResponses, move, arg_0), ec);
                            }, ec);
                        }, ec);
                    }, ec);
                }, ec);
            }, ec), ec);
        }

        public int replaceAllObjects$default$3() {
            return 1000;
        }

        public Option<RequestOptions> replaceAllObjects$default$4() {
            return None$.MODULE$;
        }

        public Future<Object> indexExists(String indexName, ExecutionContext ec) {
            Future future;
            try {
                future = this.client().getSettings(indexName, this.client().getSettings$default$2(), ec);
            }
            catch (Throwable throwable) {
                AlgoliaApiException apiError;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof AlgoliaApiException && (apiError = (AlgoliaApiException)throwable2).httpErrorCode() == 404) {
                    future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
                if (throwable2 != null) {
                    Throwable e = throwable2;
                    throw e;
                }
                throw throwable;
            }
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
    }
}

