/*
 * Decompiled with CFR 0.152.
 */
package algoliasearch.internal.interceptor;

import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AuthInterceptor
implements Interceptor {
    private final String applicationId;
    private String apiKey;
    private final String HeaderApplicationId;
    private final String HeaderApiKey;

    public AuthInterceptor(String applicationId, String apiKey) {
        this.applicationId = applicationId;
        this.apiKey = apiKey;
        this.HeaderApplicationId = "x-algolia-application-id";
        this.HeaderApiKey = "x-algolia-api-key";
    }

    private String apiKey() {
        return this.apiKey;
    }

    private void apiKey_$eq(String x$0) {
        this.apiKey = x$0;
    }

    public void setApiKey(String newApiKey) {
        this.apiKey_$eq(newApiKey);
    }

    public Response intercept(Interceptor.Chain chain) {
        Request originalRequest = chain.request();
        Request.Builder builder = originalRequest.newBuilder();
        Headers headers = originalRequest.headers();
        if (headers.get(this.HeaderApplicationId) == null) {
            builder.header(this.HeaderApplicationId, this.applicationId);
        }
        if (headers.get(this.HeaderApiKey) == null) {
            builder.header(this.HeaderApiKey, this.apiKey());
        }
        Request newRequest = builder.build();
        return chain.proceed(newRequest);
    }
}

