/*
 * Decompiled with CFR 0.152.
 */
package algoliasearch.extension;

import algoliasearch.api.SearchClient;
import algoliasearch.config.RequestOptions;
import algoliasearch.exception.AlgoliaApiException;
import algoliasearch.extension.internal.Iterable$;
import algoliasearch.extension.internal.RetryUntil$;
import algoliasearch.extension.package$;
import algoliasearch.search.Action;
import algoliasearch.search.Action$AddObject$;
import algoliasearch.search.Action$DeleteObject$;
import algoliasearch.search.Action$PartialUpdateObject$;
import algoliasearch.search.Action$PartialUpdateObjectNoCreate$;
import algoliasearch.search.AdvancedSyntaxFeatures;
import algoliasearch.search.AlternativesAsExact;
import algoliasearch.search.Anchoring;
import algoliasearch.search.ApiKey;
import algoliasearch.search.ApiKeyOperation;
import algoliasearch.search.ApiKeyOperation$Add$;
import algoliasearch.search.ApiKeyOperation$Delete$;
import algoliasearch.search.ApiKeyOperation$Update$;
import algoliasearch.search.AroundPrecision;
import algoliasearch.search.AroundRadius;
import algoliasearch.search.BatchRequest;
import algoliasearch.search.BatchResponse;
import algoliasearch.search.BatchWriteParams$;
import algoliasearch.search.BrowseParams;
import algoliasearch.search.BrowseParamsObject;
import algoliasearch.search.BrowseResponse;
import algoliasearch.search.Distinct;
import algoliasearch.search.ExactOnSingleWordQuery;
import algoliasearch.search.FacetFilters;
import algoliasearch.search.GetApiKeyResponse;
import algoliasearch.search.IgnorePlurals;
import algoliasearch.search.Mode;
import algoliasearch.search.NumericFilters;
import algoliasearch.search.OperationIndexParams$;
import algoliasearch.search.OperationType$Copy$;
import algoliasearch.search.OperationType$Move$;
import algoliasearch.search.OptionalFilters;
import algoliasearch.search.QueryType;
import algoliasearch.search.ReRankingApplyFilter;
import algoliasearch.search.RemoveStopWords;
import algoliasearch.search.RemoveWordsIfNoResults;
import algoliasearch.search.RenderingContent;
import algoliasearch.search.ReplaceAllObjectsResponse;
import algoliasearch.search.ScopeType;
import algoliasearch.search.ScopeType$Rules$;
import algoliasearch.search.ScopeType$Settings$;
import algoliasearch.search.ScopeType$Synonyms$;
import algoliasearch.search.SearchRulesParams;
import algoliasearch.search.SearchRulesResponse;
import algoliasearch.search.SearchSynonymsParams;
import algoliasearch.search.SearchSynonymsResponse;
import algoliasearch.search.SemanticSearch;
import algoliasearch.search.SupportedLanguage;
import algoliasearch.search.SynonymType;
import algoliasearch.search.TagFilters;
import algoliasearch.search.TaskStatus;
import algoliasearch.search.TypoTolerance;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.Random$;

public final class package {
    public static SearchClientExtensions SearchClientExtensions(SearchClient searchClient) {
        return package$.MODULE$.SearchClientExtensions(searchClient);
    }

    public static class SearchClientExtensions {
        private final SearchClient client;

        public SearchClientExtensions(SearchClient client) {
            this.client = client;
        }

        public SearchClient client() {
            return this.client;
        }

        public Future<Object> waitForApiKey(ApiKeyOperation operation, String key, Option<ApiKey> apiKey, int maxRetries, Function1<Object, Object> delay, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            ApiKeyOperation apiKeyOperation = operation;
            if (ApiKeyOperation$Add$.MODULE$.equals(apiKeyOperation)) {
                return package$.MODULE$.SearchClientExtensions(this.client()).waitKeyCreation(key, maxRetries, delay, requestOptions, ec);
            }
            if (ApiKeyOperation$Update$.MODULE$.equals(apiKeyOperation)) {
                return package$.MODULE$.SearchClientExtensions(this.client()).waitKeyUpdate(key, (ApiKey)apiKey.get(), maxRetries, delay, requestOptions, ec);
            }
            if (ApiKeyOperation$Delete$.MODULE$.equals(apiKeyOperation)) {
                return package$.MODULE$.SearchClientExtensions(this.client()).waitKeyDelete(key, maxRetries, delay, requestOptions, ec);
            }
            throw new MatchError((Object)apiKeyOperation);
        }

        public Option<ApiKey> waitForApiKey$default$3() {
            return None$.MODULE$;
        }

        public int waitForApiKey$default$4() {
            return 50;
        }

        public Function1<Object, Object> waitForApiKey$default$5() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public Option<RequestOptions> waitForApiKey$default$6() {
            return None$.MODULE$;
        }

        public Future<TaskStatus> waitTask(String indexName, long taskID, Function1<Object, Object> delay, int maxRetries, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return RetryUntil$.MODULE$.retryUntil((Function0 & Serializable)() -> this.client().getTask(indexName, taskID, requestOptions, ec).map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitTask$$anonfun$1$$anonfun$1, ec), package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitTask$$anonfun$2, maxRetries, delay, ec);
        }

        public Function1<Object, Object> waitTask$default$3() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public int waitTask$default$4() {
            return 50;
        }

        public Option<RequestOptions> waitTask$default$5() {
            return None$.MODULE$;
        }

        public Future<TaskStatus> waitAppTask(long taskID, Function1<Object, Object> delay, int maxRetries, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return RetryUntil$.MODULE$.retryUntil((Function0 & Serializable)() -> this.client().getAppTask(taskID, requestOptions, ec).map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitAppTask$$anonfun$1$$anonfun$1, ec), package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitAppTask$$anonfun$2, maxRetries, delay, ec);
        }

        public Function1<Object, Object> waitAppTask$default$2() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public int waitAppTask$default$3() {
            return 50;
        }

        public Option<RequestOptions> waitAppTask$default$4() {
            return None$.MODULE$;
        }

        public Future<GetApiKeyResponse> waitKeyUpdate(String key, ApiKey apiKey, int maxRetries, Function1<Object, Object> delay, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return RetryUntil$.MODULE$.retryUntil((Function0 & Serializable)() -> this.client().getApiKey(key, requestOptions, ec), arg_0 -> package$.algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyUpdate$$anonfun$2(apiKey, arg_0), maxRetries, delay, ec);
        }

        public int waitKeyUpdate$default$3() {
            return 50;
        }

        public Function1<Object, Object> waitKeyUpdate$default$4() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public Option<RequestOptions> waitKeyUpdate$default$5() {
            return None$.MODULE$;
        }

        public Future<GetApiKeyResponse> waitKeyCreation(String key, int maxRetries, Function1<Object, Object> delay, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return RetryUntil$.MODULE$.retryUntil((Function0 & Serializable)() -> this.client().getApiKey(key, requestOptions, ec).map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyCreation$$anonfun$1$$anonfun$1, ec).recover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    return None$.MODULE$;
                }
            }, ec), package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyCreation$$anonfun$2, maxRetries, delay, ec).map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyCreation$$anonfun$3, ec);
        }

        public int waitKeyCreation$default$2() {
            return 50;
        }

        public Function1<Object, Object> waitKeyCreation$default$3() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public Option<RequestOptions> waitKeyCreation$default$4() {
            return None$.MODULE$;
        }

        public Future<Object> waitKeyDelete(String key, int maxRetries, Function1<Object, Object> delay, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            RetryUntil$.MODULE$.retryUntil((Function0 & Serializable)() -> this.client().getApiKey(key, requestOptions, ec).map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyDelete$$anonfun$1$$anonfun$1, ec).recover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    AlgoliaApiException e;
                    Throwable throwable = x;
                    if (throwable instanceof AlgoliaApiException && (e = (AlgoliaApiException)throwable).httpErrorCode() == 404) {
                        return true;
                    }
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    AlgoliaApiException e;
                    Throwable throwable = x;
                    if (throwable instanceof AlgoliaApiException && (e = (AlgoliaApiException)throwable).httpErrorCode() == 404) {
                        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    return None$.MODULE$;
                }
            }, ec), package$::algoliasearch$extension$package$SearchClientExtensions$$_$waitKeyDelete$$anonfun$2, maxRetries, delay, ec);
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }

        public int waitKeyDelete$default$2() {
            return 50;
        }

        public Function1<Object, Object> waitKeyDelete$default$3() {
            return RetryUntil$.MODULE$.DEFAULT_DELAY();
        }

        public Option<RequestOptions> waitKeyDelete$default$4() {
            return None$.MODULE$;
        }

        public Future<Seq<BatchResponse>> chunkedBatch(String indexName, Seq<Object> objects, Action action, boolean waitForTasks, int batchSize, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            ObjectRef futures = ObjectRef.create((Object)((Seq)scala.package$.MODULE$.Seq().empty()));
            objects.grouped(batchSize).foreach((Function1)(JProcedure1 & Serializable)chunk -> {
                Seq requests = (Seq)chunk.map(arg_0 -> package$.algoliasearch$extension$package$SearchClientExtensions$$_$_$$anonfun$1(action, arg_0));
                Future<BatchResponse> future = this.client().batch(indexName, BatchWriteParams$.MODULE$.apply((Seq<BatchRequest>)requests), requestOptions, ec);
                futures$1.elem = (Seq)((Seq)futures$1.elem).$colon$plus(future);
            });
            Future responses = Future$.MODULE$.sequence((IterableOnce)((Seq)futures.elem), BuildFrom$.MODULE$.buildFromIterableOps(), ec);
            if (waitForTasks) {
                responses.foreach((Function1)(JProcedure1 & Serializable)tasks -> tasks.foreach((Function1 & Serializable)task -> {
                    SearchClientExtensions searchClientExtensions = package$.MODULE$.SearchClientExtensions(this.client());
                    return searchClientExtensions.waitTask(indexName, task.taskID(), searchClientExtensions.waitTask$default$3(), searchClientExtensions.waitTask$default$4(), requestOptions, ec);
                }), ec);
            }
            return responses;
        }

        public Action chunkedBatch$default$3() {
            return Action$AddObject$.MODULE$;
        }

        public int chunkedBatch$default$5() {
            return 1000;
        }

        public Option<RequestOptions> chunkedBatch$default$6() {
            return None$.MODULE$;
        }

        public Future<Seq<BatchResponse>> saveObjects(String indexName, Seq<Object> objects, boolean waitForTasks, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return this.chunkedBatch(indexName, objects, Action$AddObject$.MODULE$, waitForTasks, 1000, requestOptions, ec);
        }

        public boolean saveObjects$default$3() {
            return false;
        }

        public Option<RequestOptions> saveObjects$default$4() {
            return None$.MODULE$;
        }

        public Future<Seq<BatchResponse>> deleteObjects(String indexName, Seq<String> objectIDs, boolean waitForTasks, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return this.chunkedBatch(indexName, (Seq<Object>)((Seq)objectIDs.map((Function1 & Serializable)id -> new Object((String)id){
                private final String objectID;
                {
                    this.objectID = id$1;
                }

                public String objectID() {
                    return this.objectID;
                }
            })), Action$DeleteObject$.MODULE$, waitForTasks, 1000, requestOptions, ec);
        }

        public boolean deleteObjects$default$3() {
            return false;
        }

        public Option<RequestOptions> deleteObjects$default$4() {
            return None$.MODULE$;
        }

        public Future<Seq<BatchResponse>> partialUpdateObjects(String indexName, Seq<Object> objects, boolean createIfNotExists, boolean waitForTasks, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return this.chunkedBatch(indexName, objects, (Action)(createIfNotExists ? Action$PartialUpdateObject$.MODULE$ : Action$PartialUpdateObjectNoCreate$.MODULE$), waitForTasks, 1000, requestOptions, ec);
        }

        public boolean partialUpdateObjects$default$3() {
            return false;
        }

        public boolean partialUpdateObjects$default$4() {
            return false;
        }

        public Option<RequestOptions> partialUpdateObjects$default$5() {
            return None$.MODULE$;
        }

        public Future<ReplaceAllObjectsResponse> replaceAllObjects(String indexName, Seq<Object> objects, int batchSize, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            String tmpIndexName = new StringBuilder(5).append(indexName).append("_tmp_").append(Random$.MODULE$.nextInt(100)).toString();
            return this.client().operationIndex(indexName, OperationIndexParams$.MODULE$.apply(OperationType$Copy$.MODULE$, tmpIndexName, (Option<Seq<ScopeType>>)Some$.MODULE$.apply((Object)((SeqOps)new .colon.colon((Object)ScopeType$Settings$.MODULE$, (List)new .colon.colon((Object)ScopeType$Rules$.MODULE$, (List)new .colon.colon((Object)ScopeType$Synonyms$.MODULE$, (List)Nil$.MODULE$)))))), requestOptions, ec).flatMap((Function1 & Serializable)copy -> this.chunkedBatch(tmpIndexName, objects, Action$AddObject$.MODULE$, true, batchSize, requestOptions, ec).flatMap((Function1 & Serializable)batchResponses -> {
                SearchClientExtensions searchClientExtensions = package$.MODULE$.SearchClientExtensions(this.client());
                return searchClientExtensions.waitTask(tmpIndexName, copy.taskID(), searchClientExtensions.waitTask$default$3(), searchClientExtensions.waitTask$default$4(), requestOptions, ec).flatMap((Function1 & Serializable)x$1 -> {
                    TaskStatus taskStatus = x$1;
                    return this.client().operationIndex(indexName, OperationIndexParams$.MODULE$.apply(OperationType$Copy$.MODULE$, tmpIndexName, (Option<Seq<ScopeType>>)Some$.MODULE$.apply((Object)((SeqOps)new .colon.colon((Object)ScopeType$Settings$.MODULE$, (List)new .colon.colon((Object)ScopeType$Rules$.MODULE$, (List)new .colon.colon((Object)ScopeType$Synonyms$.MODULE$, (List)Nil$.MODULE$)))))), requestOptions, ec).flatMap((Function1 & Serializable)copy -> {
                        SearchClientExtensions searchClientExtensions = package$.MODULE$.SearchClientExtensions(this.client());
                        return searchClientExtensions.waitTask(tmpIndexName, copy.taskID(), searchClientExtensions.waitTask$default$3(), searchClientExtensions.waitTask$default$4(), requestOptions, ec).flatMap((Function1 & Serializable)x$1 -> {
                            TaskStatus taskStatus = x$1;
                            return this.client().operationIndex(tmpIndexName, OperationIndexParams$.MODULE$.apply(OperationType$Move$.MODULE$, indexName, OperationIndexParams$.MODULE$.$lessinit$greater$default$3()), requestOptions, ec).flatMap((Function1 & Serializable)move -> {
                                SearchClientExtensions searchClientExtensions = package$.MODULE$.SearchClientExtensions(this.client());
                                return searchClientExtensions.waitTask(tmpIndexName, move.taskID(), searchClientExtensions.waitTask$default$3(), searchClientExtensions.waitTask$default$4(), requestOptions, ec).map(arg_0 -> package$.algoliasearch$extension$package$SearchClientExtensions$$_$replaceAllObjects$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(copy, batchResponses, move, arg_0), ec);
                            }, ec);
                        }, ec);
                    }, ec);
                }, ec);
            }, ec), ec);
        }

        public int replaceAllObjects$default$3() {
            return 1000;
        }

        public Option<RequestOptions> replaceAllObjects$default$4() {
            return None$.MODULE$;
        }

        public Future<Object> indexExists(String indexName, ExecutionContext ec) {
            Future future;
            try {
                future = this.client().getSettings(indexName, this.client().getSettings$default$2(), ec);
            }
            catch (Throwable throwable) {
                AlgoliaApiException apiError;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof AlgoliaApiException && (apiError = (AlgoliaApiException)throwable2).httpErrorCode() == 404) {
                    future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
                }
                if (throwable2 != null) {
                    Throwable e = throwable2;
                    throw e;
                }
                throw throwable;
            }
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }

        public Future<BrowseResponse> browseObjects(String indexName, BrowseParamsObject browseParams, Function1<BrowseResponse, Object> validate, Function1<BrowseResponse, BoxedUnit> aggregator, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            return Iterable$.MODULE$.createIterable((Function1 & Serializable)previousResponse -> {
                Option option = previousResponse.flatMap(package$::algoliasearch$extension$package$SearchClientExtensions$$_$_$$anonfun$2);
                Option option2 = previousResponse.flatMap(package$::algoliasearch$extension$package$SearchClientExtensions$$_$_$$anonfun$3);
                Option<String> option3 = browseParams.copy$default$1();
                Option<String> option4 = browseParams.copy$default$2();
                Option<String> option5 = browseParams.copy$default$3();
                Option<FacetFilters> option6 = browseParams.copy$default$4();
                Option<OptionalFilters> option7 = browseParams.copy$default$5();
                Option<NumericFilters> option8 = browseParams.copy$default$6();
                Option<TagFilters> option9 = browseParams.copy$default$7();
                Option<Object> option10 = browseParams.copy$default$8();
                Option<Seq<String>> option11 = browseParams.copy$default$9();
                Option<Seq<String>> option12 = browseParams.copy$default$10();
                Option<Object> option13 = browseParams.copy$default$11();
                Option<Object> option14 = browseParams.copy$default$12();
                Option<Object> option15 = browseParams.copy$default$13();
                Option<Object> option16 = browseParams.copy$default$14();
                Option<String> option17 = browseParams.copy$default$15();
                Option<Object> option18 = browseParams.copy$default$16();
                Option<AroundRadius> option19 = browseParams.copy$default$17();
                Option<AroundPrecision> option20 = browseParams.copy$default$18();
                Option<Object> option21 = browseParams.copy$default$19();
                Option<Seq<Seq<Object>>> option22 = browseParams.copy$default$20();
                Option<Seq<Seq<Object>>> option23 = browseParams.copy$default$21();
                Option<Seq<SupportedLanguage>> option24 = browseParams.copy$default$22();
                Option<Seq<String>> option25 = browseParams.copy$default$23();
                Option<Object> option26 = browseParams.copy$default$24();
                Option<String> option27 = browseParams.copy$default$25();
                Option<Object> option28 = browseParams.copy$default$26();
                Option<Object> option29 = browseParams.copy$default$27();
                Option<Object> option30 = browseParams.copy$default$28();
                Option<Object> option31 = browseParams.copy$default$29();
                Option<Seq<String>> option32 = browseParams.copy$default$30();
                Option<Object> option33 = browseParams.copy$default$31();
                Option<Object> option34 = browseParams.copy$default$32();
                Option<Seq<String>> option35 = browseParams.copy$default$33();
                Option<Seq<String>> option36 = browseParams.copy$default$34();
                Option<Seq<String>> option37 = browseParams.copy$default$35();
                Option<Object> option38 = browseParams.copy$default$36();
                Option<Seq<String>> option39 = browseParams.copy$default$37();
                Option<Seq<String>> option40 = browseParams.copy$default$38();
                Option<String> option41 = browseParams.copy$default$39();
                Option<String> option42 = browseParams.copy$default$40();
                Option<String> option43 = browseParams.copy$default$41();
                Option<Object> option44 = browseParams.copy$default$42();
                Option<Object> option45 = browseParams.copy$default$44();
                Option<Object> option46 = browseParams.copy$default$45();
                Option<TypoTolerance> option47 = browseParams.copy$default$46();
                Option<Object> option48 = browseParams.copy$default$47();
                Option<Seq<String>> option49 = browseParams.copy$default$48();
                Option<IgnorePlurals> option50 = browseParams.copy$default$49();
                Option<RemoveStopWords> option51 = browseParams.copy$default$50();
                Option<String> option52 = browseParams.copy$default$51();
                Option<Seq<SupportedLanguage>> option53 = browseParams.copy$default$52();
                Option<Object> option54 = browseParams.copy$default$53();
                Option<Object> option55 = browseParams.copy$default$54();
                Option<Object> option56 = browseParams.copy$default$55();
                Option<QueryType> option57 = browseParams.copy$default$56();
                Option<RemoveWordsIfNoResults> option58 = browseParams.copy$default$57();
                Option<Mode> option59 = browseParams.copy$default$58();
                Option<SemanticSearch> option60 = browseParams.copy$default$59();
                Option<Object> option61 = browseParams.copy$default$60();
                Option<Seq<String>> option62 = browseParams.copy$default$61();
                Option<Seq<String>> option63 = browseParams.copy$default$62();
                Option<ExactOnSingleWordQuery> option64 = browseParams.copy$default$63();
                Option<Seq<AlternativesAsExact>> option65 = browseParams.copy$default$64();
                Option<Seq<AdvancedSyntaxFeatures>> option66 = browseParams.copy$default$65();
                Option<Distinct> option67 = browseParams.copy$default$66();
                Option<Object> option68 = browseParams.copy$default$67();
                Option<Object> option69 = browseParams.copy$default$68();
                Option<Seq<String>> option70 = browseParams.copy$default$69();
                Option<Object> option71 = browseParams.copy$default$70();
                Option<Object> option72 = browseParams.copy$default$71();
                Option<String> option73 = browseParams.copy$default$72();
                Option<Object> option74 = browseParams.copy$default$73();
                Option<RenderingContent> option75 = browseParams.copy$default$74();
                Option<Object> option76 = browseParams.copy$default$75();
                Option<ReRankingApplyFilter> option77 = browseParams.copy$default$76();
                return this.client().browse(indexName, (Option<BrowseParams>)Some$.MODULE$.apply((Object)browseParams.copy(option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, option15, option16, option17, option18, option19, option20, option21, option22, option23, option24, option25, option26, option27, option28, option29, option30, option31, option32, option33, option34, option35, option36, option37, option38, option39, option40, option41, option42, option43, option44, (Option<Object>)option, option45, option46, option47, option48, option49, option50, option51, option52, option53, option54, option55, option56, option57, option58, option59, option60, option61, option62, option63, option64, option65, option66, option67, option68, option69, option70, option71, option72, option73, option74, option75, option76, option77, (Option<String>)option2)), requestOptions, ec);
            }, validate, Some$.MODULE$.apply(aggregator), Iterable$.MODULE$.createIterable$default$4(), Iterable$.MODULE$.createIterable$default$5(), ec);
        }

        public Function1<BrowseResponse, Object> browseObjects$default$3() {
            return package$::algoliasearch$extension$package$SearchClientExtensions$$_$browseObjects$default$3$$anonfun$1;
        }

        public Option<RequestOptions> browseObjects$default$5() {
            return None$.MODULE$;
        }

        public Future<SearchRulesResponse> browseRules(String indexName, SearchRulesParams searchRulesParams, Option<Function1<SearchRulesResponse, Object>> validate, Function1<SearchRulesResponse, BoxedUnit> aggregator, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            int hitsPerPage = 1000;
            return Iterable$.MODULE$.createIterable((Function1 & Serializable)previousResponse -> {
                Option option = previousResponse.map(package$::algoliasearch$extension$package$SearchClientExtensions$$_$_$$anonfun$4).orElse(package$::algoliasearch$extension$package$SearchClientExtensions$$_$_$$anonfun$5);
                Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)hitsPerPage));
                Option<String> option2 = searchRulesParams.copy$default$1();
                Option<Anchoring> option3 = searchRulesParams.copy$default$2();
                Option<String> option4 = searchRulesParams.copy$default$3();
                Option<Object> option5 = searchRulesParams.copy$default$6();
                return this.client().searchRules(indexName, (Option<SearchRulesParams>)Some$.MODULE$.apply((Object)searchRulesParams.copy(option2, option3, option4, (Option<Object>)option, (Option<Object>)some, option5)), requestOptions, ec);
            }, (Function1)validate.getOrElse(() -> package$.algoliasearch$extension$package$SearchClientExtensions$$_$browseRules$$anonfun$2(hitsPerPage)), Some$.MODULE$.apply(aggregator), Iterable$.MODULE$.createIterable$default$4(), Iterable$.MODULE$.createIterable$default$5(), ec);
        }

        public Option<Function1<SearchRulesResponse, Object>> browseRules$default$3() {
            return None$.MODULE$;
        }

        public Option<RequestOptions> browseRules$default$5() {
            return None$.MODULE$;
        }

        public Future<SearchSynonymsResponse> browseSynonyms(String indexName, SearchSynonymsParams searchSynonymsParams, Option<Function1<SearchSynonymsResponse, Object>> validate, Function1<SearchSynonymsResponse, BoxedUnit> aggregator, Option<RequestOptions> requestOptions, ExecutionContext ec) {
            int hitsPerPage = 1000;
            IntRef page = IntRef.create((int)BoxesRunTime.unboxToInt((Object)searchSynonymsParams.page().getOrElse(package$::algoliasearch$extension$package$SearchClientExtensions$$_$_$$anonfun$6)));
            return Iterable$.MODULE$.createIterable((Function1 & Serializable)_$9 -> {
                Future<SearchSynonymsResponse> future;
                try {
                    Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)page$4.elem));
                    Some some2 = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)hitsPerPage));
                    Option<String> option = searchSynonymsParams.copy$default$1();
                    Option<SynonymType> option2 = searchSynonymsParams.copy$default$2();
                    future = this.client().searchSynonyms(indexName, (Option<SearchSynonymsParams>)Some$.MODULE$.apply((Object)searchSynonymsParams.copy(option, option2, (Option<Object>)some, (Option<Object>)some2)), requestOptions, ec);
                }
                finally {
                    ++page$4.elem;
                }
                return future;
            }, (Function1)validate.getOrElse(() -> package$.algoliasearch$extension$package$SearchClientExtensions$$_$browseSynonyms$$anonfun$2(hitsPerPage)), Some$.MODULE$.apply(aggregator), Iterable$.MODULE$.createIterable$default$4(), Iterable$.MODULE$.createIterable$default$5(), ec);
        }

        public Option<Function1<SearchSynonymsResponse, Object>> browseSynonyms$default$3() {
            return None$.MODULE$;
        }

        public Option<RequestOptions> browseSynonyms$default$5() {
            return None$.MODULE$;
        }
    }
}

