/*
 * Decompiled with CFR 0.152.
 */
package algoliasearch.internal;

import algoliasearch.config.ClientConfig;
import algoliasearch.config.CompressionType;
import algoliasearch.config.CompressionType$Gzip$;
import algoliasearch.config.HttpRequest;
import algoliasearch.config.Logging;
import algoliasearch.config.RequestOptions;
import algoliasearch.config.Requester;
import algoliasearch.exception.AlgoliaApiException$;
import algoliasearch.exception.AlgoliaClientException$;
import algoliasearch.internal.HttpRequester$;
import algoliasearch.internal.JsonSerializer;
import algoliasearch.internal.JsonSerializer$;
import algoliasearch.internal.interceptor.GzipRequestInterceptor;
import algoliasearch.internal.interceptor.HeaderInterceptor;
import algoliasearch.internal.interceptor.LogInterceptor;
import algoliasearch.internal.util.UseReadTransporter$;
import algoliasearch.internal.util.package$;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import org.json4s.Formats;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.Manifest;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class HttpRequester
implements Requester {
    private final OkHttpClient httpClient;
    public final JsonSerializer algoliasearch$internal$HttpRequester$$jsonSerializer;
    private final AtomicBoolean isClosed;

    public static Builder builder(Formats formats) {
        return HttpRequester$.MODULE$.builder(formats);
    }

    public HttpRequester(Builder builder, ClientConfig config) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout(config.connectTimeout().toMillis(), TimeUnit.MILLISECONDS).readTimeout(config.readTimeout().toMillis(), TimeUnit.MILLISECONDS).writeTimeout(config.writeTimeout().toMillis(), TimeUnit.MILLISECONDS).addInterceptor((Interceptor)new HeaderInterceptor(config.defaultHeaders()));
        config.logging().foreach((Function1 & Serializable)logging -> clientBuilder.addNetworkInterceptor((Interceptor)new LogInterceptor((Logging)logging)));
        builder.interceptors().foreach((Function1 & Serializable)x$0 -> clientBuilder.addInterceptor(x$0));
        builder.networkInterceptors().foreach((Function1 & Serializable)x$0 -> clientBuilder.addNetworkInterceptor(x$0));
        CompressionType compressionType = config.compressionType();
        CompressionType$Gzip$ compressionType$Gzip$ = CompressionType$Gzip$.MODULE$;
        if (!(compressionType != null ? !compressionType.equals(compressionType$Gzip$) : compressionType$Gzip$ != null)) {
            clientBuilder.addInterceptor((Interceptor)new GzipRequestInterceptor());
        }
        builder.clientConfig().foreach((Function1 & Serializable)_$1 -> _$1.apply((Object)clientBuilder));
        this.httpClient = clientBuilder.build();
        this.algoliasearch$internal$HttpRequester$$jsonSerializer = JsonSerializer$.MODULE$.apply(builder.formats());
        this.isClosed = new AtomicBoolean(false);
    }

    private HttpUrl createHttpUrl(HttpRequest request, Option<RequestOptions> requestOptions) {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("algolia.com").encodedPath(request.path());
        request.queryParameters().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return urlBuilder.addEncodedQueryParameter(package$.MODULE$.escape(key), package$.MODULE$.escape(value));
            }
            throw new MatchError((Object)tuple2);
        });
        if (requestOptions.isDefined()) {
            ((RequestOptions)requestOptions.get()).queryParameters().foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return urlBuilder.addEncodedQueryParameter(package$.MODULE$.escape(key), package$.MODULE$.escape(value));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return urlBuilder.build();
    }

    private Option<RequestOptions> createHttpUrl$default$2() {
        return None$.MODULE$;
    }

    private RequestBody createRequestBody(HttpRequest httpRequest) {
        Some body;
        String method;
        block5: {
            block4: {
                method = httpRequest.method();
                body = httpRequest.body();
                if (!HttpMethod.permitsRequestBody((String)method)) break block4;
                String string = method;
                String string2 = "DELETE";
                if ((string != null ? !string.equals(string2) : string2 != null) || !body.isEmpty()) break block5;
            }
            return null;
        }
        if (body.isEmpty()) {
            body = HttpMethod.requiresRequestBody((String)method) ? Some$.MODULE$.apply(Collections.emptyMap()) : Some$.MODULE$.apply((Object)"");
        }
        return this.buildRequestBody(body);
    }

    private RequestBody buildRequestBody(Object requestBody) {
        return new RequestBody(requestBody, this){
            private final Object requestBody$1;
            private final /* synthetic */ HttpRequester $outer;
            {
                this.requestBody$1 = requestBody$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public MediaType contentType() {
                return MediaType.parse((String)"application/json");
            }

            public void writeTo(BufferedSink bufferedSink) {
                this.$outer.algoliasearch$internal$HttpRequester$$jsonSerializer.serialize(bufferedSink.outputStream(), this.requestBody$1);
            }
        };
    }

    private Headers createHeaders(HttpRequest request, Option<RequestOptions> requestOptions) {
        Headers.Builder builder = new Headers.Builder();
        request.headers().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return builder.add(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        if (requestOptions.isDefined()) {
            ((RequestOptions)requestOptions.get()).headers().foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return builder.add(key, value);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return builder.build();
    }

    private OkHttpClient okHttpClient(Option<RequestOptions> requestOptions) {
        if (requestOptions == null) {
            return this.httpClient;
        }
        OkHttpClient.Builder builder = this.httpClient.newBuilder();
        requestOptions.foreach((Function1)(JProcedure1 & Serializable)options -> {
            options.readTimeout().foreach((Function1 & Serializable)timeout -> builder.readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS));
            options.writeTimeout().foreach((Function1 & Serializable)timeout -> builder.writeTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS));
        });
        return builder.build();
    }

    private Option<RequestOptions> okHttpClient$default$1() {
        return None$.MODULE$;
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.httpClient.dispatcher().executorService().shutdown();
            this.httpClient.connectionPool().evictAll();
            Cache cache = this.httpClient.cache();
            if (cache != null) {
                cache.close();
                return;
            }
            return;
        }
    }

    @Override
    public <T> T execute(HttpRequest httpRequest, Option<RequestOptions> requestOptions, Manifest<T> evidence$1) {
        T t;
        if (this.isClosed.get()) {
            throw new IllegalStateException("HttpRequester is closed");
        }
        HttpUrl url = this.createHttpUrl(httpRequest, requestOptions);
        Headers headers = this.createHeaders(httpRequest, requestOptions);
        RequestBody requestBody = this.createRequestBody(httpRequest);
        Request.Builder requestBuilder = new Request.Builder().url(url).headers(headers).method(httpRequest.method(), requestBody);
        if (httpRequest.read()) {
            requestBuilder.tag((Object)UseReadTransporter$.MODULE$);
        }
        Request request = requestBuilder.build();
        OkHttpClient client = this.okHttpClient(requestOptions);
        Call call = client.newCall(request);
        try (Response response = null;){
            try {
                response = call.execute();
                if (!response.isSuccessful()) {
                    String string = response.message();
                    int n = response.code();
                    Throwable throwable = AlgoliaApiException$.MODULE$.$lessinit$greater$default$2();
                    throw AlgoliaApiException$.MODULE$.apply(string, throwable, n);
                }
                t = this.algoliasearch$internal$HttpRequester$$jsonSerializer.deserialize(response.body().byteStream(), evidence$1);
            }
            catch (IOException exception) {
                throw AlgoliaClientException$.MODULE$.apply(AlgoliaClientException$.MODULE$.$lessinit$greater$default$1(), exception);
            }
        }
        return t;
    }

    public <T> Option<RequestOptions> execute$default$2() {
        return None$.MODULE$;
    }

    public static class Builder {
        private final Formats formats;
        private final ListBuffer<Interceptor> interceptors;
        private final ListBuffer<Interceptor> networkInterceptors;
        private Option<Function1<OkHttpClient.Builder, ?>> clientConfig;

        public Builder(Formats formats) {
            this.formats = formats;
            this.interceptors = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Interceptor[0]));
            this.networkInterceptors = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Interceptor[0]));
            this.clientConfig = None$.MODULE$;
        }

        public Formats formats() {
            return this.formats;
        }

        public ListBuffer<Interceptor> interceptors() {
            return this.interceptors;
        }

        public ListBuffer<Interceptor> networkInterceptors() {
            return this.networkInterceptors;
        }

        public Option<Function1<OkHttpClient.Builder, ?>> clientConfig() {
            return this.clientConfig;
        }

        public void clientConfig_$eq(Option<Function1<OkHttpClient.Builder, ?>> x$1) {
            this.clientConfig = x$1;
        }

        public Builder withInterceptor(Interceptor interceptor) {
            this.interceptors().$plus$eq((Object)interceptor);
            return this;
        }

        public Builder withNetworkInterceptor(Interceptor interceptor) {
            this.networkInterceptors().$plus$eq((Object)interceptor);
            return this;
        }

        public Builder withHttpClientConfig(Function1<OkHttpClient.Builder, ?> config) {
            this.clientConfig_$eq(Option$.MODULE$.apply(config));
            return this;
        }

        public HttpRequester build(ClientConfig config) {
            return new HttpRequester(this, config);
        }
    }
}

