/*
 * Decompiled with CFR 0.152.
 */
package algoliasearch.internal.interceptor;

import algoliasearch.config.CallType;
import algoliasearch.config.CallType$Read$;
import algoliasearch.config.CallType$Write$;
import algoliasearch.exception.AlgoliaApiException;
import algoliasearch.exception.AlgoliaApiException$;
import algoliasearch.exception.AlgoliaClientException$;
import algoliasearch.exception.AlgoliaRequestException;
import algoliasearch.exception.AlgoliaRequestException$;
import algoliasearch.exception.AlgoliaRetryException$;
import algoliasearch.internal.StatefulHost;
import algoliasearch.internal.interceptor.RetryStrategy$;
import algoliasearch.internal.util.UseReadTransporter$;
import algoliasearch.internal.util.package$;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.function.JProcedure1;

public class RetryStrategy
implements Interceptor {
    private final List<StatefulHost> hosts;

    public static Duration expirationThreshold() {
        return RetryStrategy$.MODULE$.expirationThreshold();
    }

    public RetryStrategy(List<StatefulHost> hosts) {
        this.hosts = hosts;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Response intercept(Interceptor.Chain chain) {
        var2_2 = new Object();
        try {
            request = chain.request();
            useReadTransporter = (UseReadTransporter$)request.tag();
            if (useReadTransporter != null) ** GOTO lbl-1000
            v0 = request.method();
            var6_5 = "GET";
            if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) lbl-1000:
            // 2 sources

            {
                v1 /* !! */  = CallType$Read$.MODULE$;
            } else {
                v1 /* !! */  = CallType$Write$.MODULE$;
            }
            callType = v1 /* !! */ ;
            errors = new ListBuffer();
            this.callableHosts(callType).foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, intercept$$anonfun$1(java.lang.Object okhttp3.Interceptor$Chain okhttp3.Request scala.collection.mutable.ListBuffer algoliasearch.internal.StatefulHost ), (Lalgoliasearch/internal/StatefulHost;)V)((RetryStrategy)this, (Object)var2_2, (Interceptor.Chain)chain, (Request)request, (ListBuffer)errors));
            throw AlgoliaRetryException$.MODULE$.apply((List<Throwable>)errors.toList());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != var2_2) {
                throw ex;
            }
            return (Response)ex.value();
        }
    }

    private Response processRequest(Interceptor.Chain chain, Request request, StatefulHost host) {
        HttpUrl.Builder urlBuilder = request.url().newBuilder().scheme(host.getScheme()).host(host.getHost());
        if (host.getPort().isDefined()) {
            urlBuilder.port(BoxesRunTime.unboxToInt((Object)host.getPort().get()));
        }
        HttpUrl newUrl = urlBuilder.build();
        Request newRequest = request.newBuilder().url(newUrl).build();
        chain.withConnectTimeout(chain.connectTimeoutMillis() * (host.getRetryCount() + 1), TimeUnit.MILLISECONDS);
        Response response = chain.proceed(newRequest);
        return this.handleResponse(host, response);
    }

    private Response handleResponse(StatefulHost host, Response response) {
        if (response.isSuccessful()) {
            host.reset();
            return response;
        }
        try {
            String message;
            String string = message = response.body() != null ? response.body().string() : response.message();
            if (this.isRetryable(response)) {
                int n = response.code();
                Throwable throwable = AlgoliaRequestException$.MODULE$.$lessinit$greater$default$2();
                throw AlgoliaRequestException$.MODULE$.apply(message, throwable, n);
            }
            int n = response.code();
            Throwable throwable = AlgoliaApiException$.MODULE$.$lessinit$greater$default$2();
            throw AlgoliaApiException$.MODULE$.apply(message, throwable, n);
        }
        catch (Throwable throwable) {
            response.close();
            throw throwable;
        }
    }

    private boolean isRetryable(Response response) {
        int statusCode = response.code();
        return !(statusCode >= 200 && statusCode < 300 || statusCode >= 400 && statusCode < 500);
    }

    private List<StatefulHost> callableHosts(CallType callType) {
        List list;
        RetryStrategy retryStrategy = this;
        synchronized (retryStrategy) {
            List list2;
            this.resetExpiredHosts();
            List hostsCallType = this.hosts.filter((Function1 & Serializable)_$1 -> _$1.getAccept().contains((Object)callType));
            List hostsCallTypeAreUp = hostsCallType.filter((Function1 & Serializable)_$2 -> _$2.isUp());
            if (hostsCallTypeAreUp.isEmpty()) {
                hostsCallType.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.reset());
                list2 = hostsCallType;
            } else {
                list2 = hostsCallTypeAreUp;
            }
            list = list2;
        }
        return list;
    }

    private void resetExpiredHosts() {
        OffsetDateTime now = package$.MODULE$.currentDateTime();
        this.hosts.foreach((Function1)(JProcedure1 & Serializable)host -> {
            long lastUse = Duration.between(host.getLastUse(), now).getSeconds();
            if (!host.isUp() && lastUse > RetryStrategy$.MODULE$.expirationThreshold().getSeconds()) {
                host.reset();
                return;
            }
        });
    }

    private void handleException(StatefulHost currentHost, Exception exception) {
        Exception exception2 = exception;
        if (exception2 instanceof SocketTimeoutException) {
            currentHost.hasTimedOut();
            return;
        }
        if (exception2 instanceof AlgoliaRequestException || exception2 instanceof IOException) {
            currentHost.hasFailed();
            return;
        }
        if (exception2 instanceof AlgoliaApiException) {
            AlgoliaApiException e = (AlgoliaApiException)exception2;
            throw e;
        }
        throw AlgoliaClientException$.MODULE$.apply(AlgoliaClientException$.MODULE$.$lessinit$greater$default$1(), exception);
    }

    private final /* synthetic */ void intercept$$anonfun$1(Object nonLocalReturnKey1$1, Interceptor.Chain chain$1, Request request$1, ListBuffer errors$1, StatefulHost currentHost) {
        try {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)this.processRequest(chain$1, request$1, currentHost));
        }
        catch (Exception exception) {
            errors$1.$plus$eq((Object)exception);
            this.handleException(currentHost, exception);
            return;
        }
    }
}

