/*
 * Decompiled with CFR 0.152.
 */
package algoliasearch.internal;

import algoliasearch.exception.AlgoliaClientException$;
import algoliasearch.internal.JsonSerializer$;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.native.JsonParser$;
import org.json4s.native.Serialization$;
import org.json4s.package$;
import scala.reflect.Manifest;

public class JsonSerializer {
    private final Formats formats;

    public static JsonSerializer apply(Formats formats) {
        return JsonSerializer$.MODULE$.apply(formats);
    }

    public JsonSerializer(Formats formats) {
        this.formats = formats;
    }

    public Formats formats() {
        return this.formats;
    }

    public <T> void serialize(OutputStream stream, T obj) {
        try (OutputStreamWriter writer = new OutputStreamWriter(stream);){
            try {
                String json = Serialization$.MODULE$.write(obj, this.formats());
                writer.write(json);
                writer.flush();
            }
            catch (Exception e) {
                throw AlgoliaClientException$.MODULE$.apply(AlgoliaClientException$.MODULE$.$lessinit$greater$default$1(), e);
            }
        }
    }

    public <T> T deserialize(InputStream stream, Manifest<T> evidence$1) {
        Object object;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            try {
                JValue json = JsonParser$.MODULE$.parse((Reader)reader, JsonParser$.MODULE$.parse$default$2(), JsonParser$.MODULE$.parse$default$3(), JsonParser$.MODULE$.parse$default$4());
                object = ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(json), this.formats(), evidence$1);
            }
            catch (Exception e) {
                throw AlgoliaClientException$.MODULE$.apply(AlgoliaClientException$.MODULE$.$lessinit$greater$default$1(), e);
            }
        }
        return (T)object;
    }
}

