/*
 * Decompiled with CFR 0.152.
 */
package algoliasearch.internal;

import algoliasearch.config.CallType;
import algoliasearch.config.Host;
import algoliasearch.internal.StatefulHost$;
import algoliasearch.internal.util.package$;
import java.time.OffsetDateTime;
import scala.Option;
import scala.collection.Set;

public class StatefulHost {
    private final Host host;
    private boolean up;
    private int retryCount;
    private OffsetDateTime lastUse;

    public static StatefulHost apply(Host host) {
        return StatefulHost$.MODULE$.apply(host);
    }

    public StatefulHost(Host host) {
        this.host = host;
        this.up = true;
        this.retryCount = 0;
        this.lastUse = package$.MODULE$.currentDateTime();
    }

    private Host host() {
        return this.host;
    }

    public String getHost() {
        return this.host().url();
    }

    public String getScheme() {
        return this.host().scheme();
    }

    public Option<Object> getPort() {
        return this.host().port();
    }

    public boolean isUp() {
        return this.up;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void incrementRetryCount() {
        ++this.retryCount;
    }

    public OffsetDateTime getLastUse() {
        return this.lastUse;
    }

    public Set<CallType> getAccept() {
        return this.host().callTypes();
    }

    public void reset() {
        this.up = true;
        this.lastUse = package$.MODULE$.currentDateTime();
        this.retryCount = 0;
    }

    public void hasTimedOut() {
        this.up = true;
        this.lastUse = package$.MODULE$.currentDateTime();
        ++this.retryCount;
    }

    public void hasFailed() {
        this.up = false;
        this.lastUse = package$.MODULE$.currentDateTime();
    }
}

