/*
 * Decompiled with CFR 0.152.
 */
package algoliasearch.internal.interceptor;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import scala.Function1;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public class GzipRequestInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) {
        Request originalRequest = chain.request();
        if (originalRequest.body() == null || originalRequest.header("Content-Encoding") != null) {
            return chain.proceed(originalRequest);
        }
        Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "gzip").method(originalRequest.method(), this.gzip(originalRequest.body())).build();
        return chain.proceed(compressedRequest);
    }

    private RequestBody gzip(RequestBody body) {
        return new RequestBody(body){
            private final RequestBody body$1;
            {
                this.body$1 = body$2;
            }

            public MediaType contentType() {
                return this.body$1.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(BufferedSink sink) {
                Using$.MODULE$.apply(() -> GzipRequestInterceptor.algoliasearch$internal$interceptor$GzipRequestInterceptor$$anon$1$$_$writeTo$$anonfun$1(sink), (Function1)(JProcedure1 & Serializable)gzipSink -> this.body$1.writeTo(gzipSink), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{algoliasearch$internal$interceptor$GzipRequestInterceptor$$anon$1$$_$writeTo$$anonfun$1(okio.BufferedSink ), writeTo$$anonfun$2(okio.BufferedSink )}, serializedLambda);
            }
        };
    }

    public static final BufferedSink algoliasearch$internal$interceptor$GzipRequestInterceptor$$anon$1$$_$writeTo$$anonfun$1(BufferedSink sink$1) {
        return Okio.buffer((Sink)new GzipSink((Sink)sink$1));
    }
}

